/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds.io;

import b.b;
import java.io.InputStream;
import java.util.logging.Logger;

public class PositionInputStream
extends InputStream {
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd");
    private static final long MARK_NOT_SET = -1L;
    private InputStream carrier;
    private long position;
    private long markedPosition;

    public PositionInputStream(InputStream inputStream) {
        this.carrier = inputStream;
        this.position = 0L;
        this.markedPosition = -1L;
    }

    @Override
    public int read() {
        int n3 = this.carrier.read();
        if (n3 >= 0) {
            ++this.position;
        }
        return n3;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n3, int n4) {
        int n5 = this.carrier.read(byArray, n3, n4);
        this.position += (long)n5;
        return n5;
    }

    @Override
    public long skip(long l3) {
        long l4 = this.carrier.skip(l3);
        if (l4 <= 0L) {
            LOGGER.warning(b.a("Carrier (").append(this.carrier.getClass().getCanonicalName()).append(")'s skip(").append(l3).append(") only skipped ").append(l4).append(", position = ").append(this.position).toString());
        }
        this.position += l4;
        return l4;
    }

    @Override
    public synchronized void mark(int n3) {
        PositionInputStream positionInputStream = this;
        positionInputStream.carrier.mark(n3);
        positionInputStream.markedPosition = positionInputStream.position;
    }

    @Override
    public synchronized void reset() {
        PositionInputStream positionInputStream = this;
        positionInputStream.carrier.reset();
        positionInputStream.position = positionInputStream.markedPosition;
    }

    @Override
    public boolean markSupported() {
        return this.carrier.markSupported();
    }

    public long getPosition() {
        return this.position;
    }
}

