/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds.iso19794;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.h;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.BiometricDataBlock;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.StandardBiometricHeader;
import com.fis.ekyc.nfc.build_in.eidparser.lds.AbstractListInfo;
import com.fis.ekyc.nfc.build_in.eidparser.lds.iso19794.FaceImageInfo;
import com.fis.ekyc.nfc.build_in.scuba.data.Gender;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FaceInfo
extends AbstractListInfo<FaceImageInfo>
implements BiometricDataBlock {
    private static final long serialVersionUID = -6053206262773400725L;
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd");
    private static final int FORMAT_IDENTIFIER = 1178682112;
    private static final int VERSION_NUMBER = 0x30313000;
    private static final int FORMAT_OWNER_VALUE = 257;
    private static final int FORMAT_TYPE_VALUE = 8;
    private StandardBiometricHeader sbh;

    public FaceInfo(List<FaceImageInfo> list) {
        this(null, list);
    }

    public FaceInfo(StandardBiometricHeader standardBiometricHeader, List<FaceImageInfo> list) {
        FaceInfo faceInfo = this;
        faceInfo.sbh = standardBiometricHeader;
        faceInfo.addAll(list);
    }

    public FaceInfo(InputStream inputStream) {
        this(null, inputStream);
    }

    public FaceInfo(StandardBiometricHeader standardBiometricHeader, InputStream inputStream) {
        FaceInfo faceInfo = this;
        faceInfo.sbh = standardBiometricHeader;
        faceInfo.readObject(inputStream);
    }

    @Override
    public void readObject(InputStream closeable) {
        Object object;
        if (closeable instanceof DataInputStream) {
            object = (DataInputStream)closeable;
        } else {
            DataInputStream dataInputStream;
            object = dataInputStream;
            dataInputStream = new DataInputStream((InputStream)closeable);
        }
        int n3 = ((DataInputStream)object).readInt();
        if (n3 != 1178682112) {
            LOGGER.log(Level.WARNING, b.a("'FAC' marker expected! Found ").append(Integer.toHexString(n3)).toString());
            if (n3 == 12) {
                ByteArrayInputStream byteArrayInputStream;
                Object object2;
                int n4;
                ByteArrayOutputStream byteArrayOutputStream;
                closeable = byteArrayOutputStream;
                byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)closeable);
                dataOutputStream.writeInt(n3);
                short s2 = ((DataInputStream)object).readShort();
                n3 = s2;
                dataOutputStream.writeShort(s2);
                for (int i3 = 0; i3 < n3 && (n4 = ((DataInputStream)object).read((byte[])(object2 = new byte[2048]))) >= 0; i3 += n4) {
                    ((OutputStream)closeable).write((byte[])object2);
                }
                FaceInfo faceInfo = object3;
                int[] nArray = new int[3];
                Object object3 = nArray;
                nArray[0] = 0;
                nArray[1] = 0;
                nArray[2] = 0;
                int[] nArray2 = new int[3];
                object = nArray2;
                nArray2[0] = 0;
                nArray2[1] = 0;
                nArray2[2] = 0;
                FaceImageInfo.FeaturePoint[] featurePointArray = new FaceImageInfo.FeaturePoint[]{};
                object2 = byteArrayInputStream;
                byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)closeable).toByteArray());
                faceInfo.add(new FaceImageInfo(Gender.UNKNOWN, FaceImageInfo.EyeColor.UNSPECIFIED, 0, 0, 0, (int[])object3, (int[])object, 1, 0, 0, 0, 0, featurePointArray, 0, 0, (InputStream)object2, n3, 1));
                return;
            }
        }
        if ((n3 = ((DataInputStream)object).readInt()) == 0x30313000) {
            DataInputStream dataInputStream = object;
            long l3 = ((long)dataInputStream.readInt() & 0xFFFFFFFFL) - 14L;
            long l4 = 0L;
            int n5 = dataInputStream.readUnsignedShort();
            for (int i4 = 0; i4 < n5; ++i4) {
                FaceImageInfo faceImageInfo = new FaceImageInfo((InputStream)closeable);
                l4 = faceImageInfo.getRecordLength() + l4;
                ((AbstractListInfo)object3).add(faceImageInfo);
            }
            if (l3 != l4) {
                LOGGER.warning("ConstructedDataLength and dataLength differ: dataLength = " + l3 + ", constructedDataLength = " + l4);
            }
            return;
        }
        throw new IllegalArgumentException(h.a(n3, b.a("'010' version number expected! Found ")));
    }

    @Override
    public void writeObject(OutputStream object) {
        DataOutputStream dataOutputStream;
        int n3 = 14;
        long l3 = 0L;
        List list = this.getSubRecords();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            l3 = ((FaceImageInfo)iterator.next()).getRecordLength() + l3;
        }
        l3 = (long)n3 + l3;
        if (object instanceof DataOutputStream) {
            dataOutputStream = (DataOutputStream)object;
        } else {
            DataOutputStream dataOutputStream2;
            dataOutputStream = dataOutputStream2;
            dataOutputStream2 = new DataOutputStream((OutputStream)object);
        }
        DataOutputStream dataOutputStream3 = dataOutputStream;
        dataOutputStream3.writeInt(1178682112);
        dataOutputStream3.writeInt(0x30313000);
        dataOutputStream.writeInt((int)(l3 & 0xFFFFFFFFL));
        dataOutputStream.writeShort(list.size());
        object = list.iterator();
        while (object.hasNext()) {
            ((FaceImageInfo)object.next()).writeObject(dataOutputStream);
        }
    }

    @Override
    public StandardBiometricHeader getStandardBiometricHeader() {
        if (this.sbh == null) {
            TreeMap<Integer, byte[]> treeMap;
            byte[] byArray = new byte[1];
            byte[] byArray2 = byArray;
            byArray[0] = 2;
            byte[] byArray3 = new byte[1];
            byte[] byArray4 = byArray3;
            byArray3[0] = 0;
            byte[] byArray5 = new byte[2];
            byte[] byArray6 = byArray5;
            byArray5[0] = 1;
            byArray5[1] = 1;
            byte[] byArray7 = new byte[2];
            byte[] byArray8 = byArray7;
            byArray7[0] = 0;
            byArray7[1] = 8;
            TreeMap<Integer, byte[]> treeMap2 = treeMap;
            new TreeMap<Integer, byte[]>().put(129, byArray2);
            treeMap2.put(130, byArray4);
            treeMap2.put(135, byArray6);
            treeMap2.put(136, byArray8);
            this.sbh = new StandardBiometricHeader(treeMap2);
        }
        return this.sbh;
    }

    public List<FaceImageInfo> getFaceImageInfos() {
        return this.getSubRecords();
    }

    public void addFaceImageInfo(FaceImageInfo faceImageInfo) {
        this.add(faceImageInfo);
    }

    public void removeFaceImageInfo(int n3) {
        this.remove(n3);
    }

    public String toString() {
        StringBuilder stringBuilder;
        FaceInfo faceInfo = serializable;
        Serializable serializable = stringBuilder;
        new StringBuilder().append("FaceInfo [");
        Iterator iterator = faceInfo.getSubRecords().iterator();
        while (iterator.hasNext()) {
            ((StringBuilder)serializable).append(((FaceImageInfo)iterator.next()).toString());
        }
        Serializable serializable2 = serializable;
        ((StringBuilder)serializable2).append("]");
        return ((StringBuilder)serializable2).toString();
    }

    @Override
    public int hashCode() {
        FaceInfo faceInfo = this;
        int n3 = super.hashCode() * 31;
        StandardBiometricHeader standardBiometricHeader = faceInfo.sbh;
        int n4 = standardBiometricHeader == null ? 0 : standardBiometricHeader.hashCode();
        return n3 + n4;
    }

    @Override
    public boolean equals(Object object) {
        if (serializable == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (serializable.getClass() != object.getClass()) {
            return false;
        }
        FaceInfo faceInfo = serializable;
        Serializable serializable = (FaceInfo)object;
        object = faceInfo.sbh;
        if (object == null) {
            return serializable.sbh == null;
        }
        serializable = serializable.sbh;
        return object == serializable || ((StandardBiometricHeader)object).equals(serializable);
    }
}

