/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds.iso19794;

import b.b;
import com.fis.ekyc.nfc.build_in.eidparser.lds.AbstractImageInfo;
import com.fis.ekyc.nfc.build_in.eidparser.lds.iso19794.FingerInfo;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class FingerImageInfo
extends AbstractImageInfo {
    private static final long serialVersionUID = -6625447389275461027L;
    public static final int POSITION_UNKNOWN_FINGER = 0;
    public static final int POSITION_RIGHT_THUMB = 1;
    public static final int POSITION_RIGHT_INDEX_FINGER = 2;
    public static final int POSITION_RIGHT_MIDDLE_FINGER = 3;
    public static final int POSITION_RIGHT_RING_FINGER = 4;
    public static final int POSITION_RIGHT_LITTLE_FINGER = 5;
    public static final int POSITION_LEFT_THUMB = 6;
    public static final int POSITION_LEFT_INDEX_FINGER = 7;
    public static final int POSITION_LEFT_MIDDLE_FINGER = 8;
    public static final int POSITION_LEFT_RING_FINGER = 9;
    public static final int POSITION_LEFT_LITTLE_FINGER = 10;
    public static final int POSITION_PLAIN_RIGHT_FOUR_FINGERS = 13;
    public static final int POSITION_PLAIN_LEFT_FOUR_FINGERS = 14;
    public static final int POSITION_PLAIN_THUMBS = 15;
    public static final int POSITION_UNKNOWN_PALM = 20;
    public static final int POSITION_RIGHT_FULL_PALM = 21;
    public static final int POSITION_RIGHT_WRITER_S_PALM = 22;
    public static final int POSITION_LEFT_FULL_PALM = 23;
    public static final int POSITION_LEFT_WRITER_S_PALM = 24;
    public static final int POSITION_RIGHT_LOWER_PALM = 25;
    public static final int POSITION_RIGHT_UPPER_PALM = 26;
    public static final int POSITION_LEFT_LOWER_PALM = 27;
    public static final int POSITION_LEFT_UPPER_PALM = 28;
    public static final int POSITION_RIGHT_OTHER = 29;
    public static final int POSITION_LEFT_OTHER = 30;
    public static final int POSITION_RIGHT_INTERDIGITAL = 31;
    public static final int POSITION_RIGHT_THENAR = 32;
    public static final int POSITION_RIGHT_HYPOTHENAR = 33;
    public static final int POSITION_LEFT_INTERDIGITAL = 34;
    public static final int POSITION_LEFT_THENAR = 35;
    public static final int POSITION_LEFT_HYPOTHENAR = 36;
    public static final int IMPRESSION_TYPE_LIVE_SCAN_PLAIN = 0;
    public static final int IMPRESSION_TYPE_LIVE_SCAN_ROLLED = 1;
    public static final int IMPRESSION_TYPE_NON_LIVE_SCAN_PLAIN = 2;
    public static final int IMPRESSION_TYPE_NON_LIVE_SCAN_ROLLED = 3;
    public static final int IMPRESSION_TYPE_LATENT = 7;
    public static final int IMPRESSION_TYPE_SWIPE = 8;
    public static final int IMPRESSION_TYPE_LIVE_SCAN_CONTACTLESS = 9;
    private static final byte[] FORMAT_TYPE_VALUE = new byte[]{0, 9};
    private long recordLength;
    private int position;
    private int viewCount;
    private int viewNumber;
    private int quality;
    private int impressionType;
    private int compressionAlgorithm;

    public FingerImageInfo(int n3, int n4, int n5, int n6, int n7, int n8, int n9, InputStream inputStream, int n10, int n11) {
        long l3 = n10;
        String string2 = FingerInfo.toMimeType(n11);
        super(2, n8, n9, inputStream, l3, string2);
        if (n6 >= 0 && n6 <= 100) {
            if (inputStream != null) {
                this.position = n3;
                this.viewCount = n4;
                this.viewNumber = n5;
                this.quality = n6;
                this.impressionType = n7;
                this.compressionAlgorithm = n11;
                this.recordLength = l3 + 14L;
                return;
            }
            throw new IllegalArgumentException("Null image");
        }
        throw new IllegalArgumentException("Quality needs to be a number between 0 and 100");
    }

    public FingerImageInfo(InputStream inputStream, int n3) {
        FingerImageInfo fingerImageInfo = this;
        super(2, FingerInfo.toMimeType(n3));
        fingerImageInfo.compressionAlgorithm = n3;
        fingerImageInfo.readObject(inputStream);
    }

    private static String positionToString(int n3) {
        switch (n3) {
            default: {
                return null;
            }
            case 36: {
                return "Left hypothenar";
            }
            case 35: {
                return "Left thenar";
            }
            case 34: {
                return "Left interdigital";
            }
            case 33: {
                return "Right hypothenar";
            }
            case 32: {
                return "Right thenar";
            }
            case 31: {
                return "Right interdigital";
            }
            case 30: {
                return "Left other";
            }
            case 29: {
                return "Right other";
            }
            case 28: {
                return "Left upper palm";
            }
            case 27: {
                return "Left lower palm";
            }
            case 26: {
                return "Right upper palm";
            }
            case 25: {
                return "Right lower palm";
            }
            case 24: {
                return "Left writer's palm";
            }
            case 23: {
                return "Left full palm";
            }
            case 22: {
                return "Right writer's palm";
            }
            case 21: {
                return "Right full palm";
            }
            case 20: {
                return "Unknown palm";
            }
            case 15: {
                return "Plain thumbs";
            }
            case 14: {
                return "Left four fingers";
            }
            case 13: {
                return "Right four fingers";
            }
            case 10: {
                return "Left little finger";
            }
            case 9: {
                return "Left ring finger";
            }
            case 8: {
                return "Left middle finger";
            }
            case 7: {
                return "Left index finger";
            }
            case 6: {
                return "Left thumb";
            }
            case 5: {
                return "Right little finger";
            }
            case 4: {
                return "Right ring finger";
            }
            case 3: {
                return "Right middle finger";
            }
            case 2: {
                return "Right index finger";
            }
            case 1: {
                return "Right thumb";
            }
            case 0: 
        }
        return "Unknown finger";
    }

    private static String impressionTypeToString(int n3) {
        switch (n3) {
            default: {
                return null;
            }
            case 9: {
                return "Live scan contactless";
            }
            case 8: {
                return "Swipe";
            }
            case 7: {
                return "Latent";
            }
            case 3: {
                return "Non-live scan rolled";
            }
            case 2: {
                return "Non-live scan plain";
            }
            case 1: {
                return "Live scan rolled";
            }
            case 0: 
        }
        return "Live scan plain";
    }

    private static int toBiometricSubtype(int n3) {
        switch (n3) {
            default: {
                return 0;
            }
            case 36: {
                return 2;
            }
            case 35: {
                return 2;
            }
            case 34: {
                return 2;
            }
            case 33: {
                return 1;
            }
            case 32: {
                return 1;
            }
            case 31: {
                return 1;
            }
            case 30: {
                return 2;
            }
            case 29: {
                return 1;
            }
            case 28: {
                return 2;
            }
            case 27: {
                return 2;
            }
            case 26: {
                return 1;
            }
            case 25: {
                return 1;
            }
            case 24: {
                return 2;
            }
            case 23: {
                return 2;
            }
            case 21: {
                return 1;
            }
            case 15: {
                return 4;
            }
            case 14: {
                return 2;
            }
            case 13: {
                return 1;
            }
            case 10: {
                return 22;
            }
            case 9: {
                return 18;
            }
            case 8: {
                return 14;
            }
            case 7: {
                return 10;
            }
            case 6: {
                return 6;
            }
            case 5: {
                return 21;
            }
            case 4: {
                return 17;
            }
            case 3: {
                return 13;
            }
            case 2: {
                return 9;
            }
            case 1: 
        }
        return 5;
    }

    public int getQuality() {
        return this.quality;
    }

    public int getPosition() {
        return this.position;
    }

    public int getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public int getViewCount() {
        return this.viewCount;
    }

    public int getViewNumber() {
        return this.viewNumber;
    }

    public int getImpressionType() {
        return this.impressionType;
    }

    @Override
    public void readObject(InputStream inputStream) {
        DataInputStream dataInputStream;
        if (inputStream instanceof DataInputStream) {
            dataInputStream = (DataInputStream)inputStream;
        } else {
            DataInputStream dataInputStream2;
            dataInputStream = dataInputStream2;
            dataInputStream2 = new DataInputStream(inputStream);
        }
        this.recordLength = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
        this.position = dataInputStream.readUnsignedByte();
        this.viewCount = dataInputStream.readUnsignedByte();
        this.viewNumber = dataInputStream.readUnsignedByte();
        this.quality = dataInputStream.readUnsignedByte();
        this.impressionType = dataInputStream.readUnsignedByte();
        this.setWidth(dataInputStream.readUnsignedShort());
        this.setHeight(dataInputStream.readUnsignedShort());
        dataInputStream.readUnsignedByte();
        this.readImage(inputStream, this.recordLength - 14L);
    }

    @Override
    public void writeObject(OutputStream outputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeImage(byteArrayOutputStream);
        byteArrayOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        long l3 = (long)byArray.length + 14L;
        if (outputStream instanceof DataOutputStream) {
            outputStream = (DataOutputStream)outputStream;
        } else {
            DataOutputStream dataOutputStream;
            DataOutputStream dataOutputStream2 = dataOutputStream;
            dataOutputStream = new DataOutputStream(outputStream);
            outputStream = dataOutputStream2;
        }
        OutputStream outputStream2 = outputStream;
        OutputStream outputStream3 = outputStream;
        ((DataOutputStream)outputStream).writeInt((int)(l3 & 0xFFFFFFFFL));
        ((DataOutputStream)outputStream).writeByte(this.position);
        ((DataOutputStream)outputStream).writeByte(this.viewCount);
        ((DataOutputStream)outputStream).writeByte(this.viewNumber);
        ((DataOutputStream)outputStream).writeByte(this.quality);
        ((DataOutputStream)outputStream).writeByte(this.impressionType);
        ((DataOutputStream)outputStream).writeShort(this.getWidth());
        ((DataOutputStream)outputStream3).writeShort(this.getHeight());
        ((DataOutputStream)outputStream3).writeByte(0);
        outputStream2.write(byArray);
        ((DataOutputStream)outputStream2).flush();
    }

    @Override
    public long getRecordLength() {
        return this.recordLength;
    }

    public byte[] getFormatType() {
        return FORMAT_TYPE_VALUE;
    }

    public int getBiometricSubtype() {
        return FingerImageInfo.toBiometricSubtype(this.position);
    }

    @Override
    public int hashCode() {
        long l3 = this.recordLength;
        return ((((((super.hashCode() * 31 + this.compressionAlgorithm) * 31 + this.impressionType) * 31 + this.position) * 31 + this.quality) * 31 + (int)(l3 ^ l3 >>> 32)) * 31 + this.viewCount) * 31 + this.viewNumber;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (FingerImageInfo)object;
        return this.compressionAlgorithm == ((FingerImageInfo)object).compressionAlgorithm && this.impressionType == ((FingerImageInfo)object).impressionType && this.position == ((FingerImageInfo)object).position && this.quality == ((FingerImageInfo)object).quality && this.recordLength == ((FingerImageInfo)object).recordLength && this.viewCount == ((FingerImageInfo)object).viewCount && this.viewNumber == ((FingerImageInfo)object).viewNumber;
    }

    @Override
    public String toString() {
        return b.a("FingerImageInfo [quality: ").append(this.quality).append(", position: ").append(FingerImageInfo.positionToString(this.position)).append(", impression type: ").append(FingerImageInfo.impressionTypeToString(this.impressionType)).append(", horizontal line length: ").append(this.getWidth()).append(", vertical line length: ").append(this.getHeight()).append(", image: ").append(this.getWidth()).append(" x ").append(this.getHeight()).append(" \"").append(FingerInfo.toMimeType(this.compressionAlgorithm)).append("\"]").toString();
    }
}

