/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds.iso19794;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.h;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.BiometricDataBlock;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.StandardBiometricHeader;
import com.fis.ekyc.nfc.build_in.eidparser.lds.AbstractListInfo;
import com.fis.ekyc.nfc.build_in.eidparser.lds.iso19794.FingerImageInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Logger;

public class FingerInfo
extends AbstractListInfo<FingerImageInfo>
implements BiometricDataBlock {
    private static final long serialVersionUID = 5808625058034008176L;
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd");
    private static final int FORMAT_IDENTIFIER = 1179210240;
    private static final int VERSION_NUMBER = 0x30313000;
    private static final int FORMAT_OWNER_VALUE = 257;
    private static final int FORMAT_TYPE_VALUE = 7;
    public static final int SCALE_UNITS_PPI = 1;
    public static final int SCALE_UNITS_PPCM = 2;
    public static final int COMPRESSION_UNCOMPRESSED_NO_BIT_PACKING = 0;
    public static final int COMPRESSION_UNCOMPRESSED_BIT_PACKED = 1;
    public static final int COMPRESSION_WSQ = 2;
    public static final int COMPRESSION_JPEG = 3;
    public static final int COMPRESSION_JPEG2000 = 4;
    public static final int COMPRESSION_PNG = 5;
    private int captureDeviceId;
    private int acquisitionLevel;
    private int scaleUnits;
    private int scanResolutionHorizontal;
    private int scanResolutionVertical;
    private int imageResolutionHorizontal;
    private int imageResolutionVertical;
    private int depth;
    private int compressionAlgorithm;
    private StandardBiometricHeader sbh;

    public FingerInfo(int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, List<FingerImageInfo> list) {
        this(null, n3, n4, n5, n6, n7, n8, n9, n10, n11, list);
    }

    public FingerInfo(StandardBiometricHeader standardBiometricHeader, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, List<FingerImageInfo> list) {
        FingerInfo fingerInfo = this;
        fingerInfo.sbh = standardBiometricHeader;
        fingerInfo.captureDeviceId = n3;
        fingerInfo.acquisitionLevel = n4;
        fingerInfo.scaleUnits = n5;
        fingerInfo.scanResolutionHorizontal = n6;
        fingerInfo.scanResolutionVertical = n7;
        fingerInfo.imageResolutionHorizontal = n8;
        fingerInfo.imageResolutionVertical = n9;
        fingerInfo.depth = n10;
        fingerInfo.compressionAlgorithm = n11;
        fingerInfo.addAll(list);
    }

    public FingerInfo(InputStream inputStream) {
        this(null, inputStream);
    }

    public FingerInfo(StandardBiometricHeader standardBiometricHeader, InputStream inputStream) {
        FingerInfo fingerInfo = this;
        fingerInfo.sbh = standardBiometricHeader;
        fingerInfo.readObject(inputStream);
    }

    private static long readUnsignedLong(InputStream object, int n3) {
        if (object instanceof DataInputStream) {
            object = (DataInputStream)object;
        } else {
            DataInputStream dataInputStream;
            DataInputStream dataInputStream2 = dataInputStream;
            dataInputStream = new DataInputStream((InputStream)object);
            object = dataInputStream2;
        }
        InputStream inputStream = object;
        byte[] byArray = new byte[n3];
        object = byArray;
        ((DataInputStream)inputStream).readFully(byArray);
        long l3 = 0L;
        for (int i3 = 0; i3 < n3; ++i3) {
            l3 = (l3 << 8) + (long)(object[i3] & 0xFF);
        }
        return l3;
    }

    private static void writeLong(long l3, OutputStream outputStream, int n3) {
        if (n3 > 0) {
            int n4;
            for (n4 = 0; n4 < n3 - 8; ++n4) {
                outputStream.write(0);
            }
            if (n3 > 8) {
                n3 = 8;
            }
            --n3;
            while (n3 >= 0) {
                n4 = n3 * 8;
                outputStream.write((byte)((l3 & 255L << n4) >> n4));
                --n3;
            }
        }
    }

    public static String toMimeType(int n3) {
        switch (n3) {
            default: {
                return null;
            }
            case 5: {
                return "image/png";
            }
            case 4: {
                return "image/jpeg2000";
            }
            case 3: {
                return "image/jpeg";
            }
            case 2: {
                return "image/x-wsq";
            }
            case 1: {
                return "image/raw";
            }
            case 0: 
        }
        return "image/raw";
    }

    public static int fromMimeType(String string2) {
        if ("image/x-wsq".equals(string2)) {
            return 2;
        }
        if ("image/jpeg".equals(string2)) {
            return 3;
        }
        if ("image/jpeg2000".equals(string2)) {
            return 4;
        }
        if ("images/png".equals(string2)) {
            return 5;
        }
        throw new IllegalArgumentException("Did not recognize mimeType");
    }

    private int getBiometricSubtype() {
        int n3 = 0;
        int n4 = 1;
        Iterator iterator = this.getSubRecords().iterator();
        while (iterator.hasNext()) {
            int n5 = ((FingerImageInfo)iterator.next()).getBiometricSubtype();
            if (n4 != 0) {
                n4 = n3 = 0;
                n3 = n5;
                continue;
            }
            n3 &= n5;
        }
        return n3;
    }

    public int getCaptureDeviceId() {
        return this.captureDeviceId;
    }

    public int getAcquisitionLevel() {
        return this.acquisitionLevel;
    }

    public int getScaleUnits() {
        return this.scaleUnits;
    }

    public int getHorizontalScanningResolution() {
        return this.scanResolutionHorizontal;
    }

    public int getVerticalScanningResolution() {
        return this.scanResolutionVertical;
    }

    public int getHorizontalImageResolution() {
        return this.imageResolutionHorizontal;
    }

    public int getVerticalImageResolution() {
        return this.imageResolutionVertical;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    @Override
    public void readObject(InputStream inputStream) {
        DataInputStream dataInputStream;
        if (inputStream instanceof DataInputStream) {
            dataInputStream = (DataInputStream)inputStream;
        } else {
            DataInputStream dataInputStream2;
            dataInputStream = dataInputStream2;
            dataInputStream2 = new DataInputStream(inputStream);
        }
        int n3 = dataInputStream.readInt();
        if (n3 == 1179210240) {
            n3 = dataInputStream.readInt();
            if (n3 == 0x30313000) {
                long l3 = FingerInfo.readUnsignedLong(dataInputStream, 6);
                DataInputStream dataInputStream3 = dataInputStream;
                this.captureDeviceId = dataInputStream.readUnsignedShort();
                this.acquisitionLevel = dataInputStream.readUnsignedShort();
                int n4 = dataInputStream3.readUnsignedByte();
                this.scaleUnits = dataInputStream3.readUnsignedByte();
                this.scanResolutionHorizontal = dataInputStream.readUnsignedShort();
                this.scanResolutionVertical = dataInputStream.readUnsignedShort();
                this.imageResolutionHorizontal = dataInputStream.readUnsignedShort();
                this.imageResolutionVertical = dataInputStream.readUnsignedShort();
                this.depth = dataInputStream.readUnsignedByte();
                this.compressionAlgorithm = dataInputStream.readUnsignedByte();
                dataInputStream.readUnsignedShort();
                long l4 = l3 - 32L;
                long l5 = 0L;
                for (int i3 = 0; i3 < n4; ++i3) {
                    FingerImageInfo fingerImageInfo = new FingerImageInfo(inputStream, this.compressionAlgorithm);
                    l5 = fingerImageInfo.getRecordLength() + l5;
                    this.add(fingerImageInfo);
                }
                if (l4 != l5) {
                    LOGGER.warning("ConstructedDataLength and dataLength differ: dataLength = " + l4 + ", constructedDataLength = " + l5);
                }
                return;
            }
            throw new IllegalArgumentException(h.a(n3, b.a("'010' version number expected! Found ")));
        }
        throw new IllegalArgumentException(h.a(n3, b.a("'FIR' marker expected! Found ")));
    }

    @Override
    public void writeObject(OutputStream outputStream) {
        long l3 = 32L;
        long l4 = 0L;
        List list = ((AbstractListInfo)((Object)iterator2)).getSubRecords();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            l4 = ((FingerImageInfo)iterator.next()).getRecordLength() + l4;
        }
        l3 += l4;
        if (outputStream instanceof DataOutputStream) {
            outputStream = (DataOutputStream)outputStream;
        } else {
            DataOutputStream dataOutputStream;
            DataOutputStream dataOutputStream2 = dataOutputStream;
            dataOutputStream = new DataOutputStream(outputStream);
            outputStream = dataOutputStream2;
        }
        OutputStream outputStream2 = outputStream;
        OutputStream outputStream3 = outputStream;
        ((DataOutputStream)outputStream3).writeInt(1179210240);
        ((DataOutputStream)outputStream3).writeInt(0x30313000);
        FingerInfo.writeLong(l3, outputStream3, 6);
        ((DataOutputStream)outputStream).writeShort(((FingerInfo)((Object)iterator2)).captureDeviceId);
        ((DataOutputStream)outputStream).writeShort(((FingerInfo)((Object)iterator2)).acquisitionLevel);
        ((DataOutputStream)outputStream).writeByte(list.size());
        ((DataOutputStream)outputStream).writeByte(((FingerInfo)((Object)iterator2)).scaleUnits);
        ((DataOutputStream)outputStream).writeShort(((FingerInfo)((Object)iterator2)).scanResolutionHorizontal);
        ((DataOutputStream)outputStream).writeShort(((FingerInfo)((Object)iterator2)).scanResolutionVertical);
        ((DataOutputStream)outputStream).writeShort(((FingerInfo)((Object)iterator2)).imageResolutionHorizontal);
        ((DataOutputStream)outputStream).writeShort(((FingerInfo)((Object)iterator2)).imageResolutionVertical);
        ((DataOutputStream)outputStream).writeByte(((FingerInfo)((Object)iterator2)).depth);
        ((DataOutputStream)outputStream2).writeByte(((FingerInfo)((Object)iterator2)).compressionAlgorithm);
        ((DataOutputStream)outputStream2).writeShort(0);
        Iterator iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            ((FingerImageInfo)iterator2.next()).writeObject(outputStream);
        }
    }

    @Override
    public int hashCode() {
        FingerInfo fingerInfo = this;
        int n3 = ((((((super.hashCode() * 31 + this.acquisitionLevel) * 31 + this.captureDeviceId) * 31 + this.compressionAlgorithm) * 31 + this.depth) * 31 + this.imageResolutionHorizontal) * 31 + this.imageResolutionVertical) * 31;
        StandardBiometricHeader standardBiometricHeader = fingerInfo.sbh;
        int n4 = standardBiometricHeader == null ? 0 : standardBiometricHeader.hashCode();
        return (((n3 + n4) * 31 + this.scaleUnits) * 31 + this.scanResolutionHorizontal) * 31 + this.scanResolutionVertical;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (FingerInfo)object;
        return this.acquisitionLevel == ((FingerInfo)object).acquisitionLevel && this.captureDeviceId == ((FingerInfo)object).captureDeviceId && this.compressionAlgorithm == ((FingerInfo)object).compressionAlgorithm && this.depth == ((FingerInfo)object).depth && this.imageResolutionHorizontal == ((FingerInfo)object).imageResolutionHorizontal && this.imageResolutionVertical == ((FingerInfo)object).imageResolutionVertical && this.scaleUnits == ((FingerInfo)object).scaleUnits && this.scanResolutionHorizontal == ((FingerInfo)object).scanResolutionHorizontal && this.scanResolutionVertical == ((FingerInfo)object).scanResolutionVertical;
    }

    public String toString() {
        StringBuilder stringBuilder;
        FingerInfo fingerInfo = serializable;
        Serializable serializable = stringBuilder;
        new StringBuilder().append("FingerInfo [");
        Iterator iterator = fingerInfo.getSubRecords().iterator();
        while (iterator.hasNext()) {
            ((StringBuilder)serializable).append(((FingerImageInfo)iterator.next()).toString());
        }
        Serializable serializable2 = serializable;
        ((StringBuilder)serializable2).append("]");
        return ((StringBuilder)serializable2).toString();
    }

    @Override
    public StandardBiometricHeader getStandardBiometricHeader() {
        if (this.sbh == null) {
            TreeMap<Integer, byte[]> treeMap;
            byte[] byArray = new byte[1];
            byte[] byArray2 = byArray;
            byArray[0] = 8;
            byte[] byArray3 = new byte[1];
            byte[] byArray4 = byArray3;
            byArray3[0] = (byte)this.getBiometricSubtype();
            byte[] byArray5 = new byte[2];
            byte[] byArray6 = byArray5;
            byArray5[0] = 1;
            byArray5[1] = 1;
            byte[] byArray7 = new byte[2];
            byte[] byArray8 = byArray7;
            byArray7[0] = 0;
            byArray7[1] = 7;
            TreeMap<Integer, byte[]> treeMap2 = treeMap;
            new TreeMap<Integer, byte[]>().put(129, byArray2);
            treeMap2.put(130, byArray4);
            treeMap2.put(135, byArray6);
            treeMap2.put(136, byArray8);
            this.sbh = new StandardBiometricHeader(treeMap2);
        }
        return this.sbh;
    }

    public List<FingerImageInfo> getFingerImageInfos() {
        return this.getSubRecords();
    }

    public void addFingerImageInfo(FingerImageInfo fingerImageInfo) {
        this.add(fingerImageInfo);
    }

    public void removeFingerImageInfo(int n3) {
        this.remove(n3);
    }
}

