/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds.iso19794;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.h;
import com.fis.ekyc.nfc.build_in.eidparser.lds.AbstractListInfo;
import com.fis.ekyc.nfc.build_in.eidparser.lds.iso19794.IrisImageInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;

public class IrisBiometricSubtypeInfo
extends AbstractListInfo<IrisImageInfo> {
    private static final long serialVersionUID = -6588640634764878039L;
    public static final int EYE_UNDEF = 0;
    public static final int EYE_RIGHT = 1;
    public static final int EYE_LEFT = 2;
    private int imageFormat;
    private int biometricSubtype;

    public IrisBiometricSubtypeInfo(int n3, int n4, List<IrisImageInfo> list) {
        IrisBiometricSubtypeInfo irisBiometricSubtypeInfo = this;
        irisBiometricSubtypeInfo.biometricSubtype = n3;
        irisBiometricSubtypeInfo.imageFormat = n4;
        irisBiometricSubtypeInfo.addAll(list);
    }

    public IrisBiometricSubtypeInfo(InputStream inputStream, int n3) {
        IrisBiometricSubtypeInfo irisBiometricSubtypeInfo = this;
        irisBiometricSubtypeInfo.imageFormat = n3;
        irisBiometricSubtypeInfo.readObject(inputStream);
    }

    private static String biometricSubtypeToString(int n3) {
        if (n3 != 0) {
            if (n3 != 1) {
                if (n3 == 2) {
                    return "Left eye";
                }
                throw new NumberFormatException(h.a(n3, b.a("Unknown biometric subtype: ")));
            }
            return "Right eye";
        }
        return "Undefined";
    }

    @Override
    public void readObject(InputStream inputStream) {
        DataInputStream dataInputStream;
        if (inputStream instanceof DataInputStream) {
            dataInputStream = (DataInputStream)inputStream;
        } else {
            DataInputStream dataInputStream2;
            dataInputStream = dataInputStream2;
            dataInputStream2 = new DataInputStream(inputStream);
        }
        this.biometricSubtype = dataInputStream.readUnsignedByte();
        int n3 = dataInputStream.readUnsignedShort();
        for (int i3 = 0; i3 < n3; ++i3) {
            IrisImageInfo irisImageInfo;
            IrisImageInfo irisImageInfo2 = irisImageInfo;
            new IrisImageInfo(inputStream, this.imageFormat).getRecordLength();
            this.add(irisImageInfo2);
        }
    }

    @Override
    public void writeObject(OutputStream outputStream) {
        if (outputStream instanceof DataOutputStream) {
            outputStream = (DataOutputStream)outputStream;
        } else {
            DataOutputStream dataOutputStream;
            DataOutputStream dataOutputStream2 = dataOutputStream;
            dataOutputStream = new DataOutputStream(outputStream);
            outputStream = dataOutputStream2;
        }
        ((DataOutputStream)outputStream).writeByte(((IrisBiometricSubtypeInfo)((Object)iterator)).biometricSubtype & 0xFF);
        List list = ((AbstractListInfo)((Object)iterator)).getSubRecords();
        ((DataOutputStream)outputStream).writeShort(list.size() & 0xFFFF);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((IrisImageInfo)iterator.next()).writeObject(outputStream);
        }
    }

    public long getRecordLength() {
        long l3 = 3L;
        Iterator iterator = ((AbstractListInfo)((Object)iterator)).getSubRecords().iterator();
        while (iterator.hasNext()) {
            l3 = ((IrisImageInfo)iterator.next()).getRecordLength() + l3;
        }
        return l3;
    }

    @Override
    public int hashCode() {
        return (super.hashCode() * 31 + this.biometricSubtype) * 31 + this.imageFormat;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (IrisBiometricSubtypeInfo)object;
        return this.biometricSubtype == ((IrisBiometricSubtypeInfo)object).biometricSubtype && this.imageFormat == ((IrisBiometricSubtypeInfo)object).imageFormat;
    }

    public String toString() {
        return b.a("IrisBiometricSubtypeInfo [biometric subtype: ").append(IrisBiometricSubtypeInfo.biometricSubtypeToString(this.biometricSubtype)).append(", imageCount = ").append(this.getSubRecords().size()).append("]").toString();
    }

    public int getBiometricSubtype() {
        return this.biometricSubtype;
    }

    public int getImageFormat() {
        return this.imageFormat;
    }

    public List<IrisImageInfo> getIrisImageInfos() {
        return this.getSubRecords();
    }

    public void addIrisImageInfo(IrisImageInfo irisImageInfo) {
        this.add(irisImageInfo);
    }

    public void removeIrisImageInfo(int n3) {
        this.remove(n3);
    }
}

