/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.protocol;

import b.b;
import com.fis.ekyc.nfc.build_in.eidparser.Util;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.SecureMessagingWrapper;
import com.fis.ekyc.nfc.build_in.scuba.util.Hex;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;

public class EACCAResult
implements Serializable {
    private static final long serialVersionUID = 4431711176589761513L;
    private BigInteger keyId;
    private PublicKey piccPublicKey;
    private SecureMessagingWrapper wrapper;
    private byte[] keyHash;
    private PublicKey pcdPublicKey;
    private PrivateKey pcdPrivateKey;

    public EACCAResult(BigInteger bigInteger, PublicKey publicKey, byte[] byArray, PublicKey publicKey2, PrivateKey privateKey, SecureMessagingWrapper secureMessagingWrapper) {
        this.keyId = bigInteger;
        this.piccPublicKey = publicKey;
        this.keyHash = byArray;
        this.pcdPublicKey = publicKey2;
        this.pcdPrivateKey = privateKey;
        this.wrapper = secureMessagingWrapper;
    }

    public BigInteger getKeyId() {
        return this.keyId;
    }

    public PublicKey getPublicKey() {
        return this.piccPublicKey;
    }

    public SecureMessagingWrapper getWrapper() {
        return this.wrapper;
    }

    public String toString() {
        return b.a("EACCAResult [keyId: ").append(this.keyId).append(", PICC public key: ").append(this.piccPublicKey).append(", wrapper: ").append(this.wrapper).append(", key hash: ").append(Hex.bytesToHexString(this.keyHash)).append(", PCD public key: ").append(Util.getDetailedPublicKeyAlgorithm(this.pcdPublicKey)).append(", PCD private key: ").append(Util.getDetailedPrivateKeyAlgorithm(this.pcdPrivateKey)).append("]").toString();
    }

    public int hashCode() {
        EACCAResult eACCAResult = this;
        int n3 = (Arrays.hashCode(eACCAResult.keyHash) + 31) * 31;
        BigInteger bigInteger = eACCAResult.keyId;
        int n4 = bigInteger == null ? 0 : bigInteger.hashCode();
        n3 = (n3 + n4) * 31;
        PublicKey publicKey = this.piccPublicKey;
        int n5 = publicKey == null ? 0 : publicKey.hashCode();
        n3 = (n3 + n5) * 31;
        PublicKey publicKey2 = this.pcdPublicKey;
        int n6 = publicKey2 == null ? 0 : publicKey2.hashCode();
        n3 = (n3 + n6) * 31;
        PrivateKey privateKey = this.pcdPrivateKey;
        int n7 = privateKey == null ? 0 : privateKey.hashCode();
        int n8 = (n3 + n7) * 31;
        SecureMessagingWrapper secureMessagingWrapper = this.wrapper;
        int n9 = secureMessagingWrapper == null ? 0 : secureMessagingWrapper.hashCode();
        return n8 + n9;
    }

    public boolean equals(Object object) {
        if (serializable2 == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (serializable2.getClass() != object.getClass()) {
            return false;
        }
        object = (EACCAResult)object;
        if (!Arrays.equals(((EACCAResult)serializable2).keyHash, ((EACCAResult)object).keyHash)) {
            return false;
        }
        Serializable serializable = ((EACCAResult)serializable2).keyId;
        if (serializable == null ? ((EACCAResult)object).keyId != null : !((BigInteger)serializable).equals(((EACCAResult)object).keyId)) {
            return false;
        }
        serializable = ((EACCAResult)serializable2).pcdPrivateKey;
        if (serializable == null ? ((EACCAResult)object).pcdPrivateKey != null : !serializable.equals(((EACCAResult)object).pcdPrivateKey)) {
            return false;
        }
        serializable = ((EACCAResult)serializable2).pcdPublicKey;
        if (serializable == null ? ((EACCAResult)object).pcdPublicKey != null : !serializable.equals(((EACCAResult)object).pcdPublicKey)) {
            return false;
        }
        serializable = ((EACCAResult)serializable2).piccPublicKey;
        if (serializable == null ? ((EACCAResult)object).piccPublicKey != null : !serializable.equals(((EACCAResult)object).piccPublicKey)) {
            return false;
        }
        Serializable serializable2 = ((EACCAResult)serializable2).wrapper;
        return !(serializable2 == null ? ((EACCAResult)object).wrapper != null : !((SecureMessagingWrapper)serializable2).equals(((EACCAResult)object).wrapper));
    }

    public byte[] getKeyHash() {
        return this.keyHash;
    }

    public PublicKey getPCDPublicKey() {
        return this.pcdPublicKey;
    }

    public PrivateKey getPCDPrivateKey() {
        return this.pcdPrivateKey;
    }
}

