/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.protocol;

import b.b;
import com.fis.ekyc.nfc.build_in.eidparser.Util;
import com.fis.ekyc.nfc.build_in.eidparser.cert.CVCPrincipal;
import com.fis.ekyc.nfc.build_in.eidparser.cert.CardVerifiableCertificate;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.EACCAResult;
import com.fis.ekyc.nfc.build_in.scuba.util.Hex;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EACTAResult
implements Serializable {
    private static final long serialVersionUID = -2926063872890928748L;
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd");
    private EACCAResult chipAuthenticationResult;
    private CVCPrincipal caReference;
    private List<CardVerifiableCertificate> terminalCertificates;
    private PrivateKey terminalKey;
    private String documentNumber;
    private byte[] cardChallenge;

    /*
     * WARNING - void declaration
     */
    public EACTAResult(EACCAResult object, CVCPrincipal serializable2, List<CardVerifiableCertificate> arrayList, PrivateKey privateKey, String string2, byte[] byArray) {
        void var6_8;
        void var5_7;
        void var4_6;
        ArrayList<CardVerifiableCertificate> arrayList2;
        ArrayList<CardVerifiableCertificate> arrayList3;
        void v02 = arrayList3;
        arrayList3 = arrayList2;
        arrayList2 = new ArrayList<CardVerifiableCertificate>();
        this.terminalCertificates = arrayList3;
        this.chipAuthenticationResult = object;
        this.caReference = serializable2;
        for (CardVerifiableCertificate cardVerifiableCertificate : v02) {
            this.terminalCertificates.add(cardVerifiableCertificate);
        }
        EACTAResult eACTAResult = this;
        eACTAResult.terminalKey = var4_6;
        eACTAResult.documentNumber = var5_7;
        eACTAResult.cardChallenge = var6_8;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object toString(CardVerifiableCertificate serializable) {
        block2: {
            StringBuilder stringBuilder;
            EACTAResult eACTAResult = serializable2;
            Serializable serializable2 = stringBuilder;
            new StringBuilder().append("CardVerifiableCertificate [");
            try {
                CVCPrincipal cVCPrincipal = ((CardVerifiableCertificate)serializable).getHolderReference();
                if (eACTAResult.caReference.equals(cVCPrincipal)) break block2;
                ((StringBuilder)serializable2).append("holderReference: " + cVCPrincipal);
            }
            catch (CertificateException certificateException) {
                ((StringBuilder)serializable2).append("holderReference = ???");
                LOGGER.log(Level.WARNING, "Exception", certificateException);
            }
        }
        Serializable serializable3 = serializable2;
        ((StringBuilder)serializable3).append("]");
        return ((StringBuilder)serializable3).toString();
    }

    public EACCAResult getChipAuthenticationResult() {
        return this.chipAuthenticationResult;
    }

    public CVCPrincipal getCAReference() {
        return this.caReference;
    }

    public List<CardVerifiableCertificate> getCVCertificates() {
        return this.terminalCertificates;
    }

    public PrivateKey getTerminalKey() {
        return this.terminalKey;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public byte[] getCardChallenge() {
        return this.cardChallenge;
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder().append(b.a("TAResult [chipAuthenticationResult: ").append(this.chipAuthenticationResult).toString()).append(", ");
        stringBuilder2.append("caReference: " + this.caReference).append(", ");
        stringBuilder2.append("terminalCertificates: [");
        boolean bl = true;
        for (CardVerifiableCertificate cardVerifiableCertificate : this.terminalCertificates) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder2.append(", ");
            }
            stringBuilder2.append(this.toString(cardVerifiableCertificate));
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append("terminalKey = ").append(Util.getDetailedPrivateKeyAlgorithm(this.terminalKey)).append(", ");
        stringBuilder3.append("documentNumber = ").append(this.documentNumber).append(", ");
        stringBuilder3.append("cardChallenge = ").append(Hex.bytesToHexString(this.cardChallenge)).append(", ");
        stringBuilder3.append("]");
        return stringBuilder3.toString();
    }

    public int hashCode() {
        int n3 = 31;
        CVCPrincipal cVCPrincipal = this.caReference;
        int n4 = cVCPrincipal == null ? 0 : cVCPrincipal.hashCode();
        EACTAResult eACTAResult = this;
        n3 = (n3 + n4) * 31;
        n3 = (Arrays.hashCode(eACTAResult.cardChallenge) + n3) * 31;
        EACCAResult eACCAResult = eACTAResult.chipAuthenticationResult;
        int n5 = eACCAResult == null ? 0 : eACCAResult.hashCode();
        n3 = (n3 + n5) * 31;
        String string2 = this.documentNumber;
        int n6 = string2 == null ? 0 : string2.hashCode();
        n3 = (n3 + n6) * 31;
        List<CardVerifiableCertificate> list = this.terminalCertificates;
        int n7 = list == null ? 0 : list.hashCode();
        int n8 = (n3 + n7) * 31;
        PrivateKey privateKey = this.terminalKey;
        int n9 = privateKey == null ? 0 : privateKey.hashCode();
        return n8 + n9;
    }

    public boolean equals(Object object) {
        if (serializable == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (serializable.getClass() != object.getClass()) {
            return false;
        }
        object = (EACTAResult)object;
        List<CardVerifiableCertificate> list = ((EACTAResult)serializable).caReference;
        if (list == null ? ((EACTAResult)object).caReference != null : !((CVCPrincipal)((Object)list)).equals(((EACTAResult)object).caReference)) {
            return false;
        }
        if (!Arrays.equals(((EACTAResult)serializable).cardChallenge, ((EACTAResult)object).cardChallenge)) {
            return false;
        }
        list = ((EACTAResult)serializable).chipAuthenticationResult;
        if (list == null ? ((EACTAResult)object).chipAuthenticationResult != null : !((EACCAResult)((Object)list)).equals(((EACTAResult)object).chipAuthenticationResult)) {
            return false;
        }
        list = ((EACTAResult)serializable).documentNumber;
        if (list == null ? ((EACTAResult)object).documentNumber != null : !((String)((Object)list)).equals(((EACTAResult)object).documentNumber)) {
            return false;
        }
        list = ((EACTAResult)serializable).terminalCertificates;
        if (list == null ? ((EACTAResult)object).terminalCertificates != null : !list.equals(((EACTAResult)object).terminalCertificates)) {
            return false;
        }
        Serializable serializable = ((EACTAResult)serializable).terminalKey;
        if (serializable == null) {
            return ((EACTAResult)object).terminalKey == null;
        }
        return serializable.equals(((EACTAResult)object).terminalKey);
    }
}

