/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.mrz;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.f;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.g;
import com.fis.ekyc.nfc.build_in.mrz.MrzParseException;
import com.fis.ekyc.nfc.build_in.mrz.MrzRange;
import com.fis.ekyc.nfc.build_in.mrz.MrzRecord;
import com.fis.ekyc.nfc.build_in.mrz.types.MrzDate;
import com.fis.ekyc.nfc.build_in.mrz.types.MrzFormat;
import com.fis.ekyc.nfc.build_in.mrz.types.MrzSex;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.Map;

public class MrzParser {
    private static final int[] MRZ_WEIGHTS = new int[]{7, 3, 1};
    private static final Map<String, String> EXPAND_CHARACTERS = new HashMap<String, String>();
    public static final char FILLER = '<';
    public final String mrz;
    public final String[] rows;
    public final MrzFormat format;

    public MrzParser(String string2) {
        this.mrz = string2;
        this.rows = string2.split("\n");
        this.format = MrzFormat.get(string2);
    }

    private static boolean isValid(char c3) {
        return c3 == '<' || c3 >= '0' && c3 <= '9' || c3 >= 'A' && c3 <= 'Z';
    }

    private static int getCharacterValue(char c3) {
        if (c3 == '<') {
            return 0;
        }
        if (c3 >= '0' && c3 <= '9') {
            return c3 - 48;
        }
        if (c3 >= 'A' && c3 <= 'Z') {
            return c3 - 65 + 10;
        }
        throw new RuntimeException("Invalid character in MRZ record: " + c3);
    }

    public static int computeCheckDigit(String string2) {
        int n3 = 0;
        for (int i3 = 0; i3 < string2.length(); ++i3) {
            n3 = MrzParser.getCharacterValue(string2.charAt(i3)) * MRZ_WEIGHTS[i3 % MRZ_WEIGHTS.length] + n3;
        }
        return n3 % 10;
    }

    public static char computeCheckDigitChar(String string2) {
        return (char)(MrzParser.computeCheckDigit(string2) + 48);
    }

    public static MrzRecord parse(String string2) {
        MrzRecord mrzRecord = MrzFormat.get(string2).newRecord();
        mrzRecord.fromMrz(string2);
        return mrzRecord;
    }

    public static String toMrz(String object, int n3) {
        StringBuilder stringBuilder;
        if (object == null) {
            object = "";
        }
        Object object2 = EXPAND_CHARACTERS.entrySet().iterator();
        while (object2.hasNext()) {
            String string2 = object;
            object = object2.next();
            object = string2.replace(object.getKey(), (CharSequence)object.getValue());
        }
        object = MrzParser.deaccent(((String)object).replace("\u2019", "").replace("'", "")).toUpperCase();
        if (n3 >= 0 && ((String)object).length() > n3) {
            object = ((String)object).substring(0, n3);
        }
        object2 = stringBuilder;
        stringBuilder = new StringBuilder((String)object);
        for (int i3 = 0; i3 < ((StringBuilder)object2).length(); ++i3) {
            if (MrzParser.isValid(((StringBuilder)object2).charAt(i3))) continue;
            ((StringBuilder)object2).setCharAt(i3, '<');
        }
        while (((StringBuilder)object2).length() < n3) {
            ((StringBuilder)object2).append('<');
        }
        return ((StringBuilder)object2).toString();
    }

    private static boolean isBlank(String string2) {
        return string2 == null || string2.trim().length() == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String nameToMrz(String string2, String string3, int n3) {
        int n4;
        if (MrzParser.isBlank(string2)) throw new IllegalArgumentException(g.a("Parameter surname: invalid value ", string2, ": blank"));
        if (MrzParser.isBlank(string3)) throw new IllegalArgumentException(g.a("Parameter givenNames: invalid value ", string3, ": blank"));
        if (n3 <= 0) throw new IllegalArgumentException(f.a("Parameter length: invalid value ", n3, ": not positive"));
        string2 = string2.replace(", ", " ");
        string3 = string3.replace(", ", " ");
        String[] stringArray = string2.trim().split("[ \n\t\f\r]+");
        String[] stringArray2 = string3.trim().split("[ \n\t\f\r]+");
        for (n4 = 0; n4 < stringArray.length; ++n4) {
            stringArray[n4] = MrzParser.toMrz(stringArray[n4], -1);
        }
        for (n4 = 0; n4 < stringArray2.length; ++n4) {
            stringArray2[n4] = MrzParser.toMrz(stringArray2[n4], -1);
        }
        n4 = MrzParser.getNameSize(stringArray, stringArray2);
        int n5 = stringArray2.length - 1;
        String[] stringArray3 = stringArray2;
        while (n4 > n3) {
            String string4 = stringArray3[n5];
            int n6 = string4.length();
            if (n4 - n6 + 1 <= n3) {
                stringArray3[n5] = string4.substring(0, n6 - (n4 - n3));
            } else {
                stringArray3[n5] = string4.substring(0, 1);
                n4 = n5 + -1;
                if (n4 < 0) {
                    if (stringArray3 == stringArray) throw new IllegalArgumentException("Cannot truncate name " + string2 + " " + string3 + ": length too small: " + n3 + "; truncated to " + MrzParser.toName(stringArray, stringArray2));
                    n4 = stringArray.length - 1;
                    stringArray3 = stringArray;
                    n5 = n4;
                } else {
                    n5 = n4;
                }
            }
            n4 = MrzParser.getNameSize(stringArray, stringArray2);
        }
        return MrzParser.toMrz(MrzParser.toName(stringArray, stringArray2), n3);
    }

    private static String toName(String[] stringArray, String[] stringArray2) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        int n3 = 1;
        for (String string2 : stringArray) {
            if (n3 != 0) {
                n3 = 0;
            } else {
                stringBuilder2.append('<');
            }
            stringBuilder2.append(string2);
        }
        stringBuilder2.append('<');
        int n4 = stringArray2.length;
        for (n3 = 0; n3 < n4; ++n3) {
            StringBuilder stringBuilder3 = stringBuilder2;
            String string3 = stringArray2[n3];
            stringBuilder3.append('<');
            stringBuilder3.append(string3);
        }
        return stringBuilder2.toString();
    }

    private static int getNameSize(String[] stringArray, String[] stringArray2) {
        int n3 = 0;
        int n4 = stringArray.length;
        for (int i3 = 0; i3 < n4; ++i3) {
            n3 = stringArray[i3].length() + 1 + n3;
        }
        int n5 = stringArray2.length;
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = stringArray2[n4].length() + 1 + n3;
        }
        return n3;
    }

    private static String deaccent(String string2) {
        return Normalizer.normalize(string2, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "").toLowerCase();
    }

    static {
        EXPAND_CHARACTERS.put("\u00c4", "AE");
        EXPAND_CHARACTERS.put("\u00e4", "AE");
        EXPAND_CHARACTERS.put("\u00c5", "AA");
        EXPAND_CHARACTERS.put("\u00e5", "AA");
        EXPAND_CHARACTERS.put("\u00c6", "AE");
        EXPAND_CHARACTERS.put("\u00e6", "AE");
        EXPAND_CHARACTERS.put("\u0132", "IJ");
        EXPAND_CHARACTERS.put("\u0133", "IJ");
        EXPAND_CHARACTERS.put("\u00d6", "OE");
        EXPAND_CHARACTERS.put("\u00f6", "OE");
        EXPAND_CHARACTERS.put("\u00d8", "OE");
        EXPAND_CHARACTERS.put("\u00f8", "OE");
        EXPAND_CHARACTERS.put("\u00dc", "UE");
        EXPAND_CHARACTERS.put("\u00fc", "UE");
        EXPAND_CHARACTERS.put("\u00df", "SS");
    }

    public String[] parseName(MrzRange mrzRange) {
        MrzParser mrzParser = this;
        mrzParser.checkValidCharacters(mrzRange);
        MrzRange[] mrzRangeArray = new MrzRange[1];
        Object object = mrzRangeArray;
        mrzRangeArray[0] = mrzRange;
        object = mrzParser.rawValue((MrzRange[])object);
        while (((String)object).endsWith("<")) {
            Object object2 = object;
            object = ((String)object2).substring(0, ((String)object2).length() - 1);
        }
        String[] stringArray = ((String)object).split("<<");
        String string2 = "";
        int n3 = mrzRange.column;
        int n4 = stringArray[0].length() + n3;
        int n5 = mrzRange.row;
        String string3 = this.parseString(new MrzRange(n3, n4, n5));
        if (stringArray.length == 1) {
            int n6 = mrzRange.column;
            int n7 = stringArray[0].length() + n6;
            int n8 = mrzRange.row;
            string2 = this.parseString(new MrzRange(n6, n7, n8));
            string3 = "";
        } else if (stringArray.length > 1) {
            MrzParser mrzParser2 = this;
            int n9 = mrzRange.column;
            int n10 = stringArray[0].length() + n9;
            int n11 = mrzRange.row;
            string3 = mrzParser2.parseString(new MrzRange(n9, n10, n11));
            n9 = mrzRange.column;
            n9 = stringArray[0].length() + n9 + 2;
            int n12 = mrzRange.column;
            n12 = ((String)object).length() + n12;
            int n13 = mrzRange.row;
            string2 = mrzParser2.parseString(new MrzRange(n9, n12, n13));
        }
        return new String[]{string3, string2};
    }

    public String rawValue(MrzRange ... mrzRangeArray) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        int n3 = mrzRangeArray.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            MrzRange mrzRange;
            MrzRange mrzRange2 = mrzRange = mrzRangeArray[i3];
            int n4 = mrzRange2.column;
            stringBuilder2.append(this.rows[mrzRange.row].substring(n4, mrzRange2.columnTo));
        }
        return stringBuilder2.toString();
    }

    public void checkValidCharacters(MrzRange mrzRange) {
        MrzRange[] mrzRangeArray = new MrzRange[1];
        Object object = mrzRangeArray;
        mrzRangeArray[0] = mrzRange;
        object = ((MrzParser)((Object)string2)).rawValue((MrzRange[])object);
        for (int i3 = 0; i3 < ((String)object).length(); ++i3) {
            MrzRange mrzRange2;
            char c3 = ((String)object).charAt(i3);
            if (c3 == '<' || c3 >= '0' && c3 <= '9' || c3 >= 'A' && c3 <= 'Z') continue;
            MrzParser mrzParser = string2;
            String string2 = "Invalid character in MRZ record: " + c3;
            object = mrzParser.mrz;
            MrzRange mrzRange3 = mrzRange2;
            MrzRange mrzRange4 = mrzRange;
            int n3 = mrzRange4.column;
            int n4 = n3 + i3;
            i3 = n3 + i3 + 1;
            int n5 = mrzRange4.row;
            mrzRange2 = new MrzRange(n4, i3, n5);
            MrzFormat mrzFormat = mrzParser.format;
            throw new MrzParseException(string2, (String)object, mrzRange3, mrzFormat);
        }
    }

    public String parseString(MrzRange mrzRange) {
        ((MrzParser)object).checkValidCharacters(mrzRange);
        MrzRange[] mrzRangeArray = new MrzRange[1];
        Object object = mrzRangeArray;
        mrzRangeArray[0] = mrzRange;
        object = ((MrzParser)object).rawValue((MrzRange[])object);
        while (((String)object).endsWith("<")) {
            Object object2 = object;
            object = ((String)object2).substring(0, ((String)object2).length() - 1);
        }
        return ((String)object).replace("<<", ", ").replace('<', ' ');
    }

    public boolean checkDigit(int n3, int n4, MrzRange mrzRange, String string2) {
        return this.checkDigit(n3, n4, this.rawValue(mrzRange), string2);
    }

    public boolean checkDigit(int n3, int n4, String string2, String string3) {
        MrzParser mrzParser = object;
        Object object = null;
        char c3 = (char)(MrzParser.computeCheckDigit(string2) + 48);
        char c4 = mrzParser.rows[n4].charAt(n3);
        if (c4 == '<') {
            c4 = '0';
        }
        if (c3 != c4) {
            MrzRange mrzRange;
            object = mrzRange;
            int n5 = n3;
            mrzRange = new MrzRange(n5, n5 + 1, n4);
            System.out.println("Check digit verification failed for " + string3 + ": expected " + c3 + " but got " + c4);
        }
        return object == null;
    }

    public MrzDate parseDate(MrzRange mrzRange) {
        if (mrzRange.length() == 6) {
            int n3;
            MrzRange mrzRange2;
            int n4;
            MrzRange mrzRange3;
            int n5;
            MrzRange mrzRange4;
            MrzRange mrzRange5 = mrzRange4;
            MrzRange mrzRange6 = mrzRange;
            int n6 = mrzRange6.column;
            int n7 = n6 + 2;
            int n8 = mrzRange6.row;
            mrzRange4 = new MrzRange(n6, n7, n8);
            try {
                n5 = Integer.parseInt(object.rawValue(mrzRange5));
            }
            catch (NumberFormatException numberFormatException) {
                n5 = -1;
            }
            MrzRange mrzRange7 = mrzRange3;
            MrzRange mrzRange8 = mrzRange;
            n7 = mrzRange8.column;
            n8 = n7 + 2;
            int n9 = mrzRange8.row;
            mrzRange3 = new MrzRange(n8, n7 += 4, n9);
            try {
                n4 = Integer.parseInt(object.rawValue(mrzRange7));
            }
            catch (NumberFormatException numberFormatException) {
                n4 = -1;
            }
            MrzRange mrzRange9 = mrzRange2;
            MrzRange mrzRange10 = mrzRange;
            n8 = mrzRange10.column;
            n9 = n8 + 4;
            int n10 = mrzRange10.row;
            mrzRange2 = new MrzRange(n9, n8 += 6, n10);
            try {
                n3 = Integer.parseInt(object.rawValue(mrzRange9));
            }
            catch (NumberFormatException numberFormatException) {
                n3 = -1;
            }
            MrzRange[] mrzRangeArray = object;
            MrzRange[] mrzRangeArray2 = new MrzRange[1];
            Object object = mrzRangeArray2;
            mrzRangeArray2[0] = mrzRange;
            object = mrzRangeArray.rawValue((MrzRange)object);
            return new MrzDate(n5, n4, n3, (String)object);
        }
        throw new IllegalArgumentException("Parameter range: invalid value " + mrzRange + ": must be 6 characters long");
    }

    public MrzSex parseSex(int n3, int n4) {
        return MrzSex.fromMrz(this.rows[n4].charAt(n3));
    }
}

