/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.mrz.types;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class MrzDate
implements Serializable,
Comparable<MrzDate> {
    private static final long serialVersionUID = 1L;
    private static final SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd");
    public final int year;
    public final int month;
    public final int day;
    private final String mrz;
    private final boolean isValidDate;

    public MrzDate(int n3, int n4, int n5) {
        this.year = n3;
        this.month = n4;
        this.day = n5;
        this.isValidDate = this.check();
        this.mrz = null;
    }

    public MrzDate(int n3, int n4, int n5, String string2) {
        this.year = n3;
        this.month = n4;
        this.day = n5;
        this.isValidDate = this.check();
        this.mrz = string2;
    }

    private boolean check() {
        int n3 = this.year;
        if (n3 >= 0 && n3 <= 99) {
            n3 = this.month;
            if (n3 >= 1 && n3 <= 12) {
                int n4 = this.day;
                return n4 >= 1 && n4 <= 31;
                {
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        try {
            return outputFormat.format(new SimpleDateFormat("yyMMdd").parse(this.mrz));
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return "";
        }
    }

    public String toMrz() {
        Object[] objectArray = this.mrz;
        if (this.mrz != null) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[3];
        objectArray = objectArray2;
        objectArray[0] = this.year;
        objectArray[1] = this.month;
        objectArray2[2] = this.day;
        return String.format("%02d%02d%02d", objectArray);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (MrzDate)object;
        if (this.year != ((MrzDate)object).year) {
            return false;
        }
        if (this.month != ((MrzDate)object).month) {
            return false;
        }
        return this.day == ((MrzDate)object).day;
    }

    public int hashCode() {
        return ((77 + this.year) * 11 + this.month) * 11 + this.day;
    }

    @Override
    public int compareTo(MrzDate mrzDate) {
        MrzDate mrzDate2 = this;
        int n3 = mrzDate2.year * 10000;
        MrzDate mrzDate3 = mrzDate;
        int n4 = mrzDate3.year * 10000;
        return Integer.valueOf(mrzDate2.month * 100 + n3 + this.day).compareTo(mrzDate3.month * 100 + n4 + mrzDate.day);
    }

    public boolean isDateValid() {
        return this.isValidDate;
    }
}

