/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.scuba.smartcards;

import b.b;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class CommandAPDU
implements Serializable {
    private static final long serialVersionUID = 398698301286670877L;
    private static final int MAX_APDU_SIZE = 65544;
    private byte[] apdu;
    private transient int nc;
    private transient int ne;
    private transient int dataOffset;

    public CommandAPDU(byte[] byArray) {
        this.apdu = (byte[])byArray.clone();
        this.parse();
    }

    public CommandAPDU(byte[] byArray, int n3, int n4) {
        CommandAPDU commandAPDU = object;
        CommandAPDU commandAPDU2 = object;
        CommandAPDU commandAPDU3 = object;
        commandAPDU3.checkArrayBounds(byArray, n3, n4);
        byte[] byArray2 = new byte[n4];
        Object object = byArray2;
        commandAPDU2.apdu = byArray2;
        System.arraycopy(byArray, n3, object, 0, n4);
        commandAPDU.parse();
    }

    private void checkArrayBounds(byte[] byArray, int n3, int n4) {
        block5: {
            block8: {
                block7: {
                    block6: {
                        if (n3 < 0 || n4 < 0) break block5;
                        if (byArray != null) break block6;
                        if (n3 != 0 && n4 != 0) {
                            throw new IllegalArgumentException("offset and length must be 0 if array is null");
                        }
                        break block7;
                    }
                    if (n3 > byArray.length - n4) break block8;
                }
                return;
            }
            throw new IllegalArgumentException("Offset plus length exceed array size");
        }
        throw new IllegalArgumentException("Offset and length must not be negative");
    }

    public CommandAPDU(ByteBuffer byteBuffer) {
        CommandAPDU commandAPDU = object;
        CommandAPDU commandAPDU2 = object;
        byte[] byArray = new byte[byteBuffer.remaining()];
        Object object = byArray;
        commandAPDU2.apdu = byArray;
        byteBuffer.get((byte[])object);
        commandAPDU.parse();
    }

    public CommandAPDU(int n3, int n4, int n5, int n6) {
        this(n3, n4, n5, n6, null, 0, 0, 0);
    }

    public CommandAPDU(int n3, int n4, int n5, int n6, int n7) {
        this(n3, n4, n5, n6, null, 0, 0, n7);
    }

    public CommandAPDU(int n3, int n4, int n5, int n6, byte[] byArray) {
        int n7 = CommandAPDU.arrayLength(byArray);
        this(n3, n4, n5, n6, byArray, 0, n7, 0);
    }

    public CommandAPDU(int n3, int n4, int n5, int n6, byte[] byArray, int n7, int n8) {
        this(n3, n4, n5, n6, byArray, n7, n8, 0);
    }

    public CommandAPDU(int n3, int n4, int n5, int n6, byte[] byArray, int n7) {
        int n8 = CommandAPDU.arrayLength(byArray);
        this(n3, n4, n5, n6, byArray, 0, n8, n7);
    }

    private static int arrayLength(byte[] byArray) {
        return byArray != null ? byArray.length : 0;
    }

    private void parse() {
        byte[] byArray = this.apdu;
        if (this.apdu.length >= 4) {
            if (byArray.length == 4) {
                return;
            }
            int n3 = byArray[4] & 0xFF;
            if (byArray.length == 5) {
                if (n3 == 0) {
                    n3 = 256;
                }
                this.ne = n3;
                return;
            }
            if (n3 != 0) {
                if (byArray.length == n3 + 5) {
                    CommandAPDU commandAPDU = this;
                    commandAPDU.nc = n3;
                    commandAPDU.dataOffset = 5;
                    return;
                }
                if (byArray.length == n3 + 6) {
                    CommandAPDU commandAPDU = this;
                    commandAPDU.nc = n3;
                    commandAPDU.dataOffset = 5;
                    int n4 = byArray[byArray.length - 1] & 0xFF;
                    if (n4 == 0) {
                        n4 = 256;
                    }
                    this.ne = n4;
                    return;
                }
                throw new IllegalArgumentException(b.a("Invalid APDU: length=").append(this.apdu.length).append(", b1=").append(n3).toString());
            }
            if (byArray.length >= 7) {
                int n5 = (byArray[5] & 0xFF) << 8 | byArray[6] & 0xFF;
                if (byArray.length == 7) {
                    if (n5 == 0) {
                        n5 = 65536;
                    }
                    this.ne = n5;
                    return;
                }
                if (n5 != 0) {
                    if (byArray.length == n5 + 7) {
                        CommandAPDU commandAPDU = this;
                        commandAPDU.nc = n5;
                        commandAPDU.dataOffset = 7;
                        return;
                    }
                    if (byArray.length == n5 + 9) {
                        CommandAPDU commandAPDU = this;
                        commandAPDU.nc = n5;
                        commandAPDU.dataOffset = 7;
                        n3 = byArray.length - 2;
                        int n6 = (byArray[n3] & 0xFF) << 8 | byArray[n3 + 1] & 0xFF;
                        if (n6 == 0) {
                            n6 = 65536;
                        }
                        this.ne = n6;
                        return;
                    }
                    throw new IllegalArgumentException(b.a("Invalid APDU: length=").append(this.apdu.length).append(", b1=").append(n3).append(", b2||b3=").append(n5).toString());
                }
                throw new IllegalArgumentException(b.a("Invalid APDU: length=").append(this.apdu.length).append(", b1=").append(n3).append(", b2||b3=").append(n5).toString());
            }
            throw new IllegalArgumentException(b.a("Invalid APDU: length=").append(this.apdu.length).append(", b1=").append(n3).toString());
        }
        throw new IllegalArgumentException("apdu must be at least 4 bytes long");
    }

    public CommandAPDU(int n3, int n4, int n5, int n6, byte[] byArray, int n7, int n8, int n9) {
        CommandAPDU commandAPDU = object;
        commandAPDU.checkArrayBounds(byArray, n7, n8);
        if (n8 <= 65535) {
            if (n9 >= 0) {
                if (n9 <= 65536) {
                    Object object;
                    CommandAPDU commandAPDU2 = object;
                    commandAPDU2.ne = n9;
                    commandAPDU2.nc = n8;
                    if (n8 == 0) {
                        if (n9 == 0) {
                            ((CommandAPDU)object).apdu = new byte[4];
                            ((CommandAPDU)object).setHeader(n3, n4, n5, n6);
                        } else if (n9 <= 256) {
                            byte by = n9 != 256 ? (byte)n9 : (byte)0;
                            CommandAPDU commandAPDU3 = object;
                            ((CommandAPDU)object).apdu = new byte[5];
                            commandAPDU3.setHeader(n3, n4, n5, n6);
                            commandAPDU3.apdu[4] = by;
                        } else {
                            byte by;
                            if (n9 == 65536) {
                                by = 0;
                                n7 = 0;
                            } else {
                                int n10 = n9;
                                by = (byte)(n10 >> 8);
                                n7 = (byte)n10;
                            }
                            CommandAPDU commandAPDU4 = object;
                            ((CommandAPDU)object).apdu = new byte[7];
                            commandAPDU4.setHeader(n3, n4, n5, n6);
                            commandAPDU4.apdu[5] = by;
                            commandAPDU4.apdu[6] = n7;
                        }
                    } else if (n9 == 0) {
                        if (n8 <= 255) {
                            CommandAPDU commandAPDU5 = object;
                            ((CommandAPDU)object).apdu = new byte[n8 + 5];
                            commandAPDU5.setHeader(n3, n4, n5, n6);
                            object = commandAPDU5.apdu;
                            commandAPDU5.apdu[4] = (byte)n8;
                            commandAPDU5.dataOffset = 5;
                            System.arraycopy(byArray, n7, object, 5, n8);
                        } else {
                            CommandAPDU commandAPDU6 = object;
                            ((CommandAPDU)object).apdu = new byte[n8 + 7];
                            commandAPDU6.setHeader(n3, n4, n5, n6);
                            object = commandAPDU6.apdu;
                            object[4] = false;
                            object[5] = (byte)(n8 >> 8);
                            commandAPDU6.apdu[6] = (byte)n8;
                            commandAPDU6.dataOffset = 7;
                            System.arraycopy(byArray, n7, object, 7, n8);
                        }
                    } else if (n8 <= 255 && n9 <= 256) {
                        CommandAPDU commandAPDU7 = object;
                        CommandAPDU commandAPDU8 = object;
                        ((CommandAPDU)object).apdu = new byte[n8 + 6];
                        commandAPDU8.setHeader(n3, n4, n5, n6);
                        object = commandAPDU8.apdu;
                        commandAPDU8.apdu[4] = (byte)n8;
                        commandAPDU8.dataOffset = 5;
                        System.arraycopy(byArray, n7, object, 5, n8);
                        object = commandAPDU7.apdu;
                        n3 = commandAPDU7.apdu.length - 1;
                        n4 = n9 != 256 ? (int)((byte)n9) : 0;
                        object[n3] = n4;
                    } else {
                        CommandAPDU commandAPDU9 = object;
                        ((CommandAPDU)object).apdu = new byte[n8 + 9];
                        commandAPDU9.setHeader(n3, n4, n5, n6);
                        byte[] byArray2 = commandAPDU9.apdu;
                        byArray2[4] = 0;
                        byArray2[5] = (byte)(n8 >> 8);
                        commandAPDU9.apdu[6] = (byte)n8;
                        commandAPDU9.dataOffset = 7;
                        System.arraycopy(byArray, n7, byArray2, 7, n8);
                        if (n9 != 65536) {
                            object = ((CommandAPDU)object).apdu;
                            int n11 = ((Object)object).length - 2;
                            object[n11] = (byte)(n9 >> 8);
                            ((CommandAPDU)object).apdu[++n11] = (byte)n9;
                        }
                    }
                    return;
                }
                throw new IllegalArgumentException("ne is too large");
            }
            throw new IllegalArgumentException("ne must not be negative");
        }
        throw new IllegalArgumentException("dataLength is too large");
    }

    private void setHeader(int n3, int n4, int n5, int n6) {
        Object object = ((CommandAPDU)object).apdu;
        object[0] = (byte)n3;
        object[1] = (byte)n4;
        object[2] = (byte)n5;
        ((CommandAPDU)object).apdu[3] = (byte)n6;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        this.apdu = (byte[])objectInputStream.readUnshared();
        this.parse();
    }

    public int getCLA() {
        return this.apdu[0] & 0xFF;
    }

    public int getINS() {
        return this.apdu[1] & 0xFF;
    }

    public int getP1() {
        return this.apdu[2] & 0xFF;
    }

    public int getP2() {
        return this.apdu[3] & 0xFF;
    }

    public int getNc() {
        return this.nc;
    }

    public byte[] getData() {
        int n3 = this.nc;
        byte[] byArray = new byte[n3];
        System.arraycopy(this.apdu, this.dataOffset, byArray, 0, n3);
        return byArray;
    }

    public int getNe() {
        return this.ne;
    }

    public byte[] getBytes() {
        return (byte[])this.apdu.clone();
    }

    public String toString() {
        return b.a("CommmandAPDU: ").append(this.apdu.length).append(" bytes, nc=").append(this.nc).append(", ne=").append(this.ne).toString();
    }

    public boolean equals(Object object) {
        if (commandAPDU2 == object) {
            return true;
        }
        if (!(object instanceof CommandAPDU)) {
            return false;
        }
        CommandAPDU commandAPDU = commandAPDU2;
        CommandAPDU commandAPDU2 = (CommandAPDU)object;
        return Arrays.equals(commandAPDU.apdu, commandAPDU2.apdu);
    }

    public int hashCode() {
        return Arrays.hashCode(this.apdu);
    }
}

