/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.scuba.smartcards;

import android.annotation.TargetApi;
import android.nfc.Tag;
import android.nfc.tech.IsoDep;
import android.nfc.tech.NfcA;
import android.nfc.tech.NfcB;
import android.os.Build;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.APDUEvent;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.CardService;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.CardServiceException;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.CommandAPDU;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.ResponseAPDU;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IsoDepCardService
extends CardService {
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.nfc.build_in.scuba");
    private IsoDep isoDep;
    private int apduCount;

    public IsoDepCardService(IsoDep isoDep) {
        this.isoDep = isoDep;
        this.apduCount = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void open() {
        if (this.isOpen()) return;
        try {
            IsoDepCardService isoDepCardService = this;
            isoDepCardService.isoDep.connect();
            if (!isoDepCardService.isoDep.isConnected()) throw new CardServiceException("Failed to connect");
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Failed to connect", iOException);
            throw new CardServiceException(((Object)iOException).toString());
        }
        this.state = 1;
    }

    @Override
    public boolean isOpen() {
        if (this.isoDep.isConnected()) {
            this.state = 1;
            return true;
        }
        this.state = 0;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ResponseAPDU transmit(CommandAPDU commandAPDU) {
        APDUEvent aPDUEvent;
        ResponseAPDU responseAPDU;
        if (!((IsoDepCardService)((Object)string2)).isoDep.isConnected()) throw new CardServiceException("Not connected");
        byte[] byArray = ((IsoDepCardService)((Object)string2)).isoDep.transceive(commandAPDU.getBytes());
        if (byArray == null) throw new CardServiceException("Failed response");
        if (byArray.length < 2) throw new CardServiceException("Failed response");
        ResponseAPDU responseAPDU2 = responseAPDU;
        IsoDepCardService isoDepCardService = string2;
        responseAPDU2(byArray);
        APDUEvent aPDUEvent2 = aPDUEvent;
        APDUEvent aPDUEvent3 = aPDUEvent;
        IsoDepCardService isoDepCardService2 = string2;
        IsoDepCardService isoDepCardService3 = isoDepCardService2;
        IsoDepCardService isoDepCardService4 = isoDepCardService2;
        IsoDepCardService isoDepCardService5 = isoDepCardService2;
        String string2 = "ISODep";
        int n3 = isoDepCardService4.apduCount + 1;
        try {
            isoDepCardService5.apduCount = n3;
            aPDUEvent2(isoDepCardService3, (Serializable)((Object)string2), n3, commandAPDU, responseAPDU2);
            isoDepCardService.notifyExchangedAPDU(aPDUEvent3);
            return responseAPDU;
        }
        catch (Exception exception) {
            throw new CardServiceException(exception.getMessage());
        }
        catch (IOException iOException) {
            throw new CardServiceException(iOException.getMessage());
        }
    }

    @Override
    public byte[] getATR() {
        IsoDep isoDep = this.isoDep;
        if (isoDep == null) {
            return null;
        }
        if ((isoDep = isoDep.getTag()) == null) {
            return null;
        }
        if (NfcA.get((Tag)isoDep) != null) {
            return this.isoDep.getHistoricalBytes();
        }
        return NfcB.get((Tag)isoDep) != null ? this.isoDep.getHiLayerResponse() : this.isoDep.getHistoricalBytes();
    }

    @Override
    @TargetApi(value=16)
    public boolean isExtendedAPDULengthSupported() {
        if (Build.VERSION.SDK_INT >= 16) {
            return this.isoDep.isExtendedLengthApduSupported();
        }
        return this.isoDep.getMaxTransceiveLength() > 261;
    }

    @Override
    public void close() {
        try {
            this.isoDep.close();
            this.state = 0;
        }
        catch (IOException iOException) {}
    }

    @Override
    public boolean isConnectionLost(Exception exception) {
        if (exception == null) {
            return false;
        }
        if (exception.getClass().getName().contains("TagLostException")) {
            return true;
        }
        Object object = exception.getMessage();
        if (object == null) {
            object = "";
        }
        return ((String)object).toLowerCase().contains("tag was lost");
    }
}

