/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.scuba.tlv;

import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVInputState;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TLVInputStream
extends InputStream {
    private static final int MAX_BUFFER_LENGTH = 65535;
    private final InputStream originalInputStream;
    private DataInputStream inputStream;
    private int bufferSize;
    private TLVInputState state;
    private TLVInputState markedState;

    public TLVInputStream(InputStream inputStream) {
        TLVInputState tLVInputState;
        block7: {
            block6: {
                ((TLVInputStream)((Object)tLVInputState2)).bufferSize = 0;
                try {
                    if (inputStream instanceof BufferedInputStream) break block6;
                }
                catch (IOException iOException) {}
                if (!(inputStream instanceof ByteArrayInputStream)) break block7;
            }
            ((TLVInputStream)((Object)tLVInputState2)).bufferSize = inputStream.available();
        }
        ((TLVInputStream)((Object)tLVInputState2)).originalInputStream = inputStream;
        if (inputStream instanceof DataInputStream) {
            inputStream = (DataInputStream)inputStream;
        } else {
            DataInputStream dataInputStream;
            DataInputStream dataInputStream2 = dataInputStream;
            dataInputStream = new DataInputStream(inputStream);
            inputStream = dataInputStream2;
        }
        TLVInputStream tLVInputStream = tLVInputState2;
        tLVInputStream.inputStream = inputStream;
        TLVInputState tLVInputState2 = tLVInputState;
        tLVInputState = new TLVInputState();
        tLVInputStream.state = tLVInputState2;
        tLVInputStream.markedState = null;
    }

    private long skipValue() {
        if (this.state.isAtStartOfTag()) {
            return 0L;
        }
        if (this.state.isAtStartOfLength()) {
            return 0L;
        }
        TLVInputStream tLVInputStream = this;
        return tLVInputStream.skip(tLVInputStream.state.getValueBytesLeft());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readTag() {
        if (!this.state.isAtStartOfTag() && !this.state.isProcessingValue()) {
            throw new IllegalStateException("Not at start of tag");
        }
        int n3 = this.inputStream.readUnsignedByte();
        int n4 = 1;
        while (true) {
            if (n3 != 0 && n3 != 255) {
                if ((n3 & 0x1F) == 31) {
                    int n5;
                    int n6 = this.inputStream.readUnsignedByte();
                    while (true) {
                        n5 = n6;
                        ++n4;
                        if ((n5 & 0x80) != 128) break;
                        n3 = n3 << 8 | n5 & 0x7F;
                        n6 = this.inputStream.readUnsignedByte();
                    }
                    n3 = n3 << 8 | n5 & 0x7F;
                }
                this.state.setTagProcessed(n3, n4);
                return n3;
            }
            n3 = this.inputStream.readUnsignedByte();
            ++n4;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int readLength() {
        int n3;
        int n4;
        block6: {
            if (!this.state.isAtStartOfLength()) throw new IllegalStateException("Not at start of length");
            n4 = this.inputStream.readUnsignedByte();
            n3 = 1;
            if ((n4 & 0x80) == 0) break block6;
            n4 &= 0x7F;
            int n5 = 0;
            int n6 = n5;
            n5 = n3;
            n3 = n6;
            for (int i3 = 0; i3 < n4; ++i3) {
                int n7 = n3;
                n3 = this.inputStream.readUnsignedByte();
                ++n5;
                n3 = n7 << 8 | n3;
            }
            int n8 = n3;
            n3 = n5;
            n4 = n8;
        }
        this.state.setLengthProcessed(n4, n3);
        return n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] readValue() {
        if (!this.state.isProcessingValue()) throw new IllegalStateException("Not yet processing value!");
        int n3 = this.state.getLength();
        byte[] byArray = new byte[n3];
        TLVInputStream tLVInputStream = this;
        tLVInputStream.inputStream.readFully(byArray);
        tLVInputStream.state.updateValueBytesProcessed(n3);
        return byArray;
    }

    public void skipToTag(int n3) {
        while (true) {
            int n4;
            block5: {
                block7: {
                    block6: {
                        if (this.state.isAtStartOfTag()) break block5;
                        if (!this.state.isAtStartOfLength()) break block6;
                        TLVInputStream tLVInputStream = this;
                        tLVInputStream.readLength();
                        if (!TLVUtil.isPrimitive(tLVInputStream.state.getTag())) break block5;
                        break block7;
                    }
                    if (!TLVUtil.isPrimitive(this.state.getTag())) break block5;
                }
                this.skipValue();
            }
            if ((n4 = this.readTag()) == n3) {
                return;
            }
            if (!TLVUtil.isPrimitive(n4)) continue;
            TLVInputStream tLVInputStream = this;
            n4 = tLVInputStream.readLength();
            if ((int)tLVInputStream.skipValue() < n4) break;
        }
    }

    @Override
    public int available() {
        return ((InputStream)this.inputStream).available();
    }

    @Override
    public int read() {
        int n3 = ((InputStream)this.inputStream).read();
        if (n3 < 0) {
            return -1;
        }
        this.state.updateValueBytesProcessed(1);
        return n3;
    }

    @Override
    public long skip(long l3) {
        if (l3 <= 0L) {
            return 0L;
        }
        l3 = ((InputStream)this.inputStream).skip(l3);
        this.state.updateValueBytesProcessed((int)l3);
        return l3;
    }

    @Override
    public synchronized void mark(int n3) {
        TLVInputStream tLVInputStream = this;
        ((InputStream)tLVInputStream.inputStream).mark(n3);
        tLVInputStream.markedState = (TLVInputState)tLVInputStream.state.clone();
    }

    @Override
    public boolean markSupported() {
        return ((InputStream)this.inputStream).markSupported();
    }

    @Override
    public synchronized void reset() {
        if (this.markSupported()) {
            TLVInputStream tLVInputStream = this;
            ((InputStream)tLVInputStream.inputStream).reset();
            tLVInputStream.state = tLVInputStream.markedState;
            tLVInputStream.markedState = null;
            return;
        }
        throw new IOException("mark/reset not supported");
    }

    @Override
    public void close() {
        ((InputStream)this.inputStream).close();
    }

    public String toString() {
        return this.state.toString();
    }
}

