/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.scuba.tlv;

import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVOutputState;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVUtil;
import java.io.DataOutputStream;
import java.io.OutputStream;

public class TLVOutputStream
extends OutputStream {
    private DataOutputStream outputStream;
    private TLVOutputState state;

    public TLVOutputStream(OutputStream outputStream) {
        TLVOutputState tLVOutputState;
        if (outputStream instanceof DataOutputStream) {
            outputStream = (DataOutputStream)outputStream;
        } else {
            DataOutputStream dataOutputStream;
            DataOutputStream dataOutputStream2 = dataOutputStream;
            dataOutputStream = new DataOutputStream(outputStream);
            outputStream = dataOutputStream2;
        }
        TLVOutputStream tLVOutputStream = tLVOutputState2;
        tLVOutputStream.outputStream = outputStream;
        TLVOutputState tLVOutputState2 = tLVOutputState;
        tLVOutputState = new TLVOutputState();
        tLVOutputStream.state = tLVOutputState2;
    }

    public void writeTag(int n3) {
        byte[] byArray = TLVUtil.getTagAsBytes(n3);
        if (this.state.canBeWritten()) {
            ((OutputStream)this.outputStream).write(byArray);
        }
        this.state.setTagProcessed(n3);
    }

    public void writeLength(int n3) {
        TLVOutputStream tLVOutputStream = this;
        byte[] byArray = TLVUtil.getLengthAsBytes(n3);
        tLVOutputStream.state.setLengthProcessed(n3);
        if (tLVOutputStream.state.canBeWritten()) {
            ((OutputStream)this.outputStream).write(byArray);
        }
    }

    public void writeValue(byte[] byArray) {
        if (byArray != null) {
            if (!this.state.isAtStartOfTag()) {
                if (this.state.isAtStartOfLength()) {
                    this.writeLength(byArray.length);
                    this.write(byArray);
                } else {
                    TLVOutputStream tLVOutputStream = this;
                    tLVOutputStream.write(byArray);
                    tLVOutputStream.state.updatePreviousLength(byArray.length);
                }
                return;
            }
            throw new IllegalStateException("Cannot write value bytes yet. Need to write a tag first.");
        }
        throw new IllegalArgumentException("Cannot write null.");
    }

    @Override
    public void write(int n3) {
        TLVOutputStream tLVOutputStream = object;
        byte[] byArray = new byte[1];
        Object object = byArray;
        byArray[0] = (byte)n3;
        tLVOutputStream.write((byte[])object, 0, 1);
    }

    @Override
    public void write(byte[] byArray) {
        int n3 = byArray.length;
        this.write(byArray, 0, n3);
    }

    @Override
    public void write(byte[] byArray, int n3, int n4) {
        if (!this.state.isAtStartOfTag()) {
            if (this.state.isAtStartOfLength()) {
                this.state.setDummyLengthProcessed();
            }
            TLVOutputStream tLVOutputStream = this;
            tLVOutputStream.state.updateValueBytesProcessed(byArray, n3, n4);
            if (tLVOutputStream.state.canBeWritten()) {
                this.outputStream.write(byArray, n3, n4);
            }
            return;
        }
        throw new IllegalStateException("Cannot write value bytes yet. Need to write a tag first.");
    }

    public void writeValueEnd() {
        if (!((TLVOutputStream)object).state.isAtStartOfLength()) {
            if (((TLVOutputStream)object).state.isAtStartOfTag() && !((TLVOutputStream)object).state.isDummyLengthSet()) {
                return;
            }
            TLVOutputStream tLVOutputStream = object;
            byte[] byArray = tLVOutputStream.state.getValue();
            int n3 = byArray.length;
            tLVOutputStream.state.updatePreviousLength(n3);
            if (tLVOutputStream.state.canBeWritten()) {
                TLVOutputStream tLVOutputStream2 = object;
                Object object = TLVUtil.getLengthAsBytes(n3);
                ((OutputStream)tLVOutputStream2.outputStream).write((byte[])object);
                ((OutputStream)tLVOutputStream2.outputStream).write(byArray);
            }
            return;
        }
        throw new IllegalStateException("Not processing value yet.");
    }

    @Override
    public void flush() {
        this.outputStream.flush();
    }

    @Override
    public void close() {
        if (this.state.canBeWritten()) {
            ((OutputStream)this.outputStream).close();
            return;
        }
        throw new IllegalStateException("Cannot close stream yet, illegal TLV state.");
    }
}

