/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.scuba.tlv;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.a;
import com.fis.ekyc.nfc.build_in.scuba.tlv.ASN1Constants;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVInputStream;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TLVUtil
implements ASN1Constants {
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.nfc.build_in.scuba.tlv");

    private TLVUtil() {
    }

    public static boolean isPrimitive(int n3) {
        int n4;
        for (n4 = 3; n4 >= 0 && (n3 & 255 << n4 * 8) == 0; --n4) {
        }
        return ((n3 & 255 << (n3 = n4 * 8)) >> n3 & 0xFF & 0x20) == 0;
    }

    public static int getTagLength(int n3) {
        return TLVUtil.getTagAsBytes(n3).length;
    }

    public static int getLengthLength(int n3) {
        return TLVUtil.getLengthAsBytes(n3).length;
    }

    public static byte[] getTagAsBytes(int n3) {
        ByteArrayOutputStream byteArrayOutputStream;
        Object object = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        int n4 = (int)(Math.log(n3) / Math.log(256.0)) + 1;
        for (int i3 = 0; i3 < n4; ++i3) {
            int n5 = a.a(n4, i3, 1, 8);
            ((ByteArrayOutputStream)object).write((n3 & 255 << n5) >> n5);
        }
        object = ((ByteArrayOutputStream)object).toByteArray();
        n4 = TLVUtil.getTagClass(n3);
        if (n4 != 1) {
            if (n4 != 2) {
                if (n4 == 3) {
                    Object object2 = object;
                    object2[0] = (byte)(object2[0] | 0xC0);
                }
            } else {
                Object object3 = object;
                object3[0] = (byte)(object3[0] | 0x80);
            }
        } else {
            Object object4 = object;
            object4[0] = (byte)(object4[0] | 0x40);
        }
        if (!TLVUtil.isPrimitive(n3)) {
            Object object5 = object;
            object5[0] = (byte)(object5[0] | 0x20);
        }
        return object;
    }

    public static byte[] getLengthAsBytes(int n3) {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        if (n3 < 128) {
            byteArrayOutputStream2.write(n3);
        } else {
            int n4 = TLVUtil.log(n3, 256);
            byteArrayOutputStream2.write(n4 | 0x80);
            for (int i3 = 0; i3 < n4; ++i3) {
                int n5 = a.a(n4, i3, 1, 8);
                byteArrayOutputStream2.write((n3 & 255 << n5) >> n5);
            }
        }
        return byteArrayOutputStream2.toByteArray();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] wrapDO(int n3, byte[] byArray) {
        Throwable throwable2222222;
        ByteArrayOutputStream byteArrayOutputStream2;
        block8: {
            ByteArrayOutputStream byteArrayOutputStream2;
            if (byArray == null) throw new IllegalArgumentException("Data to wrap is null");
            byteArrayOutputStream2 = byteArrayOutputStream2;
            byteArrayOutputStream2 = new ByteArrayOutputStream();
            TLVOutputStream tLVOutputStream = new TLVOutputStream(byteArrayOutputStream2);
            tLVOutputStream.writeTag(n3);
            tLVOutputStream.writeValue(byArray);
            tLVOutputStream.flush();
            tLVOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream2.toByteArray();
            {
                catch (Throwable throwable2222222) {
                    break block8;
                }
                catch (IOException iOException) {}
                {
                    throw new IllegalStateException("Error writing stream", iOException);
                }
            }
            try {
                byteArrayOutputStream2.close();
                return byArray2;
            }
            catch (IOException iOException) {
                LOGGER.log(Level.FINE, "Error closing stream", iOException);
            }
            return byArray2;
        }
        try {
            byteArrayOutputStream2.close();
            throw throwable2222222;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, "Error closing stream", iOException);
        }
        throw throwable2222222;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] unwrapDO(int n3, byte[] object) {
        Throwable throwable222222;
        block11: {
            int n4;
            block10: {
                TLVInputStream tLVInputStream;
                ByteArrayInputStream byteArrayInputStream;
                if (object == null) throw new IllegalArgumentException("Wrapped data is null or length < 2");
                if (((Object)object).length < 2) throw new IllegalArgumentException("Wrapped data is null or length < 2");
                ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
                byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                object = tLVInputStream;
                n4 = new TLVInputStream(byteArrayInputStream2).readTag();
                if (n4 != n3) break block10;
                Object object2 = object;
                Object object3 = object2;
                n3 = ((TLVInputStream)object2).readLength();
                byte[] byArray = new byte[n3];
                System.arraycopy(((TLVInputStream)object2).readValue(), 0, byArray, 0, n3);
                try {
                    ((TLVInputStream)object3).close();
                    return byArray;
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.FINE, "Error closing stream", iOException);
                }
                return byArray;
            }
            try {
                throw new IllegalArgumentException("Expected tag " + Integer.toHexString(n3) + ", found tag " + Integer.toHexString(n4));
            }
            catch (Throwable throwable222222) {
                break block11;
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Error reading from stream", iOException);
            }
        }
        try {
            ((TLVInputStream)object).close();
            throw throwable222222;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, "Error closing stream", iOException);
        }
        throw throwable222222;
    }

    public static int getTagClass(int n3) {
        int n4;
        for (n4 = 3; n4 >= 0 && (n3 & 255 << n4 * 8) == 0; --n4) {
        }
        int n5 = n3;
        n3 = n4 * 8;
        if ((n3 = (n5 & 255 << n3) >> n3 & 0xFF & 0xC0) != 0) {
            if (n3 != 64) {
                if (n3 != 128) {
                    return 3;
                }
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private static int log(int n3, int n4) {
        int n5 = 0;
        while (n3 > 0) {
            n3 /= n4;
            ++n5;
        }
        return n5;
    }
}

