/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.capturesdk.tflite;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.os.SystemClock;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tensorflow.lite.DataType;
import org.tensorflow.lite.Delegate;
import org.tensorflow.lite.Interpreter;
import org.tensorflow.lite.gpu.CompatibilityList;
import org.tensorflow.lite.gpu.GpuDelegate;
import org.tensorflow.lite.support.common.TensorOperator;
import org.tensorflow.lite.support.common.ops.CastOp;
import org.tensorflow.lite.support.common.ops.NormalizeOp;
import org.tensorflow.lite.support.image.ImageProcessor;
import org.tensorflow.lite.support.image.TensorImage;
import org.tensorflow.lite.support.tensorbuffer.TensorBuffer;
import vn.kalapa.ekyc.capturesdk.tflite.BoundingBox;
import vn.kalapa.ekyc.capturesdk.tflite.KLPDetectorListener;
import vn.kalapa.ekyc.capturesdk.tflite.OnImageDetectedListener;
import vn.kalapa.ekyc.managers.KLPCardModelManager;
import vn.kalapa.ekyc.utils.Helpers;

@SourceDebugExtension(value={"SMAP\nDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Detector.kt\nvn/kalapa/ekyc/capturesdk/tflite/KLPDetector\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,403:1\n1295#2,2:404\n1#3:406\n766#4:407\n857#4,2:408\n1054#4:410\n*S KotlinDebug\n*F\n+ 1 Detector.kt\nvn/kalapa/ekyc/capturesdk/tflite/KLPDetector\n*L\n126#1:404,2\n214#1:407\n214#1:408,2\n274#1:410\n*E\n"})
public final class KLPDetector
implements KLPDetectorListener {
    @NotNull
    private final Activity activity;
    @NotNull
    private final String modelName;
    private boolean isAutoCaptureOn;
    @NotNull
    private final OnImageDetectedListener onImageListener;
    private final float INPUT_MEAN;
    private final float INPUT_STANDARD_DEVIATION;
    @NotNull
    private final DataType INPUT_IMAGE_TYPE;
    @NotNull
    private final DataType OUTPUT_IMAGE_TYPE;
    private final float CONFIDENCE_THRESHOLD;
    private final float IOU_THRESHOLD;
    private final float CARD_CONF;
    private final float CORNER_CONF;
    private final long VERIFY_CAPTURING_DURATION;
    private final float MOVEMENT_THRESHOLD;
    private Interpreter interpreter;
    @NotNull
    private final List<String> labels;
    private int tensorWidth;
    private int tensorHeight;
    private int numChannel;
    private int numElements;
    private long conditionStartTime;
    @Nullable
    private GpuDelegate gpuDelegate;
    private boolean isModelInitialized;
    @NotNull
    private final TensorImage tensorImage;
    private TensorBuffer outputBuffer;
    private final ImageProcessor imageProcessor;
    @NotNull
    private final Object interpreterLock;
    private boolean detected;
    @Nullable
    private BoundingBox previousBoundingBox;

    public KLPDetector(@NotNull Activity activity, @NotNull String string2, @NotNull String string3, boolean bl, @NotNull OnImageDetectedListener onImageDetectedListener) {
        KLPDetector kLPDetector = this;
        KLPDetector kLPDetector2 = this;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"labelPath");
        Intrinsics.checkNotNullParameter((Object)onImageDetectedListener, (String)"onImageListener");
        this.activity = activity;
        this.modelName = string2;
        this.isAutoCaptureOn = bl;
        kLPDetector2.onImageListener = onImageDetectedListener;
        kLPDetector2.INPUT_STANDARD_DEVIATION = 255.0f;
        activity = DataType.FLOAT32;
        kLPDetector2.INPUT_IMAGE_TYPE = activity;
        kLPDetector2.OUTPUT_IMAGE_TYPE = activity;
        kLPDetector2.CONFIDENCE_THRESHOLD = 0.3f;
        kLPDetector2.IOU_THRESHOLD = 0.5f;
        kLPDetector2.CARD_CONF = 0.65f;
        kLPDetector2.CORNER_CONF = 0.35f;
        kLPDetector2.VERIFY_CAPTURING_DURATION = 500L;
        kLPDetector2.MOVEMENT_THRESHOLD = 0.4f;
        kLPDetector2.labels = new ArrayList<String>();
        kLPDetector2.tensorImage = new TensorImage((DataType)activity);
        kLPDetector2.imageProcessor = new ImageProcessor.Builder().add((TensorOperator)new NormalizeOp(this.INPUT_MEAN, 255.0f)).add((TensorOperator)new CastOp((DataType)activity)).build();
        kLPDetector.loadLabels(string3);
        kLPDetector.initializeModel();
        kLPDetector.interpreterLock = new Object();
    }

    public /* synthetic */ KLPDetector(Activity activity, String string2, String string3, boolean bl, OnImageDetectedListener onImageDetectedListener, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            bl = true;
        }
        this(activity, string2, string3, bl, onImageDetectedListener);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void initializeModel() {
        block22: {
            block21: {
                block20: {
                    var1_1 = KLPCardModelManager.INSTANCE.getModel();
                    var2_4 = false;
                    if (var1_1 == null) break block22;
                    var3_5 /* !! */  = v0;
                    v0 = new CompatibilityList();
                    var4_7 = v1;
                    v1 = new Interpreter.Options();
                    if (!v0.isDelegateSupportedOnThisDevice()) break block20;
                    v2 = var4_7;
                    v3 = this;
                    var3_5 /* !! */  = var3_5 /* !! */ .getBestOptionsForThisDevice();
                    var5_9 = v4;
                    v4 = new GpuDelegate((GpuDelegate.Options)var3_5 /* !! */ );
                    v3.gpuDelegate = var5_9;
                    v5 = v2.addDelegate((Delegate)var5_9);
                    break block21;
                }
                v5 = var4_7.setNumThreads(4);
            }
            var3_5 /* !! */  = v6;
            try {
                v6 = new Interpreter((File)var1_1, var4_7);
                ** GOTO lbl32
            }
            catch (Exception v7) {
                block24: {
                    block23: {
                        var3_5 /* !! */  = v8;
                        v8 = new Interpreter((File)var1_1);
lbl32:
                        // 2 sources

                        this.interpreter = var3_5 /* !! */ ;
                        var1_1 = var3_5 /* !! */ .getInputTensor(0);
                        if (var1_1 == null) ** GOTO lbl38
                        var1_1 = var1_1.shape();
                        break block23;
lbl38:
                        // 1 sources

                        var1_1 = null;
                    }
                    var3_5 /* !! */  = this.interpreter;
                    if (var3_5 /* !! */  != null) ** GOTO lbl45
                    Intrinsics.throwUninitializedPropertyAccessException((String)"interpreter");
                    var3_5 /* !! */  = null;
lbl45:
                    // 2 sources

                    if ((var3_5 /* !! */  = var3_5 /* !! */ .getOutputTensor(0)) == null) ** GOTO lbl49
                    var3_5 /* !! */  = (CompatibilityList)var3_5 /* !! */ .shape();
                    break block24;
lbl49:
                    // 1 sources

                    var3_5 /* !! */  = null;
                }
                if (var1_1 == null) ** GOTO lbl63
                v9 = var1_1[1];
                var4_8 = v9;
                v10 = this;
                this.tensorWidth = (int)var4_8;
                var4_8 = var1_1[2];
                v10.tensorHeight = (int)var4_8;
                if (v9 == 3) {
                    this.tensorWidth = (int)var4_8;
                    this.tensorHeight = (int)var1_1[3];
                }
lbl63:
                // 4 sources

                if (var3_5 /* !! */  == null) ** GOTO lbl83
                v11 = this;
                v12 = v11;
                v13 = v11;
                v14 /* !! */  = var3_5 /* !! */ ;
                v15 = this;
                var1_2 = var3_5 /* !! */ [1];
                v15.numChannel = (int)var1_2;
                var3_6 = v14 /* !! */ [2];
                v12.numElements = (int)var3_6;
                v16 = new int[3];
                try {
                    v16[0] = 1;
                    v16[1] = (int)var1_2;
                    v16[2] = (int)var3_6;
                    v17 = TensorBuffer.createFixedSize((int[])v16, (DataType)this.OUTPUT_IMAGE_TYPE);
                    Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"createFixedSize(\n       \u2026YPE\n                    )");
                    v13.outputBuffer = v17;
lbl83:
                    // 2 sources

                    this.isModelInitialized = true;
                    var2_4 = true;
                }
                catch (Exception var1_3) {
                    Helpers.Companion.printLog(new Object[]{"Error initializing interpreter: " + var1_3.getMessage()});
                }
            }
        }
        this.onImageListener.onSetupModelComplete(var2_4);
    }

    /*
     * Loose catch block
     */
    private final void loadLabels(String object) {
        BufferedReader bufferedReader;
        object = this.activity.getAssets().open((String)object);
        Throwable throwable = null;
        BufferedReader bufferedReader2 = bufferedReader;
        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
        Throwable throwable2 = null;
        Iterator iterator = TextStreamsKt.lineSequence((BufferedReader)bufferedReader).iterator();
        while (true) {
            if (!iterator.hasNext()) break;
            KLPDetector kLPDetector = this;
            String string2 = (String)iterator.next();
            kLPDetector.labels.add(string2);
        }
        Object object2 = object;
        BufferedReader bufferedReader3 = bufferedReader2;
        CloseableKt.closeFinally((Closeable)bufferedReader3, throwable2);
        CloseableKt.closeFinally((Closeable)object2, throwable);
        catch (Throwable throwable3) {
            try {
                throw throwable3;
            }
            catch (Throwable throwable4) {
                try {
                    CloseableKt.closeFinally((Closeable)bufferedReader2, (Throwable)throwable3);
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    try {
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        try {
                            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable5);
                            throw throwable6;
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    private final List<BoundingBox> bestBox(float[] fArray) {
        ArrayList<BoundingBox> arrayList;
        ArrayList<BoundingBox> arrayList2 = arrayList;
        arrayList = new ArrayList<BoundingBox>();
        int n3 = this.numElements;
        for (int i3 = 0; i3 < n3; ++i3) {
            BoundingBox boundingBox;
            float f3;
            KLPDetector kLPDetector = this;
            float f4 = kLPDetector.CONFIDENCE_THRESHOLD;
            int n4 = -1;
            int n5 = 4;
            int n6 = kLPDetector.numElements * n5 + i3;
            while (n5 < this.numChannel) {
                float f5;
                f3 = fArray[n6];
                if (f5 > f4) {
                    int n7;
                    n4 = n7 = n5 - 4;
                    f4 = f3;
                }
                ++n5;
                n6 += this.numElements;
            }
            if (!(f4 > this.CONFIDENCE_THRESHOLD)) continue;
            String string2 = this.labels.get(n4);
            float f6 = fArray[i3];
            int n8 = this.numElements;
            float f7 = fArray[i3 + n8];
            float f8 = fArray[n8 * 2 + i3];
            f3 = fArray[n8 * 3 + i3];
            float f9 = f8 / 2.0f;
            float f10 = f6 - f9;
            float f11 = f9;
            f9 = f3 / 2.0f;
            float f12 = f7 - f9;
            float f13 = f6 + f11;
            f9 = f7 + f9;
            if (f10 < 0.0f || f10 > 1.0f || f12 < 0.0f || f12 > 1.0f || f13 < 0.0f || f13 > 1.0f || f9 < 0.0f || f9 > 1.0f) continue;
            BoundingBox boundingBox2 = boundingBox;
            boundingBox = new BoundingBox(f10, f12, f13, f9, f6, f7, f8, f3, f4, n4, string2);
            arrayList2.add(boundingBox2);
        }
        return arrayList2.isEmpty() ? null : this.applyNMS(arrayList2);
    }

    private final List<BoundingBox> applyNMS(List<BoundingBox> list) {
        ArrayList<BoundingBox> arrayList;
        list = CollectionsKt.toMutableList((Collection)CollectionsKt.sortedWith(list, new Comparator(){

            public final int compare(T t2, T t3) {
                return ComparisonsKt.compareValues((Comparable)Float.valueOf(((BoundingBox)t3).getCnf()), (Comparable)Float.valueOf(((BoundingBox)t2).getCnf()));
            }
        }));
        ArrayList<BoundingBox> arrayList2 = arrayList;
        arrayList = new ArrayList<BoundingBox>();
        while (list.isEmpty() ^ true) {
            List list2 = list;
            BoundingBox boundingBox = (BoundingBox)CollectionsKt.first((List)list);
            arrayList2.add(boundingBox);
            list2.remove(boundingBox);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                if (!(this.calculateIoU(boundingBox, (BoundingBox)iterator.next()) > this.IOU_THRESHOLD)) continue;
                iterator.remove();
            }
        }
        return arrayList2;
    }

    private final float calculateIoU(BoundingBox boundingBox, BoundingBox boundingBox2) {
        BoundingBox boundingBox3 = boundingBox;
        float f3 = Math.max(boundingBox3.getX1(), boundingBox2.getX1());
        float f4 = Math.max(boundingBox3.getY1(), boundingBox2.getY1());
        float f5 = Math.min(boundingBox3.getX2(), boundingBox2.getX2());
        f3 = Math.max(0.0f, f5 - f3);
        float f6 = Math.max(0.0f, Math.min(boundingBox3.getY2(), boundingBox2.getY2()) - f4) * f3;
        BoundingBox boundingBox4 = boundingBox2;
        BoundingBox boundingBox5 = boundingBox;
        f3 = boundingBox5.getW();
        f3 = boundingBox5.getH() * f3;
        float f7 = boundingBox4.getW();
        return f6 / (boundingBox4.getH() * f7 + f3 - f6);
    }

    private final float calculateDistance(BoundingBox boundingBox, BoundingBox boundingBox2) {
        BoundingBox boundingBox3 = boundingBox2;
        float f3 = boundingBox3.getX1();
        float f4 = boundingBox3.getX2() + f3;
        f3 = 2;
        BoundingBox boundingBox4 = boundingBox;
        float f5 = boundingBox4.getX1();
        f5 = f4 / f3 - (boundingBox4.getX2() + f5) / f3;
        float f6 = boundingBox3.getY1();
        BoundingBox boundingBox5 = boundingBox;
        float f7 = boundingBox5.getY1();
        float f8 = (boundingBox3.getY2() + f6) / f3 - (boundingBox5.getY2() + f7) / f3;
        float f9 = f5;
        f3 = f9 * f9;
        return (float)Math.sqrt(f8 * f8 + f3);
    }

    private final boolean hasMovedSignificantly(BoundingBox boundingBox, BoundingBox boundingBox2) {
        return this.calculateDistance(boundingBox, boundingBox2) > this.MOVEMENT_THRESHOLD;
    }

    public final boolean isAutoCaptureOn() {
        return this.isAutoCaptureOn;
    }

    public final void setAutoCaptureOn(boolean bl) {
        this.isAutoCaptureOn = bl;
    }

    public final void restart(boolean bl) {
        KLPDetector kLPDetector = this;
        kLPDetector.close();
        kLPDetector.detected = false;
        kLPDetector.isModelInitialized = false;
        kLPDetector.initializeModel();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void close() {
        Object object;
        KLPDetector kLPDetector;
        try {
            KLPDetector kLPDetector2 = kLPDetector4;
            kLPDetector = kLPDetector2;
            object = kLPDetector2.interpreterLock;
        }
        catch (Exception exception) {}
        Interpreter interpreter = kLPDetector.interpreter;
        if (interpreter != null) {
            if (interpreter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"interpreter");
                interpreter = null;
            }
            interpreter.close();
        }
        KLPDetector kLPDetector3 = kLPDetector4;
        Object object2 = object;
        // MONITOREXIT : object2
        KLPDetector kLPDetector4 = kLPDetector3.gpuDelegate;
        if (kLPDetector4 == null) return;
        kLPDetector4.close();
        return;
        catch (Throwable throwable) {
            // MONITOREXIT : object
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    public final synchronized void detect(@NotNull Bitmap var1_4, @NotNull Function0<Unit> var2_7) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 16[TRYBLOCK] [24 : 272->281)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final synchronized List<BoundingBox> getCurrentBoundingBoxes(@NotNull Bitmap var1_5) {
        Intrinsics.checkNotNullParameter((Object)var1_5, (String)"frame");
        var2_6 = this.tensorWidth;
        if (var2_6 != 0 && (var3_10 = this.tensorHeight) != 0 && this.numChannel != 0 && this.numElements != 0) {
            v0 = this;
            v1 = v0;
            v2 = v0;
            v3 = v0;
            var1_5 = Bitmap.createScaledBitmap((Bitmap)var1_5, (int)var2_6, (int)var3_10, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)var1_5, (String)"createScaledBitmap(frame\u2026dth, tensorHeight, false)");
            var2_7 /* !! */  = v4;
            var2_7 /* !! */ (this.INPUT_IMAGE_TYPE);
            v4.load((Bitmap)var1_5);
            var1_5 = (TensorImage)v2.imageProcessor.process((Object)var2_7 /* !! */ );
            v5 = new int[3];
            var2_7 /* !! */  = (TensorImage)v5;
            v6 = this;
            v7 /* !! */  = var2_7 /* !! */ ;
            v8 = this;
            v9 /* !! */  = var2_7 /* !! */ ;
            v10 = this;
            var2_7 /* !! */ [0] = (TensorImage)true;
            var2_8 = 1;
            v9 /* !! */ [var2_8] = (TensorImage)v10.numChannel;
            var2_8 = 2;
            v7 /* !! */ [var2_8] = (TensorImage)v8.numElements;
            var2_9 = TensorBuffer.createFixedSize((int[])v5, (DataType)v6.OUTPUT_IMAGE_TYPE);
            Intrinsics.checkNotNullExpressionValue((Object)var2_9, (String)"createFixedSize(\n       \u2026_IMAGE_TYPE\n            )");
            var3_11 = v3.interpreterLock;
            ** synchronized (var3_11)
lbl-1000:
            // 1 sources

            {
                block35: {
                    block34: {
                        block33: {
                            var4_12 = v1.interpreter;
                            if (var4_12 != null) break block33;
                            Intrinsics.throwUninitializedPropertyAccessException((String)"interpreter");
                            var4_12 = null;
                        }
                        v11 = this;
                        v12 = var2_9;
                        v13 = var3_11;
                        v14 = var4_12;
                        v15 = var2_9;
                        var1_5 = var1_5.getBuffer();
                        v14.run(var1_5, (Object)v15.getBuffer());
                        // ** MonitorExit[v13] (shouldn't be in output)
                        v16 = v12.getFloatArray();
                        Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"output.floatArray");
                        var1_5 = v11.bestBox(v16);
                        if (var1_5 == null) break block34;
                        v17 = var1_5;
                        var1_5 = v18;
                        v18 = new ArrayList<E>();
                        var2_9 = v17.iterator();
                        while (true) {
                            block37: {
                                block36: {
                                    if (!var2_9.hasNext()) break block35;
                                    var3_11 = var2_9.next();
                                    var4_12 = (BoundingBox)var3_11;
                                    if (!Intrinsics.areEqual((Object)var4_12.getClsName(), (Object)"corner")) break block36;
                                    if (!(var4_12.getCnf() > this.CORNER_CONF)) break block36;
                                    v19 = true;
                                    break block37;
                                }
                                v19 = false;
                            }
                            if (!v19) continue;
                            var1_5.add(var3_11);
                        }
                    }
                    var1_5 = CollectionsKt.emptyList();
                }
                if (var1_5.size() != 4) {
                    var1_5 = null;
                }
                catch (Throwable var0_1) {
                    try {
                        throw var0_1;
                    }
                    catch (Exception var0_2) {
                        Helpers.Companion.printLog(new Object[]{"Error running interpreter: " + var0_2.getMessage()});
                        var1_5 = null;
                    }
                    catch (IllegalArgumentException var0_3) {
                        Helpers.Companion.printLog(new Object[]{"IllegalArgumentException: " + var0_3.getMessage()});
                        var1_5 = null;
                    }
                    catch (OutOfMemoryError var0_4) {
                        Helpers.Companion.printLog(new Object[]{"OutOfMemoryError: " + var0_4.getMessage()});
                        var1_5 = null;
                    }
                }
                return var1_5;
            }
        }
        Helpers.Companion.printLog(new Object[]{"Tensor dimensions are not initialized."});
        return null;
    }

    @Override
    public void onEmptyDetect() {
        this.onImageListener.onImageNotDetected();
    }

    @Override
    public void onDetect(int n3, int n4, @NotNull List<BoundingBox> object, long l3, @NotNull Function0<Unit> function0) {
        int n5;
        PointF pointF;
        PointF pointF2;
        ArrayList<BoundingBox> arrayList;
        ArrayList arrayList2;
        Intrinsics.checkNotNullParameter(object, (String)"boundingBoxes");
        Intrinsics.checkNotNullParameter(function0, (String)"doneProcessed");
        if (this.detected && this.isAutoCaptureOn) {
            return;
        }
        ArrayList arrayList3 = object;
        float f3 = (float)n3 * 0.75f;
        float f4 = n4;
        f3 = (f4 - f3) / (float)2 / f4;
        f4 = 1.0f - f3;
        object = arrayList2;
        arrayList2 = new ArrayList();
        Object object2 = arrayList;
        arrayList = new ArrayList<BoundingBox>();
        PointF pointF3 = pointF2;
        pointF2 = new PointF(Float.MAX_VALUE, Float.MAX_VALUE);
        PointF pointF4 = pointF;
        pointF = new PointF(Float.MIN_VALUE, Float.MIN_VALUE);
        for (BoundingBox boundingBox : arrayList3) {
            float f5;
            float f6 = boundingBox.getCnf();
            if (f6 < (f5 = Intrinsics.areEqual((Object)boundingBox.getClsName(), (Object)"card") ? this.CARD_CONF : this.CORNER_CONF)) continue;
            if (Intrinsics.areEqual((Object)boundingBox.getClsName(), (Object)"card")) {
                ((ArrayList)object2).add(boundingBox);
            } else if (Intrinsics.areEqual((Object)boundingBox.getClsName(), (Object)"corner")) {
                ((ArrayList)object).add(boundingBox);
            }
            if (boundingBox.getY1() < pointF3.y) {
                pointF3.y = boundingBox.getY1();
            }
            if (boundingBox.getX1() < pointF3.x) {
                pointF3.x = boundingBox.getX1();
            }
            if (boundingBox.getY2() > pointF4.y) {
                pointF4.y = boundingBox.getY2();
            }
            if (!(boundingBox.getX2() > pointF4.x)) continue;
            pointF4.x = boundingBox.getX2();
        }
        if (((ArrayList)object2).size() == 1 && 4 <= (n5 = ((ArrayList)object).size()) && n5 < 6 && pointF3.y > f3 && pointF4.y < f4) {
            KLPDetector kLPDetector = this;
            kLPDetector.onImageListener.onImageInMask();
            if (kLPDetector.conditionStartTime == 0L) {
                this.conditionStartTime = SystemClock.uptimeMillis();
                this.previousBoundingBox = (BoundingBox)((ArrayList)object).get(0);
            } else {
                long l4 = SystemClock.uptimeMillis() - this.conditionStartTime;
                Object e3 = ((ArrayList)object).get(0);
                Intrinsics.checkNotNullExpressionValue(e3, (String)"corners[0]");
                object = (BoundingBox)e3;
                object2 = this.previousBoundingBox;
                if (object2 == null) {
                    return;
                }
                if (this.hasMovedSignificantly((BoundingBox)object2, (BoundingBox)object)) {
                    this.onImageListener.onImageOutOfMask();
                    this.conditionStartTime = 0L;
                } else if (l4 >= this.VERIFY_CAPTURING_DURATION && this.isAutoCaptureOn) {
                    this.onImageListener.onImageDetected();
                    this.detected = true;
                }
                this.previousBoundingBox = object;
            }
        } else {
            this.conditionStartTime = 0L;
            if (object2.isEmpty() ^ true) {
                this.onImageListener.onImageOutOfMask();
            }
        }
        function0.invoke();
    }
}

