/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.capturesdk.tflite;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vn.kalapa.ekyc.KalapaSDK;
import vn.kalapa.ekyc.capturesdk.tflite.BoundingBox;

@SourceDebugExtension(value={"SMAP\nOverlayView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OverlayView.kt\nvn/kalapa/ekyc/capturesdk/tflite/OverlayView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1855#2,2:84\n*S KotlinDebug\n*F\n+ 1 OverlayView.kt\nvn/kalapa/ekyc/capturesdk/tflite/OverlayView\n*L\n51#1:84,2\n*E\n"})
public final class OverlayView
extends View {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int BOUNDING_RECT_TEXT_PADDING = 8;
    @NotNull
    private List<BoundingBox> results;
    @NotNull
    private Paint boxPaint;
    @NotNull
    private Paint textBackgroundPaint;
    @NotNull
    private Paint textPaint;
    @NotNull
    private Rect bounds;

    public OverlayView(@Nullable Context context, @Nullable AttributeSet attributeSet) {
        OverlayView overlayView = this;
        super(context, attributeSet);
        overlayView.results = CollectionsKt.emptyList();
        overlayView.boxPaint = new Paint();
        overlayView.textBackgroundPaint = new Paint();
        overlayView.textPaint = new Paint();
        overlayView.bounds = new Rect();
        overlayView.initPaints();
    }

    private final void initPaints() {
        OverlayView overlayView = this;
        overlayView.textBackgroundPaint.setColor(-16777216);
        overlayView.textBackgroundPaint.setStyle(Paint.Style.FILL);
        overlayView.textBackgroundPaint.setTextSize(50.0f);
        overlayView.textPaint.setColor(-1);
        overlayView.textPaint.setStyle(Paint.Style.FILL);
        overlayView.textPaint.setTextSize(50.0f);
        overlayView.boxPaint.setColor(Color.parseColor((String)KalapaSDK.Companion.getConfig$kalapa_release().getMainColor()));
        overlayView.boxPaint.setStrokeWidth(8.0f);
        overlayView.boxPaint.setStyle(Paint.Style.STROKE);
    }

    public final void clear() {
        OverlayView overlayView = this;
        overlayView.results = CollectionsKt.emptyList();
        overlayView.textPaint.reset();
        overlayView.textBackgroundPaint.reset();
        overlayView.boxPaint.reset();
        overlayView.invalidate();
        overlayView.initPaints();
    }

    public void draw(@NotNull Canvas canvas) {
        OverlayView overlayView = this;
        Canvas canvas2 = canvas;
        Intrinsics.checkNotNullParameter((Object)canvas2, (String)"canvas");
        super.draw(canvas2);
        for (BoundingBox f9 : overlayView.results) {
            float n3;
            float f3 = f9.getX1() * (float)this.getWidth();
            float f4 = f9.getY1() * (float)this.getHeight();
            float f5 = n3 = f4;
            float f6 = n3;
            OverlayView overlayView2 = this;
            float f7 = n3;
            BoundingBox boundingBox = f9;
            float f8 = boundingBox.getX2() * (float)this.getWidth();
            n3 = boundingBox.getY2() * (float)this.getHeight();
            Paint f10 = this.boxPaint;
            canvas.drawRect(f3, f7, f8, n3, f10);
            String object = f9.getClsName();
            int n4 = object.length();
            f10 = this.bounds;
            overlayView2.textBackgroundPaint.getTextBounds(object, 0, n4, (Rect)f10);
            n4 = this.bounds.height();
            float f11 = 8;
            float f12 = f3 + (float)overlayView2.bounds.width() + f11;
            n3 = f6 + (float)n4 + f11;
            f10 = this.textBackgroundPaint;
            canvas.drawRect(f3, f5, f12, n3, f10);
            n3 = f4 + (float)this.bounds.height();
            f10 = this.textPaint;
            canvas.drawText(object, f3, n3, f10);
        }
    }

    public final void setResults(@NotNull List<BoundingBox> list) {
        Intrinsics.checkNotNullParameter(list, (String)"boundingBoxes");
        this.results = list;
        this.invalidate();
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

