/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.codescanner;

import android.graphics.Bitmap;
import androidx.camera.core.ExperimentalGetImage;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageProxy;
import com.google.android.gms.tasks.Task;
import com.google.mlkit.vision.barcode.BarcodeScanner;
import com.google.mlkit.vision.barcode.BarcodeScannerOptions;
import com.google.mlkit.vision.barcode.BarcodeScanning;
import com.google.mlkit.vision.barcode.ZoomSuggestionOptions;
import com.google.mlkit.vision.barcode.common.Barcode;
import com.google.mlkit.vision.common.InputImage;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vn.kalapa.ekyc.codescanner.BitmapUtils;
import vn.kalapa.ekyc.codescanner.QRCodeAnalyzer;

public final class QRCodeAnalyzer
implements ImageAnalysis.Analyzer {
    @NotNull
    private final Function2<Barcode, Bitmap, Unit> onSuccess;
    @NotNull
    private final Function1<Exception, Unit> onFailure;
    @NotNull
    private final Function1<Boolean, Unit> onPassCompleted;
    @NotNull
    private final Function1<Float, Unit> suggestZoomRatio;
    @NotNull
    private final Lazy barcodeScanner$delegate;
    private volatile boolean failureOccurred;
    private long failureTimestamp;
    private volatile boolean qrCodeDetected;

    public QRCodeAnalyzer(@NotNull Function2<? super Barcode, ? super Bitmap, Unit> function2, @NotNull Function1<? super Exception, Unit> function1, @NotNull Function1<? super Boolean, Unit> function12, @NotNull Function1<? super Float, Unit> function13) {
        QRCodeAnalyzer qRCodeAnalyzer = this;
        Intrinsics.checkNotNullParameter(function2, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(function1, (String)"onFailure");
        Intrinsics.checkNotNullParameter(function12, (String)"onPassCompleted");
        Intrinsics.checkNotNullParameter(function13, (String)"suggestZoomRatio");
        this.onSuccess = function2;
        this.onFailure = function1;
        this.onPassCompleted = function12;
        qRCodeAnalyzer.suggestZoomRatio = function13;
        qRCodeAnalyzer.barcodeScanner$delegate = LazyKt.lazy((Function0)new Function0<BarcodeScanner>(this){
            public final /* synthetic */ QRCodeAnalyzer this$0;
            {
                this.this$0 = qRCodeAnalyzer;
                super(0);
            }

            private static final boolean invoke$lambda$0(QRCodeAnalyzer qRCodeAnalyzer, float f3) {
                QRCodeAnalyzer qRCodeAnalyzer2 = qRCodeAnalyzer;
                Intrinsics.checkNotNullParameter((Object)qRCodeAnalyzer2, (String)"this$0");
                QRCodeAnalyzer.access$getSuggestZoomRatio$p(qRCodeAnalyzer2).invoke((Object)Float.valueOf(f3));
                return true;
            }

            @Nullable
            public final BarcodeScanner invoke() {
                barcodeScanner.2 this_;
                BarcodeScannerOptions.Builder builder = new BarcodeScannerOptions.Builder().setZoomSuggestionOptions(new ZoomSuggestionOptions.Builder(arg_0 -> barcodeScanner.2.invoke$lambda$0(this_.this$0, arg_0)).build()).setBarcodeFormats(256, new int[0]);
                Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder()\n            .s\u2026s(Barcode.FORMAT_QR_CODE)");
                try {
                    this_ = BarcodeScanning.getClient((BarcodeScannerOptions)builder.build());
                }
                catch (Exception exception) {
                    QRCodeAnalyzer.access$getOnFailure$p(this_.this$0).invoke((Object)exception);
                    this_ = null;
                }
                return this_;
            }
        });
    }

    public /* synthetic */ QRCodeAnalyzer(Function2 function2, Function1 function1, Function1 function12, Function1 function13, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            function13 = 1.INSTANCE;
        }
        this((Function2<? super Barcode, ? super Bitmap, Unit>)function2, (Function1<? super Exception, Unit>)function1, (Function1<? super Boolean, Unit>)function12, (Function1<? super Float, Unit>)function13);
    }

    private final BarcodeScanner getBarcodeScanner() {
        return (BarcodeScanner)this.barcodeScanner$delegate.getValue();
    }

    private static final void analyze$lambda$3$lambda$0(Function1 function1, Object object) {
        Function1 function12 = function1;
        Intrinsics.checkNotNullParameter((Object)function12, (String)"$tmp0");
        function12.invoke(object);
    }

    private static final void analyze$lambda$3$lambda$1(QRCodeAnalyzer qRCodeAnalyzer, Exception exception) {
        Intrinsics.checkNotNullParameter((Object)qRCodeAnalyzer, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"it");
        qRCodeAnalyzer.failureOccurred = true;
        qRCodeAnalyzer.failureTimestamp = System.currentTimeMillis();
        qRCodeAnalyzer.onFailure.invoke((Object)exception);
    }

    private static final void analyze$lambda$3$lambda$2(QRCodeAnalyzer qRCodeAnalyzer, ImageProxy imageProxy, Task task) {
        Intrinsics.checkNotNullParameter((Object)qRCodeAnalyzer, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)imageProxy, (String)"$imageProxy");
        Intrinsics.checkNotNullParameter((Object)task, (String)"it");
        qRCodeAnalyzer.onPassCompleted.invoke((Object)qRCodeAnalyzer.failureOccurred);
        imageProxy.close();
    }

    public static final /* synthetic */ void access$setQrCodeDetected$p(QRCodeAnalyzer qRCodeAnalyzer, boolean bl) {
        qRCodeAnalyzer.qrCodeDetected = bl;
    }

    public static final /* synthetic */ Function2 access$getOnSuccess$p(QRCodeAnalyzer qRCodeAnalyzer) {
        return qRCodeAnalyzer.onSuccess;
    }

    public static final /* synthetic */ Function1 access$getOnFailure$p(QRCodeAnalyzer qRCodeAnalyzer) {
        return qRCodeAnalyzer.onFailure;
    }

    public static final /* synthetic */ Function1 access$getSuggestZoomRatio$p(QRCodeAnalyzer qRCodeAnalyzer) {
        return qRCodeAnalyzer.suggestZoomRatio;
    }

    @ExperimentalGetImage
    public void analyze(@NotNull ImageProxy imageProxy) {
        ImageProxy imageProxy2 = imageProxy;
        Intrinsics.checkNotNullParameter((Object)imageProxy2, (String)"imageProxy");
        if (imageProxy2.getImage() != null && !this.qrCodeDetected) {
            if (this.failureOccurred && System.currentTimeMillis() - this.failureTimestamp < 1000L) {
                imageProxy.close();
                return;
            }
            this.failureOccurred = false;
            Bitmap bitmap = BitmapUtils.INSTANCE.getBitmap(imageProxy);
            if (bitmap == null) {
                imageProxy.close();
                return;
            }
            InputImage inputImage = InputImage.fromBitmap((Bitmap)bitmap, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)inputImage, (String)"fromBitmap(bitmap, 0)");
            BarcodeScanner barcodeScanner2 = this.getBarcodeScanner();
            if (barcodeScanner2 != null && !this.qrCodeDetected) {
                barcodeScanner2.process(inputImage).addOnSuccessListener(arg_0 -> QRCodeAnalyzer.analyze$lambda$3$lambda$0((Function1)new Function1<List<Barcode>, Unit>(this, bitmap){
                    public final /* synthetic */ QRCodeAnalyzer this$0;
                    public final /* synthetic */ Bitmap $bitmap;
                    {
                        this.this$0 = qRCodeAnalyzer;
                        this.$bitmap = bitmap;
                        super(1);
                    }

                    public final void invoke(List<Barcode> object) {
                        Barcode barcode2;
                        block2: {
                            List<Barcode> list = object;
                            Intrinsics.checkNotNullExpressionValue(list, (String)"codes");
                            for (Barcode barcode2 : list) {
                                if (barcode2 == null) continue;
                                break block2;
                            }
                            barcode2 = null;
                        }
                        if (barcode2 != null) {
                            QRCodeAnalyzer qRCodeAnalyzer = this_.this$0;
                            analyze.1.1 this_ = this_.$bitmap;
                            QRCodeAnalyzer.access$setQrCodeDetected$p(qRCodeAnalyzer, true);
                            QRCodeAnalyzer.access$getOnSuccess$p(qRCodeAnalyzer).invoke((Object)barcode2, (Object)((Object)this_));
                        }
                    }
                }, arg_0)).addOnFailureListener(arg_0 -> QRCodeAnalyzer.analyze$lambda$3$lambda$1(this, arg_0)).addOnCompleteListener(arg_0 -> QRCodeAnalyzer.analyze$lambda$3$lambda$2(this, imageProxy, arg_0));
            }
            return;
        }
        imageProxy.close();
    }

    public final void reset() {
        this.qrCodeDetected = false;
    }
}

