/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.codescanner;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vn.kalapa.R;
import vn.kalapa.ekyc.managers.KLPLanguageManager;

public final class QRScannerOverlayView
extends View {
    @NotNull
    private final Paint framePaint;
    @NotNull
    private final Paint textPaint;
    @NotNull
    private final Paint overlayPaint;
    private final float cornerLength;
    @NotNull
    private final RectF frameRect;
    private final float scannerFrameSize;
    @NotNull
    private final BlurMaskFilter blurMaskFilter;

    @JvmOverloads
    public QRScannerOverlayView(@NotNull Context context, @Nullable AttributeSet attributeSet, int n3) {
        BlurMaskFilter blurMaskFilter;
        Paint paint;
        QRScannerOverlayView qRScannerOverlayView = qRScannerOverlayView2;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, attributeSet, n3);
        Paint paint2 = new Paint();
        paint2.setColor(-1);
        paint2.setStyle(Paint.Style.STROKE);
        paint2.setStrokeWidth(qRScannerOverlayView2.dpToPx(4.0f));
        qRScannerOverlayView.framePaint = paint2;
        Paint paint3 = new Paint();
        paint3.setColor(-1);
        paint3.setTextSize(qRScannerOverlayView2.dpToPx(16.0f));
        paint3.setAntiAlias(true);
        qRScannerOverlayView.textPaint = paint3;
        Context context3 = context = paint;
        super();
        context3.setColor(Color.parseColor((String)"#BF000000"));
        qRScannerOverlayView2.overlayPaint = context3;
        qRScannerOverlayView2.cornerLength = qRScannerOverlayView2.dpToPx(25.0f);
        qRScannerOverlayView2.frameRect = new RectF();
        qRScannerOverlayView2.scannerFrameSize = 250.0f;
        QRScannerOverlayView qRScannerOverlayView2 = blurMaskFilter;
        v7.blurMaskFilter = new BlurMaskFilter(20.0f, BlurMaskFilter.Blur.NORMAL);
        paint.setMaskFilter((MaskFilter)qRScannerOverlayView2);
        qRScannerOverlayView.setLayerType(2, null);
    }

    public /* synthetic */ QRScannerOverlayView(Context context, AttributeSet attributeSet, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            attributeSet = null;
        }
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        this(context, attributeSet, n3);
    }

    private final float dpToPx(float f3) {
        return f3 * this.getContext().getResources().getDisplayMetrics().density;
    }

    @JvmOverloads
    public QRScannerOverlayView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public QRScannerOverlayView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @SuppressLint(value={"DrawAllocation"})
    public void onDraw(@NotNull Canvas canvas) {
        TextPaint textPaint;
        TextPaint textPaint2;
        Path path;
        Path path2;
        Path path3;
        Path path4;
        float f3;
        Canvas canvas2 = canvas;
        QRScannerOverlayView qRScannerOverlayView = qRScannerOverlayView5;
        QRScannerOverlayView qRScannerOverlayView2 = qRScannerOverlayView5;
        Canvas canvas3 = canvas;
        Intrinsics.checkNotNullParameter((Object)canvas3, (String)"canvas");
        super.onDraw(canvas3);
        float f4 = qRScannerOverlayView2.getWidth();
        float f5 = qRScannerOverlayView2.getHeight();
        Paint paint = qRScannerOverlayView2.overlayPaint;
        canvas.drawRect(0.0f, 0.0f, f4, f5, paint);
        f4 = qRScannerOverlayView.dpToPx(qRScannerOverlayView.scannerFrameSize);
        f5 = qRScannerOverlayView.dpToPx(qRScannerOverlayView.scannerFrameSize);
        float f6 = ((float)qRScannerOverlayView.getWidth() - f4) / 2.0f;
        float f7 = f3 = ((float)qRScannerOverlayView.getHeight() - f5) / 2.0f;
        f4 = f6 + f4;
        qRScannerOverlayView.frameRect.set(f6, f7, f4, f7 + f5);
        RectF rectF = qRScannerOverlayView.frameRect;
        Paint paint2 = new Paint();
        paint2.setStyle(Paint.Style.FILL);
        paint2.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        canvas.drawRect(rectF, paint2);
        Object object = path4;
        object();
        RectF rectF2 = qRScannerOverlayView5.frameRect;
        object.moveTo(rectF2.left, rectF2.top + qRScannerOverlayView5.cornerLength);
        RectF rectF3 = qRScannerOverlayView5.frameRect;
        float f8 = rectF3.left;
        object.lineTo(f8, rectF3.top);
        RectF rectF4 = qRScannerOverlayView5.frameRect;
        f8 = rectF4.left + qRScannerOverlayView5.cornerLength;
        path4.lineTo(f8, rectF4.top);
        canvas.drawPath((Path)object, qRScannerOverlayView5.framePaint);
        object = path3;
        object();
        RectF rectF5 = qRScannerOverlayView5.frameRect;
        f8 = rectF5.right - qRScannerOverlayView5.cornerLength;
        object.moveTo(f8, rectF5.top);
        RectF rectF6 = qRScannerOverlayView5.frameRect;
        f8 = rectF6.right;
        object.lineTo(f8, rectF6.top);
        RectF rectF7 = qRScannerOverlayView5.frameRect;
        path3.lineTo(rectF7.right, rectF7.top + qRScannerOverlayView5.cornerLength);
        canvas.drawPath((Path)object, qRScannerOverlayView5.framePaint);
        object = path2;
        object();
        rectF7 = qRScannerOverlayView5.frameRect;
        object.moveTo(rectF7.left, rectF7.bottom - qRScannerOverlayView5.cornerLength);
        RectF rectF8 = qRScannerOverlayView5.frameRect;
        float f9 = rectF8.left;
        object.lineTo(f9, rectF8.bottom);
        RectF rectF9 = qRScannerOverlayView5.frameRect;
        f9 = rectF9.left + qRScannerOverlayView5.cornerLength;
        path2.lineTo(f9, rectF9.bottom);
        canvas.drawPath((Path)object, qRScannerOverlayView5.framePaint);
        object = path;
        object();
        RectF rectF10 = qRScannerOverlayView5.frameRect;
        f9 = rectF10.right - qRScannerOverlayView5.cornerLength;
        object.moveTo(f9, rectF10.bottom);
        RectF rectF11 = qRScannerOverlayView5.frameRect;
        f9 = rectF11.right;
        object.lineTo(f9, rectF11.bottom);
        RectF rectF12 = qRScannerOverlayView5.frameRect;
        path.lineTo(rectF12.right, rectF12.bottom - qRScannerOverlayView5.cornerLength);
        canvas2.drawPath((Path)object, qRScannerOverlayView5.framePaint);
        object = KLPLanguageManager.INSTANCE;
        String string2 = qRScannerOverlayView5.getContext().getString(R.string.klp_qr_code_scan_guide);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.string.klp_qr_code_scan_guide)");
        String string3 = ((KLPLanguageManager)object).get(string2);
        QRScannerOverlayView qRScannerOverlayView3 = qRScannerOverlayView5;
        float f10 = qRScannerOverlayView3.dpToPx(16.0f);
        int n3 = string3.length();
        TextPaint textPaint3 = textPaint2;
        textPaint2 = new TextPaint(qRScannerOverlayView5.textPaint);
        int n4 = (int)((float)qRScannerOverlayView3.getWidth() - (float)2 * f10);
        StaticLayout staticLayout = StaticLayout.Builder.obtain((CharSequence)string3, (int)0, (int)n3, (TextPaint)textPaint3, (int)n4).setAlignment(Layout.Alignment.ALIGN_CENTER).setLineSpacing(0.0f, 1.0f).setIncludePad(false).build();
        Canvas canvas4 = canvas;
        QRScannerOverlayView qRScannerOverlayView4 = qRScannerOverlayView5;
        Intrinsics.checkNotNullExpressionValue((Object)staticLayout, (String)"obtain(\n            text\u2026lse)\n            .build()");
        float f11 = qRScannerOverlayView4.frameRect.bottom + qRScannerOverlayView5.dpToPx(16.0f);
        float f12 = qRScannerOverlayView4.frameRect.top - (float)staticLayout.getHeight() - qRScannerOverlayView5.dpToPx(16.0f);
        canvas.save();
        canvas4.translate(f10, f11);
        staticLayout.draw(canvas4);
        canvas.restore();
        String string4 = qRScannerOverlayView5.getContext().getString(R.string.klp_tap_to_focus);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"context.getString(R.string.klp_tap_to_focus)");
        String string5 = ((KLPLanguageManager)object).get(string4);
        TextPaint textPaint4 = textPaint;
        textPaint = new TextPaint(qRScannerOverlayView5.textPaint);
        QRScannerOverlayView qRScannerOverlayView5 = StaticLayout.Builder.obtain((CharSequence)string5, (int)0, (int)string5.length(), (TextPaint)textPaint4, (int)n4).setAlignment(Layout.Alignment.ALIGN_CENTER).setLineSpacing(0.0f, 1.0f).setIncludePad(false).build();
        Canvas canvas5 = canvas;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)qRScannerOverlayView5), (String)"obtain(\n            abov\u2026lse)\n            .build()");
        canvas.save();
        canvas5.translate(f10, f12);
        qRScannerOverlayView5.draw(canvas5);
        canvas2.restore();
    }
}

