/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.codescanner;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QrDetectionView
extends View {
    @Nullable
    private RectF boundingBox;
    @Nullable
    private RectF targetBoundingBox;
    @NotNull
    private final Paint cornerPaint;
    private final float cornerLength;
    private final int startColor;
    private final int endColor;
    private int currentColor;
    private float scaleProgress;
    private float colorProgress;
    private final float initialScale;
    @NotNull
    private final Path path;
    private final ValueAnimator propertyAnimator;

    @JvmOverloads
    public QrDetectionView(@NotNull Context context, @Nullable AttributeSet attributeSet, int n3) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, attributeSet, n3);
        Paint paint = new Paint();
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(12.0f);
        this.cornerPaint = paint;
        this.cornerLength = 40.0f;
        this.startColor = -256;
        this.endColor = -16711936;
        this.currentColor = -256;
        this.initialScale = 1.5f;
        this.path = new Path();
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        valueAnimator.setDuration(300L);
        valueAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        valueAnimator.addUpdateListener(arg_0 -> QrDetectionView.propertyAnimator$lambda$2$lambda$1(this, arg_0));
        this.propertyAnimator = valueAnimator;
    }

    public /* synthetic */ QrDetectionView(Context context, AttributeSet attributeSet, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            attributeSet = null;
        }
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        this(context, attributeSet, n3);
    }

    private final void updateColor() {
        QrDetectionView qrDetectionView = this;
        int n3 = Color.red((int)qrDetectionView.startColor);
        int n4 = Color.red((int)qrDetectionView.endColor);
        float f3 = qrDetectionView.colorProgress;
        int n5 = qrDetectionView.evaluateColor(n3, n4, f3);
        QrDetectionView qrDetectionView2 = this;
        int n6 = Color.green((int)qrDetectionView2.startColor);
        n3 = Color.green((int)qrDetectionView2.endColor);
        float f4 = qrDetectionView2.colorProgress;
        n6 = qrDetectionView2.evaluateColor(n6, n3, f4);
        n3 = Color.blue((int)qrDetectionView2.startColor);
        int n7 = Color.blue((int)qrDetectionView2.endColor);
        f3 = qrDetectionView2.colorProgress;
        qrDetectionView.currentColor = n6 = Color.rgb((int)n5, (int)n6, (int)qrDetectionView2.evaluateColor(n3, n7, f3));
        qrDetectionView.cornerPaint.setColor(n6);
    }

    private final int evaluateColor(int n3, int n4, float f3) {
        int n5 = n3;
        float f4 = n5;
        return (int)((float)(n4 - n5) * f3 + f4);
    }

    private final float lerp(float f3, float f4, float f5) {
        return (f4 - f3) * f5 + f3;
    }

    @JvmOverloads
    public QrDetectionView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public QrDetectionView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void propertyAnimator$lambda$2$lambda$1(QrDetectionView qrDetectionView, ValueAnimator valueAnimator) {
        QrDetectionView qrDetectionView2 = qrDetectionView;
        ValueAnimator valueAnimator2 = valueAnimator;
        Intrinsics.checkNotNullParameter((Object)((Object)qrDetectionView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)valueAnimator2, (String)"animation");
        Object object = valueAnimator2.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
        qrDetectionView.scaleProgress = ((Float)object).floatValue();
        Object object2 = valueAnimator.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Float");
        qrDetectionView2.colorProgress = ((Float)object2).floatValue();
        qrDetectionView2.updateColor();
        qrDetectionView2.invalidate();
    }

    public final void showDetection(@NotNull Rect rect, int n3, int n4, @NotNull Function0<Unit> function0) {
        QrDetectionView qrDetectionView = this;
        Rect rect2 = rect;
        QrDetectionView qrDetectionView2 = this;
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter(function0, (String)"onAnimFinished");
        float f3 = (float)qrDetectionView2.getWidth() / (float)n3;
        float f4 = (float)qrDetectionView2.getHeight() / (float)n4;
        float f5 = (float)rect2.left * f3;
        float f6 = (float)rect2.top * f4;
        f4 = (float)rect2.bottom * f4;
        float f7 = f4 - f6;
        float f8 = (float)rect2.width() * f3;
        f3 = 2;
        float f9 = f5 = f8 / f3 + f5;
        float f10 = f7 / f3;
        float f11 = f9 - f10;
        f10 = f9 + f10;
        this.targetBoundingBox = new RectF(f11, f6, f10, f4);
        Intrinsics.checkNotNull((Object)this.targetBoundingBox);
        f4 = this.targetBoundingBox.centerY();
        float f12 = f7;
        float f13 = this.initialScale;
        f6 = f5 - f7 * f13 / f3;
        f7 = f4 - f7 * f13 / f3;
        f5 = f12 * f13 / f3 + f5;
        f13 = f12 * f13 / f3 + f4;
        qrDetectionView.boundingBox = new RectF(f6, f7, f5, f13);
        qrDetectionView.propertyAnimator.cancel();
        qrDetectionView.propertyAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(function0){
            public final /* synthetic */ Function0<Unit> $onAnimFinished;
            {
                this.$onAnimFinished = function0;
            }

            public void onAnimationEnd(@NotNull Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animation");
                this.$onAnimFinished.invoke();
            }
        });
        qrDetectionView.propertyAnimator.start();
    }

    public final void hideDetection() {
        QrDetectionView qrDetectionView = this;
        qrDetectionView.propertyAnimator.cancel();
        qrDetectionView.boundingBox = null;
        qrDetectionView.targetBoundingBox = null;
        qrDetectionView.invalidate();
    }

    public void onDraw(@NotNull Canvas canvas) {
        RectF rectF;
        QrDetectionView qrDetectionView = qrDetectionView6;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        RectF rectF2 = qrDetectionView.boundingBox;
        if (rectF2 != null && (rectF = qrDetectionView6.targetBoundingBox) != null) {
            RectF rectF3;
            QrDetectionView qrDetectionView2 = qrDetectionView6;
            QrDetectionView qrDetectionView3 = qrDetectionView6;
            QrDetectionView qrDetectionView4 = qrDetectionView6;
            QrDetectionView qrDetectionView5 = qrDetectionView6;
            float f3 = rectF2.left;
            float f4 = rectF.left;
            float f5 = qrDetectionView5.scaleProgress;
            f3 = qrDetectionView5.lerp(f3, f4, f5);
            f4 = rectF2.top;
            f5 = rectF.top;
            float f6 = qrDetectionView4.scaleProgress;
            f4 = qrDetectionView4.lerp(f4, f5, f6);
            f5 = rectF2.right;
            f6 = rectF.right;
            float f7 = qrDetectionView3.scaleProgress;
            f5 = qrDetectionView3.lerp(f5, f6, f7);
            f6 = rectF2.bottom;
            f7 = rectF.bottom;
            float f8 = qrDetectionView2.scaleProgress;
            f6 = qrDetectionView2.lerp(f6, f7, f8);
            RectF rectF4 = rectF3;
            rectF3 = new RectF(f3, f4, f5, f6);
            qrDetectionView2.path.reset();
            RectF rectF5 = rectF4;
            f3 = rectF5.left + qrDetectionView6.cornerLength;
            qrDetectionView2.path.moveTo(f3, rectF5.top);
            RectF rectF6 = rectF4;
            f3 = rectF6.left;
            qrDetectionView2.path.lineTo(f3, rectF6.top);
            qrDetectionView2.path.lineTo(rectF4.left, rectF4.top + qrDetectionView6.cornerLength);
            RectF rectF7 = rectF4;
            f3 = rectF7.right - qrDetectionView6.cornerLength;
            qrDetectionView2.path.moveTo(f3, rectF7.top);
            RectF rectF8 = rectF4;
            f3 = rectF8.right;
            qrDetectionView2.path.lineTo(f3, rectF8.top);
            qrDetectionView2.path.lineTo(rectF4.right, rectF4.top + qrDetectionView6.cornerLength);
            qrDetectionView2.path.moveTo(rectF4.left, rectF4.bottom - qrDetectionView6.cornerLength);
            RectF rectF9 = rectF4;
            f3 = rectF9.left;
            qrDetectionView2.path.lineTo(f3, rectF9.bottom);
            RectF rectF10 = rectF4;
            f3 = rectF10.left + qrDetectionView6.cornerLength;
            qrDetectionView2.path.lineTo(f3, rectF10.bottom);
            RectF rectF11 = rectF4;
            f3 = rectF11.right - qrDetectionView6.cornerLength;
            qrDetectionView2.path.moveTo(f3, rectF11.bottom);
            RectF rectF12 = rectF4;
            f3 = rectF12.right;
            qrDetectionView2.path.lineTo(f3, rectF12.bottom);
            qrDetectionView2.path.lineTo(rectF4.right, rectF4.bottom - qrDetectionView6.cornerLength);
            QrDetectionView qrDetectionView6 = qrDetectionView2.path;
            canvas.drawPath((Path)qrDetectionView6, qrDetectionView2.cornerPaint);
        }
    }
}

