/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.liveness;

import android.graphics.Bitmap;
import androidx.collection.LruCache;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.face.Face;
import com.google.mlkit.vision.face.FaceDetection;
import com.google.mlkit.vision.face.FaceDetector;
import com.google.mlkit.vision.face.FaceDetectorOptions;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vn.kalapa.ekyc.KalapaSDK;
import vn.kalapa.ekyc.liveness.InputFace;
import vn.kalapa.ekyc.liveness.LivenessSession;
import vn.kalapa.ekyc.liveness.LivenessSessionStatus;
import vn.kalapa.ekyc.liveness.models.ComeClose;
import vn.kalapa.ekyc.liveness.models.GoFar;
import vn.kalapa.ekyc.liveness.models.HoldSteady2Seconds;
import vn.kalapa.ekyc.liveness.models.LivenessAction;
import vn.kalapa.ekyc.liveness.models.LivenessActionStatus;
import vn.kalapa.ekyc.liveness.models.Processing;
import vn.kalapa.ekyc.liveness.models.Success;
import vn.kalapa.ekyc.liveness.models.TiltLeft;
import vn.kalapa.ekyc.liveness.models.TiltRight;
import vn.kalapa.ekyc.liveness.models.TurnDown;
import vn.kalapa.ekyc.liveness.models.TurnLeft;
import vn.kalapa.ekyc.liveness.models.TurnRight;
import vn.kalapa.ekyc.liveness.models.TurnUp;
import vn.kalapa.ekyc.managers.KLPFaceDetectorListener;
import vn.kalapa.ekyc.utils.Common;
import vn.kalapa.ekyc.utils.Helpers;

@SourceDebugExtension(value={"SMAP\nLivenessSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LivenessSession.kt\nvn/kalapa/ekyc/liveness/LivenessSession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,324:1\n1#2:325\n*E\n"})
public final class LivenessSession {
    @NotNull
    private Common.LIVENESS_VERSION livenessSessionType;
    @NotNull
    private LivenessSessionStatus sessionStatus;
    private final int MAX_N_FRAME;
    @NotNull
    private final ConcurrentLinkedQueue<InputFace> faceList;
    private final List<LivenessAction> actionList;
    private int currActionIdx;
    @Nullable
    private LivenessAction currAction;
    private Map<Integer, ? extends LivenessAction> index2Action;
    @NotNull
    private final String TAG;
    public Bitmap typicalFace;
    private boolean gotTypicalFace;
    private final int CACHE_SIZE;
    @NotNull
    private final LruCache<Long, Face> recentDetections;
    @NotNull
    private final CoroutineScope processingScope;
    private KLPFaceDetectorListener faceDetectorListener;
    @NotNull
    private final FaceDetector faceDetector;

    public LivenessSession(@NotNull Common.LIVENESS_VERSION lIVENESS_VERSION) {
        Intrinsics.checkNotNullParameter((Object)((Object)lIVENESS_VERSION), (String)"livenessSessionType");
        this.livenessSessionType = lIVENESS_VERSION;
        this.sessionStatus = LivenessSessionStatus.UNVERIFIED;
        this.MAX_N_FRAME = 600;
        this.faceList = new ConcurrentLinkedQueue();
        this.actionList = Collections.synchronizedList(new ArrayList());
        this.currActionIdx = -1;
        this.TAG = "OptimizedLivenessSession";
        this.CACHE_SIZE = 10;
        this.recentDetections = new LruCache(10);
        this.processingScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getDefault().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        FaceDetector faceDetector = FaceDetection.getClient((FaceDetectorOptions)new FaceDetectorOptions.Builder().setPerformanceMode(1).setClassificationMode(2).setMinFaceSize(0.25f).enableTracking().build());
        Intrinsics.checkNotNullExpressionValue((Object)faceDetector, (String)"getClient(\n        FaceD\u2026           .build()\n    )");
        this.faceDetector = faceDetector;
        this.genActionList();
    }

    public /* synthetic */ LivenessSession(Common.LIVENESS_VERSION lIVENESS_VERSION, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            lIVENESS_VERSION = Common.LIVENESS_VERSION.PASSIVE;
        }
        this(lIVENESS_VERSION);
    }

    private final void refreshFaceList() {
        LivenessSession livenessSession = this;
        livenessSession.faceList.clear();
        livenessSession.recentDetections.evictAll();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void genActionList() {
        void var1_6;
        Helpers.Companion.printLog("genActionList " + this.livenessSessionType.name());
        int n3 = WhenMappings.$EnumSwitchMapping$0[this.livenessSessionType.ordinal()];
        if (n3 != 1) {
            if (n3 != 2) {
                if (n3 != 3) throw new NoWhenBranchMatchedException();
                Map map = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)1, (Object)new HoldSteady2Seconds(1500)), TuplesKt.to((Object)2, (Object)new GoFar()), TuplesKt.to((Object)3, (Object)new ComeClose()), TuplesKt.to((Object)4, (Object)new Processing())});
            } else {
                void var4_17;
                void var4_14;
                void var4_11;
                Pair[] pairArray = new Pair[5];
                Pair[] pairArray2 = pairArray;
                pairArray[0] = TuplesKt.to((Object)1, (Object)new HoldSteady2Seconds(1500));
                int n4 = 1;
                Integer n5 = 2;
                if (Random.Default.nextInt(2) % 2 == 0) {
                    TurnLeft turnLeft;
                    TurnLeft turnLeft2 = turnLeft;
                    turnLeft = new TurnLeft();
                } else {
                    TurnRight turnRight;
                    TurnRight turnRight2 = turnRight;
                    turnRight = new TurnRight();
                }
                pairArray2[n4] = TuplesKt.to((Object)n5, (Object)var4_11);
                n4 = 2;
                n5 = 3;
                if (Random.Default.nextInt(2) % 2 == 0) {
                    TurnUp turnUp;
                    TurnUp turnUp2 = turnUp;
                    turnUp = new TurnUp();
                } else {
                    TurnDown turnDown;
                    TurnDown turnDown2 = turnDown;
                    turnDown = new TurnDown();
                }
                pairArray2[n4] = TuplesKt.to((Object)n5, (Object)var4_14);
                n4 = 3;
                n5 = 4;
                if (Random.Default.nextInt(2) % 2 == 0) {
                    TiltLeft tiltLeft;
                    TiltLeft tiltLeft2 = tiltLeft;
                    tiltLeft = new TiltLeft();
                } else {
                    TiltRight tiltRight;
                    TiltRight tiltRight2 = tiltRight;
                    tiltRight = new TiltRight();
                }
                Pair[] pairArray3 = pairArray2;
                pairArray3[n4] = TuplesKt.to((Object)n5, (Object)var4_17);
                pairArray3[4] = TuplesKt.to((Object)5, (Object)new Processing());
                Map map = MapsKt.mapOf((Pair[])pairArray2);
            }
        } else {
            Map map = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)1, (Object)new HoldSteady2Seconds(1500)), TuplesKt.to((Object)2, (Object)new Processing())});
        }
        this.index2Action = var1_6;
        this.currActionIdx = 0;
        this.currAction = null;
        this.actionList.clear();
    }

    private final void handleDetectionResult(List<? extends Face> list, Bitmap object, KLPFaceDetectorListener kLPFaceDetectorListener) {
        Object object6;
        int n3 = 0;
        if (list.isEmpty()) {
            object6.sessionStatus = LivenessSessionStatus.NO_FACE;
        } else {
            for (Face object22 : list) {
                InputFace inputFace;
                InputFace inputFace2 = inputFace;
                Object object2 = object;
                long l3 = System.currentTimeMillis();
                int n4 = object2.getWidth();
                int n5 = object2.getHeight();
                inputFace = new InputFace(l3, object22, n4, n5);
                if (!LivenessAction.Companion.isFaceSizeInRange(inputFace2)) continue;
                ++n3;
            }
            if (list.size() > 1 && n3 > 1) {
                object6.sessionStatus = LivenessSessionStatus.TOO_MANY_FACES;
                object6.refreshFaceList();
            } else {
                Object object3 = object;
                long l4 = System.currentTimeMillis();
                Face face = list.get(0);
                int n6 = object3.getWidth();
                int n7 = object3.getHeight();
                object6.processFaceDetection(new InputFace(l4, face, n6, n7), (Bitmap)object);
            }
        }
        LivenessSession livenessSession = object6;
        object = Helpers.Companion;
        Object[] objectArray = new Object[1];
        int n8 = 0;
        String string2 = livenessSession.TAG;
        Object object4 = livenessSession.currAction;
        object4 = object4 != null ? ((LivenessAction)object4).getTAG() : null;
        LivenessSession livenessSession2 = object6;
        LivenessSession livenessSession3 = object6;
        object6 = object6.sessionStatus;
        int n9 = list.size();
        int n10 = livenessSession3.faceList.size();
        objectArray[n8] = string2 + " Processing: " + (String)object4 + " - Status " + (LivenessSessionStatus)((Object)object6) + " " + n9 + " - faceList " + n10;
        ((Helpers.Companion)object).printLog(objectArray);
        object6 = livenessSession2.sessionStatus;
        Object object7 = livenessSession2.currAction;
        object7 = object7 != null ? ((LivenessAction)object7).getTAG() : null;
        kLPFaceDetectorListener.onMessage((LivenessSessionStatus)((Object)object6), (String)object7);
    }

    private final void processFaceDetection(InputFace inputFace, Bitmap bitmap) {
        LivenessAction.Companion companion = LivenessAction.Companion;
        if (companion.isFaceTooSmall(inputFace)) {
            this.sessionStatus = LivenessSessionStatus.TOO_SMALL;
        } else if (companion.isFaceTooBig(inputFace)) {
            this.sessionStatus = LivenessSessionStatus.TOO_LARGE;
        } else {
            boolean bl = true;
            LivenessAction livenessAction = this.currAction;
            if (livenessAction != null && livenessAction instanceof HoldSteady2Seconds) {
                int n3;
                int n4;
                Bitmap bitmap2 = bitmap;
                livenessAction = inputFace.getFace();
                if (!companion.isFaceMarginRight((Face)livenessAction, n4 = bitmap2.getWidth(), n3 = bitmap2.getHeight())) {
                    bl = false;
                    this.sessionStatus = LivenessSessionStatus.OFF_CENTER;
                    this.refreshFaceList();
                } else if (KalapaSDK.Companion.getConfig$kalapa_release().getLivenessVersion() != Common.LIVENESS_VERSION.ACTIVE.getVersion() && !companion.isFaceLookStraight(inputFace.getFace())) {
                    bl = false;
                    this.sessionStatus = LivenessSessionStatus.ANGLE_NOT_CORRECT;
                    this.refreshFaceList();
                }
            }
            if (bl) {
                LivenessSession livenessSession = this;
                livenessSession.faceList.add(inputFace);
                if (livenessSession.faceList.size() > this.MAX_N_FRAME) {
                    this.sessionStatus = LivenessSessionStatus.EXPIRED;
                } else {
                    this.handleAction(bitmap);
                }
            }
        }
    }

    private final void addAction(int n3, LivenessAction livenessAction) {
        int n4;
        int n5;
        LivenessSession livenessSession = this;
        livenessSession.currActionIdx = n5 = livenessSession.currActionIdx + n3;
        Map<Integer, ? extends LivenessAction> map = livenessSession.index2Action;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"index2Action");
            map = null;
        }
        if (n5 > (n4 = (map = (Integer)CollectionsKt.maxOrNull(map.keySet())) != null ? (Integer)((Object)map) : 0)) {
            this.sessionStatus = LivenessSessionStatus.VERIFIED;
            return;
        }
        if (n3 == 0) {
            if (livenessAction != null) {
                this.actionList.add(livenessAction);
            }
        } else {
            Map<Integer, ? extends LivenessAction> map2 = this.index2Action;
            if (map2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"index2Action");
                map2 = null;
            }
            if ((map2 = map2.get(this.currActionIdx)) != null) {
                this.actionList.add((LivenessAction)((Object)map2));
            }
        }
    }

    public static /* synthetic */ void addAction$default(LivenessSession livenessSession, int n3, LivenessAction livenessAction, int n4, Object object) {
        if ((n4 & 2) != 0) {
            livenessAction = null;
        }
        livenessSession.addAction(n3, livenessAction);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void handleAction(Bitmap bitmap) {
        Success success2;
        block14: {
            Object object;
            block12: {
                block13: {
                    LivenessAction livenessAction;
                    block11: {
                        int n3;
                        LivenessAction livenessAction2;
                        if (((LivenessSession)((Object)success3)).currActionIdx == 0) {
                            LivenessSession.addAction$default((LivenessSession)((Object)success3), 1, null, 2, null);
                        }
                        LivenessSession livenessSession = success3;
                        livenessAction = livenessSession.currAction;
                        int n4 = livenessSession.currActionIdx;
                        Map<Integer, ? extends LivenessAction> map = livenessSession.index2Action;
                        if (map == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"index2Action");
                            map = null;
                        }
                        int n5 = (map = (Integer)CollectionsKt.maxOrNull(map.keySet())) != null ? (Integer)((Object)map) : 0;
                        if (n4 > n5) return;
                        List<LivenessAction> list = ((LivenessSession)((Object)success3)).actionList;
                        Intrinsics.checkNotNullExpressionValue(list, (String)"actionList");
                        Object object2 = (LivenessAction)CollectionsKt.last(list);
                        ((LivenessSession)((Object)success3)).currAction = object2;
                        Intrinsics.checkNotNull((Object)object2);
                        object2 = ((LivenessAction)object2).process((LivenessSession)((Object)success3));
                        if (object2 == LivenessActionStatus.SUCCESS && (Intrinsics.areEqual((Object)((livenessAction2 = ((LivenessSession)((Object)success3)).currAction) != null ? livenessAction2.getTAG() : null), (Object)"HoldSteady2Seconds") || Intrinsics.areEqual((Object)((livenessAction2 = ((LivenessSession)((Object)success3)).currAction) != null ? livenessAction2.getTAG() : null), (Object)"ComeClose"))) {
                            if (!((LivenessSession)((Object)success3)).gotTypicalFace) {
                                Helpers.Companion.printLog(((LivenessSession)((Object)success3)).TAG + " Found typical frame!");
                                ((LivenessSession)((Object)success3)).setTypicalFace(bitmap);
                            }
                            ((LivenessSession)((Object)success3)).gotTypicalFace = true;
                        }
                        if ((n3 = WhenMappings.$EnumSwitchMapping$1[((Enum)object2).ordinal()]) != 1) {
                            if (n3 == 2) {
                                ((LivenessSession)((Object)success3)).genActionList();
                                return;
                            }
                            if (n3 != 3) {
                                return;
                            }
                            ((LivenessSession)((Object)success3)).sessionStatus = LivenessSessionStatus.PROCESSING;
                            return;
                        }
                        if (((LivenessSession)((Object)success3)).livenessSessionType != Common.LIVENESS_VERSION.PASSIVE) break block11;
                        object = ((LivenessSession)((Object)success3)).faceDetectorListener;
                        if (object != null) break block12;
                        break block13;
                    }
                    object = ((LivenessSession)((Object)success3)).currAction;
                    if (!Intrinsics.areEqual((Object)(object != null ? ((LivenessAction)object).getTAG() : null), (Object)new Success().getTAG()) || Intrinsics.areEqual((Object)(livenessAction != null ? livenessAction.getTAG() : null), (Object)"HoldSteady2Seconds")) break block14;
                    object = ((LivenessSession)((Object)success3)).faceDetectorListener;
                    if (object != null) break block12;
                }
                Intrinsics.throwUninitializedPropertyAccessException((String)"faceDetectorListener");
                object = null;
            }
            object.onNextStep();
        }
        LivenessAction livenessAction = ((LivenessSession)((Object)success3)).currAction;
        Intrinsics.checkNotNull((Object)livenessAction);
        if (livenessAction.isBreakAction()) {
            LivenessSession.addAction$default((LivenessSession)((Object)success3), 1, null, 2, null);
            return;
        }
        LivenessSession livenessSession = success3;
        Success success3 = success2;
        success2 = new Success();
        livenessSession.addAction(0, success3);
    }

    private final InputImage optimizeImageForDetection(Bitmap bitmap, int n3) {
        InputImage inputImage;
        int n4 = 1024;
        float f3 = bitmap.getWidth() <= n4 && bitmap.getHeight() <= n4 ? 1.0f : (float)n4 / (float)Math.max(bitmap.getWidth(), bitmap.getHeight());
        if (f3 < 1.0f) {
            Bitmap bitmap2 = bitmap;
            Bitmap bitmap3 = Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)((int)((float)bitmap2.getWidth() * f3)), (int)((int)((float)bitmap.getHeight() * f3)), (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"createScaledBitmap(image\u2026idth, scaledHeight, true)");
            inputImage = InputImage.fromBitmap((Bitmap)bitmap3, (int)n3);
            Intrinsics.checkNotNullExpressionValue((Object)inputImage, (String)"{\n            val scaled\u2026 rotationAngle)\n        }");
        } else {
            inputImage = InputImage.fromBitmap((Bitmap)bitmap, (int)n3);
            Intrinsics.checkNotNullExpressionValue((Object)inputImage, (String)"{\n            InputImage\u2026 rotationAngle)\n        }");
        }
        return inputImage;
    }

    public LivenessSession() {
        this(null, 1, null);
    }

    public static final /* synthetic */ LruCache access$getRecentDetections$p(LivenessSession livenessSession) {
        return livenessSession.recentDetections;
    }

    public static final /* synthetic */ InputImage access$optimizeImageForDetection(LivenessSession livenessSession, Bitmap bitmap, int n3) {
        return livenessSession.optimizeImageForDetection(bitmap, n3);
    }

    public static final /* synthetic */ FaceDetector access$getFaceDetector$p(LivenessSession livenessSession) {
        return livenessSession.faceDetector;
    }

    public static final /* synthetic */ void access$handleDetectionResult(LivenessSession livenessSession, List list, Bitmap bitmap, KLPFaceDetectorListener kLPFaceDetectorListener) {
        livenessSession.handleDetectionResult(list, bitmap, kLPFaceDetectorListener);
    }

    public static final /* synthetic */ String access$getTAG$p(LivenessSession livenessSession) {
        return livenessSession.TAG;
    }

    public static final /* synthetic */ LivenessAction access$getCurrAction$p(LivenessSession livenessSession) {
        return livenessSession.currAction;
    }

    @NotNull
    public final LivenessSessionStatus getSessionStatus() {
        return this.sessionStatus;
    }

    public final void setSessionStatus(@NotNull LivenessSessionStatus livenessSessionStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)livenessSessionStatus), (String)"<set-?>");
        this.sessionStatus = livenessSessionStatus;
    }

    @NotNull
    public final ConcurrentLinkedQueue<InputFace> getFaceList() {
        return this.faceList;
    }

    @NotNull
    public final List<InputFace> getFaceList() {
        return CollectionsKt.toList(this.faceList);
    }

    @NotNull
    public final Bitmap getTypicalFace() {
        LivenessSession livenessSession = livenessSession.typicalFace;
        if (livenessSession != null) {
            return livenessSession;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"typicalFace");
        return null;
    }

    public final void setTypicalFace(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"<set-?>");
        this.typicalFace = bitmap;
    }

    public final boolean getGotTypicalFace() {
        return this.gotTypicalFace;
    }

    public final void setGotTypicalFace(boolean bl) {
        this.gotTypicalFace = bl;
    }

    public final void renewSession(@NotNull Common.LIVENESS_VERSION lIVENESS_VERSION) {
        LivenessSession livenessSession = this;
        Common.LIVENESS_VERSION lIVENESS_VERSION2 = lIVENESS_VERSION;
        Intrinsics.checkNotNullParameter((Object)((Object)lIVENESS_VERSION2), (String)"livenessSessionType");
        livenessSession.livenessSessionType = lIVENESS_VERSION2;
        livenessSession.sessionStatus = LivenessSessionStatus.UNVERIFIED;
        livenessSession.gotTypicalFace = false;
        livenessSession.refreshFaceList();
        livenessSession.genActionList();
    }

    public final void process(@NotNull Bitmap bitmap, int n3, @NotNull KLPFaceDetectorListener kLPFaceDetectorListener) {
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
        KLPFaceDetectorListener kLPFaceDetectorListener2 = kLPFaceDetectorListener;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)kLPFaceDetectorListener2, (String)"listener");
        this.faceDetectorListener = kLPFaceDetectorListener2;
        if (this.isFinished()) {
            return;
        }
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
        function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, bitmap, kLPFaceDetectorListener, n3, null){
            public long J$0;
            public int label;
            public final /* synthetic */ LivenessSession this$0;
            public final /* synthetic */ Bitmap $frame;
            public final /* synthetic */ KLPFaceDetectorListener $listener;
            public final /* synthetic */ int $rotationAngle;
            {
                this.this$0 = livenessSession;
                this.$frame = bitmap;
                this.$listener = kLPFaceDetectorListener;
                this.$rotationAngle = n3;
                super(2, continuation);
            }

            private static final void invokeSuspend$lambda$1(Function1 function1, Object object) {
                function1.invoke(object);
            }

            private static final void invokeSuspend$lambda$2(LivenessSession object, KLPFaceDetectorListener kLPFaceDetectorListener, Exception object2) {
                LivenessSession livenessSession = object;
                Helpers.Companion.printLog(LivenessSession.access$getTAG$p(object) + " Detection failed: " + ((Throwable)object2).getMessage());
                livenessSession.setSessionStatus(LivenessSessionStatus.FAILED);
                object = livenessSession.getSessionStatus();
                object2 = LivenessSession.access$getCurrAction$p(livenessSession);
                object2 = object2 != null ? ((LivenessAction)object2).getTAG() : null;
                kLPFaceDetectorListener.onMessage((LivenessSessionStatus)((Object)object), (String)object2);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block22: {
                    var2_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    var3_7 = this.label;
                    if (var3_7 != 0) {
                        if (var3_7 == 1) {
                            var2_5 = this.J$0;
                            ResultKt.throwOnFailure((Object)var1_1);
                            break block22;
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    ResultKt.throwOnFailure((Object)var1_1);
                    var3_8 = System.currentTimeMillis();
                    var1_1 = (Face)LivenessSession.access$getRecentDetections$p(this.this$0).get((Object)Boxing.boxLong((long)var3_8));
                    if (var1_1 == null) ** GOTO lbl26
                    v0 = this.this$0;
                    v1 = var1_1;
                    v2 = this;
                    v3 = v2;
                    var1_1 = v2.$frame;
                    var5_9 = v3.$listener;
                    LivenessSession.access$handleDetectionResult(v0, CollectionsKt.listOf((Object)v1), (Bitmap)var1_1, (KLPFaceDetectorListener)var5_9);
lbl26:
                    // 2 sources

                    v4 = Dispatchers.getDefault();
                    v5 = this;
                    v6 = v5;
                    v7 = v5;
                    v8 = var3_8;
                    var1_1 = v9;
                    v10 = this;
                    v11 = v10;
                    v12 = v10;
                    var5_9 = v10.this$0;
                    var6_12 = v12.$frame;
                    var7_14 = v11.$rotationAngle;
                    v9 = new Function2<CoroutineScope, Continuation<? super InputImage>, Object>((LivenessSession)var5_9, var6_12, var7_14, null){
                        public int label;
                        public final /* synthetic */ LivenessSession this$0;
                        public final /* synthetic */ Bitmap $frame;
                        public final /* synthetic */ int $rotationAngle;
                        {
                            this.this$0 = livenessSession;
                            this.$frame = bitmap;
                            this.$rotationAngle = n3;
                            super(2, continuation);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            if (this_.label == 0) {
                                ResultKt.throwOnFailure((Object)object);
                                process.optimizedImage.1 v02 = this_;
                                process.optimizedImage.1 this_ = v02.$frame;
                                return LivenessSession.access$optimizeImageForDetection(this_.this$0, (Bitmap)this_, v02.$rotationAngle);
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                            var v02 = object2;
                            Object object2 = v02.this$0;
                            object = v02.$frame;
                            int n3 = v02.$rotationAngle;
                            return new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super InputImage> continuation) {
                            return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
                        }
                    };
                    v6.J$0 = v8;
                    v7.label = 1;
                    var1_1 = BuildersKt.withContext((CoroutineContext)v4, (Function2)var1_1, (Continuation)this);
                    if (var1_1 == var2_4) {
                        return var2_4;
                    }
                    var2_5 = var3_8;
                }
                v13 = this;
                var1_1 = (InputImage)var1_1;
                v14 = Helpers.Companion;
                v15 = new Object[1];
                v16 = this.$frame.getWidth();
                v17 = var1_1;
                v18 = v17;
                v19 = v17;
                var4_15 = this.$frame.getHeight();
                var5_10 = v18.getWidth();
                var6_13 = v19.getHeight();
                v15[0] = "original - " + v16 + " " + var4_15 + " optimizedImage - " + var5_10 + " " + var6_13;
                v14.printLog(v15);
                v20 = LivenessSession.access$getFaceDetector$p(v13.this$0).process((InputImage)var1_1);
                v21 = v22;
                v23 = v22;
                v24 = this;
                v25 = v24;
                var4_16 = v24.this$0;
                var5_11 = v25.$listener;
                try {
                    v21(var4_16, (InputImage)var1_1, var5_11, var2_5);
                    v20.addOnSuccessListener((OnSuccessListener)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, invokeSuspend$lambda$1(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)V)((Function1)v23)).addOnFailureListener((OnFailureListener)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Exception;)V, invokeSuspend$lambda$2(vn.kalapa.ekyc.liveness.LivenessSession vn.kalapa.ekyc.managers.KLPFaceDetectorListener java.lang.Exception ), (Ljava/lang/Exception;)V)((LivenessSession)this.this$0, (KLPFaceDetectorListener)this.$listener));
                }
                catch (Exception var1_2) {
                    v26 = this;
                    Helpers.Companion.printLog(new Object[]{LivenessSession.access$getTAG$p(this.this$0) + " Processing error: " + var1_2.getMessage()});
                    v26.this$0.setSessionStatus(LivenessSessionStatus.FAILED);
                    this = v26.$listener;
                    var1_3 = v26.this$0.getSessionStatus();
                    var2_6 = LivenessSession.access$getCurrAction$p(v26.this$0);
                    var2_6 = var2_6 != null ? var2_6.getTAG() : null;
                    this.onMessage(var1_3, (String)var2_6);
                }
                return Unit.INSTANCE;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                var v02 = object2;
                Object object2 = v02.this$0;
                object = v02.$frame;
                KLPFaceDetectorListener kLPFaceDetectorListener = v02.$listener;
                int n3 = v02.$rotationAngle;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        BuildersKt.launch$default((CoroutineScope)this.processingScope, null, null, (Function2)function22, (int)3, null);
    }

    @NotNull
    public final String getCurrentAction() {
        String string2;
        int n3 = this.currActionIdx;
        if (n3 > 0 && n3 < this.actionList.size()) {
            List<LivenessAction> list = this.actionList;
            Intrinsics.checkNotNullExpressionValue(list, (String)"actionList");
            string2 = ((LivenessAction)CollectionsKt.last(list)).getTAG();
        } else {
            string2 = "";
        }
        return string2;
    }

    public final boolean isFinished() {
        Object object = object.sessionStatus;
        return object == LivenessSessionStatus.FAILED || object == LivenessSessionStatus.VERIFIED;
    }

    public final void cleanup() {
        LivenessSession livenessSession = this;
        CoroutineScopeKt.cancel$default((CoroutineScope)livenessSession.processingScope, null, (int)1, null);
        livenessSession.faceDetector.close();
        livenessSession.refreshFaceList();
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Common.LIVENESS_VERSION.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[Common.LIVENESS_VERSION.PASSIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Common.LIVENESS_VERSION.ACTIVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Common.LIVENESS_VERSION.SEMI_ACTIVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
            int[] nArray3 = new int[LivenessActionStatus.values().length];
            nArray2 = nArray3;
            try {
                nArray3[LivenessActionStatus.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[LivenessActionStatus.TIMEOUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[LivenessActionStatus.FAILED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$1 = nArray2;
        }
    }
}

