/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.liveness.models;

import android.graphics.Rect;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import vn.kalapa.ekyc.liveness.InputFace;
import vn.kalapa.ekyc.liveness.LivenessSession;
import vn.kalapa.ekyc.liveness.models.LivenessAction;
import vn.kalapa.ekyc.liveness.models.LivenessActionStatus;
import vn.kalapa.ekyc.utils.Helpers;

public final class GoFar
extends LivenessAction {
    public GoFar() {
        GoFar goFar = this;
        goFar.setTAG("GoFar");
        goFar.setNMillis(1000);
    }

    private final double calculateNormalizedFaceSize(InputFace inputFace) {
        InputFace inputFace2 = inputFace;
        Rect rect = inputFace2.getFace().getBoundingBox();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"inputFace.face.boundingBox");
        int n3 = rect.width();
        n3 = rect.height() * n3;
        int n4 = inputFace2.getFrameWidth();
        int n5 = n3;
        n3 = inputFace.getFrameHeight() * n4;
        return (double)n5 / (double)n3;
    }

    @Override
    @NotNull
    public LivenessActionStatus individualProcess(@NotNull LivenessSession livenessSession, @NotNull List<InputFace> list) {
        List<InputFace> list2 = list;
        Intrinsics.checkNotNullParameter((Object)livenessSession, (String)"session");
        Intrinsics.checkNotNullParameter(list2, (String)"faces");
        if (this.isFacesReadyToProcess(list2)) {
            GoFar goFar = this;
            boolean bl = goFar.checkStability((Collection<Double>)goFar.getRecentFaceSizes());
            boolean bl2 = LivenessAction.checkProximity(CollectionsKt.averageOfDouble(this.getRecentFaceSizes()), LivenessAction.getFACE_AREA_TOO_SMALL_THRESHOLD(), LivenessAction.getFACE_AREA_SMALL_ENOUGH_THRESHOLD());
            if (bl && bl2) {
                GoFar goFar2 = this;
                goFar2.setStableFrameCount(goFar2.getStableFrameCount() + 1);
                if (goFar2.getStableFrameCount() >= this.getREQUIRED_STABLE_FRAME_COUNT()) {
                    return LivenessActionStatus.SUCCESS;
                }
            } else {
                Object[] objectArray = new Object[1];
                double d3 = CollectionsKt.averageOfDouble(this.getRecentFaceSizes());
                double d4 = LivenessAction.getFACE_AREA_TOO_SMALL_THRESHOLD();
                double d5 = LivenessAction.getFACE_AREA_SMALL_ENOUGH_THRESHOLD();
                objectArray[0] = this.getTAG() + " individualProcess: isStable: " + bl + "  isFarEnough: " + bl2 + " - " + d3 + " - " + d4 + " - " + d5;
                Helpers.Companion.printLog(objectArray);
                this.setStableFrameCount(0);
            }
        }
        return LivenessActionStatus.FAILED;
    }
}

