/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.liveness.models;

import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.Rect;
import com.google.mlkit.vision.face.Face;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vn.kalapa.ekyc.liveness.InputFace;
import vn.kalapa.ekyc.liveness.LivenessSession;
import vn.kalapa.ekyc.liveness.models.LivenessActionStatus;
import vn.kalapa.ekyc.liveness.models.LivenessFacePosition;
import vn.kalapa.ekyc.utils.Helpers;

@SourceDebugExtension(value={"SMAP\nLivenessAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LivenessAction.kt\nvn/kalapa/ekyc/liveness/models/LivenessAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,570:1\n1549#2:571\n1620#2,3:572\n*S KotlinDebug\n*F\n+ 1 LivenessAction.kt\nvn/kalapa/ekyc/liveness/models/LivenessAction\n*L\n87#1:571\n87#1:572,3\n*E\n"})
public abstract class LivenessAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static double FACE_AREA_TOO_SMALL_THRESHOLD = 0.03;
    private static double FACE_AREA_SMALL_THRESHOLD = 0.16;
    private static double FACE_AREA_SMALL_ENOUGH_THRESHOLD = 0.2025;
    private static double FACE_AREA_BIG_ENOUGH_THRESHOLD = 0.36;
    private static double FACE_AREA_BIG_THRESHOLD = 0.4225;
    private static double FACE_AREA_TOO_BIG_THRESHOLD = 0.64;
    public String TAG;
    private final int MAX_NO_FACE_FRAME;
    private long startTime = System.currentTimeMillis();
    public Bitmap frame;
    public Bitmap cropFrame;
    private boolean isBreakAction;
    private int nMillis = 1500;
    @NotNull
    private LivenessActionStatus currentActionStatus = LivenessActionStatus.FAILED;
    private int timeout = 30;
    private final int REQUIRED_STABLE_FRAME_COUNT;
    private final double STABILITY_THRESHOLD;
    @NotNull
    private final ArrayDeque<Double> recentFaceSizes = new ArrayDeque(2);
    @Nullable
    private PointF lastCenterPoint;
    private final double MAX_MOVEMENT_BETWEEN_FRAMES;
    private int stableFrameCount;

    public LivenessAction() {
        this.MAX_NO_FACE_FRAME = 10;
        this.REQUIRED_STABLE_FRAME_COUNT = 2;
        this.STABILITY_THRESHOLD = 0.001;
        this.MAX_MOVEMENT_BETWEEN_FRAMES = 0.01;
    }

    private final boolean checkSmoothMovement(PointF pointF) {
        double d3;
        PointF pointF2 = this.lastCenterPoint;
        if (pointF2 == null) {
            return true;
        }
        double d4 = 2;
        return (double)((float)Math.sqrt((float)Math.pow(pointF.x - pointF2.x, d3) + (float)Math.pow(pointF.y - pointF2.y, d4))) <= this.MAX_MOVEMENT_BETWEEN_FRAMES;
    }

    private final void resetState() {
        this.stableFrameCount = 0;
        this.recentFaceSizes.clear();
        this.lastCenterPoint = null;
    }

    private final boolean isNotEnoughFrame() {
        return this.nMillis != 0 && System.currentTimeMillis() - this.startTime < (long)this.nMillis;
    }

    private final List<InputFace> getFacesByTime(LivenessSession livenessSession, int n3) {
        List<InputFace> list;
        if (n3 == 0) {
            list = CollectionsKt.listOf((Object)livenessSession.getFaceList().get(livenessSession.getFaceList().size() - 1));
        } else if (livenessSession.getFaceList().get(livenessSession.getFaceList().size() - 1).getInputTime() - livenessSession.getFaceList().get(0).getInputTime() > (long)n3) {
            LivenessSession livenessSession2 = livenessSession;
            CollectionsKt.removeAll(livenessSession2.getFaceList(), (Function1)new Function1<InputFace, Boolean>(livenessSession, n3){
                public final /* synthetic */ LivenessSession $session;
                public final /* synthetic */ int $millis;
                {
                    this.$session = livenessSession;
                    this.$millis = n3;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(InputFace inputFace) {
                    return this.$session.getFaceList().get(this.$session.getFaceList().size() - 1).getInputTime() - inputFace.getInputTime() >= (long)this.$millis;
                }
            });
            list = livenessSession2.getFaceList();
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public static final double getFACE_AREA_TOO_SMALL_THRESHOLD() {
        return Companion.getFACE_AREA_TOO_SMALL_THRESHOLD();
    }

    public static final void setFACE_AREA_TOO_SMALL_THRESHOLD(double d3) {
        Companion.setFACE_AREA_TOO_SMALL_THRESHOLD(d3);
    }

    public static final double getFACE_AREA_SMALL_THRESHOLD() {
        return Companion.getFACE_AREA_SMALL_THRESHOLD();
    }

    public static final void setFACE_AREA_SMALL_THRESHOLD(double d3) {
        Companion.setFACE_AREA_SMALL_THRESHOLD(d3);
    }

    public static final double getFACE_AREA_SMALL_ENOUGH_THRESHOLD() {
        return Companion.getFACE_AREA_SMALL_ENOUGH_THRESHOLD();
    }

    public static final void setFACE_AREA_SMALL_ENOUGH_THRESHOLD(double d3) {
        Companion.setFACE_AREA_SMALL_ENOUGH_THRESHOLD(d3);
    }

    public static final double getFACE_AREA_BIG_ENOUGH_THRESHOLD() {
        return Companion.getFACE_AREA_BIG_ENOUGH_THRESHOLD();
    }

    public static final void setFACE_AREA_BIG_ENOUGH_THRESHOLD(double d3) {
        Companion.setFACE_AREA_BIG_ENOUGH_THRESHOLD(d3);
    }

    public static final double getFACE_AREA_BIG_THRESHOLD() {
        return Companion.getFACE_AREA_BIG_THRESHOLD();
    }

    public static final void setFACE_AREA_BIG_THRESHOLD(double d3) {
        Companion.setFACE_AREA_BIG_THRESHOLD(d3);
    }

    public static final double getFACE_AREA_TOO_BIG_THRESHOLD() {
        return Companion.getFACE_AREA_TOO_BIG_THRESHOLD();
    }

    public static final void setFACE_AREA_TOO_BIG_THRESHOLD(double d3) {
        Companion.setFACE_AREA_TOO_BIG_THRESHOLD(d3);
    }

    @JvmStatic
    public static final boolean checkProximity(double d3, double d4, double d5) {
        return Companion.checkProximity(d3, d4, d5);
    }

    @NotNull
    public final String getTAG() {
        String string2 = ((LivenessAction)((Object)string2)).TAG;
        if (string2 != null) {
            return string2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"TAG");
        return null;
    }

    public final void setTAG(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.TAG = string2;
    }

    public final int getMAX_NO_FACE_FRAME() {
        return this.MAX_NO_FACE_FRAME;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final void setStartTime(long l3) {
        this.startTime = l3;
    }

    @NotNull
    public final Bitmap getFrame() {
        LivenessAction livenessAction = livenessAction.frame;
        if (livenessAction != null) {
            return livenessAction;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"frame");
        return null;
    }

    public final void setFrame(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"<set-?>");
        this.frame = bitmap;
    }

    @NotNull
    public final Bitmap getCropFrame() {
        LivenessAction livenessAction = livenessAction.cropFrame;
        if (livenessAction != null) {
            return livenessAction;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"cropFrame");
        return null;
    }

    public final void setCropFrame(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"<set-?>");
        this.cropFrame = bitmap;
    }

    public final boolean isBreakAction() {
        return this.isBreakAction;
    }

    public final void setBreakAction(boolean bl) {
        this.isBreakAction = bl;
    }

    public final int getNMillis() {
        return this.nMillis;
    }

    public final void setNMillis(int n3) {
        this.nMillis = n3;
    }

    @NotNull
    public final LivenessActionStatus getCurrentActionStatus() {
        return this.currentActionStatus;
    }

    public final void setCurrentActionStatus(@NotNull LivenessActionStatus livenessActionStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)livenessActionStatus), (String)"<set-?>");
        this.currentActionStatus = livenessActionStatus;
    }

    public final int getTimeout() {
        return this.timeout;
    }

    public final void setTimeout(int n3) {
        this.timeout = n3;
    }

    public final int getREQUIRED_STABLE_FRAME_COUNT() {
        return this.REQUIRED_STABLE_FRAME_COUNT;
    }

    public final double getSTABILITY_THRESHOLD() {
        return this.STABILITY_THRESHOLD;
    }

    @NotNull
    public final ArrayDeque<Double> getRecentFaceSizes() {
        return this.recentFaceSizes;
    }

    public final int getStableFrameCount() {
        return this.stableFrameCount;
    }

    public final void setStableFrameCount(int n3) {
        this.stableFrameCount = n3;
    }

    public final boolean isFacesReadyToProcess(@NotNull List<InputFace> object) {
        List<InputFace> list = object;
        Intrinsics.checkNotNullParameter(list, (String)"faces");
        if (list.isEmpty()) {
            Helpers.Companion.printLog("isFacesReadyToProcess: No faces detected");
            this.resetState();
            return false;
        }
        if (!this.checkSmoothMovement(((FaceMetrics)(object = Companion.calculateFaceMetrics((InputFace)CollectionsKt.last(object)))).getCenterPoint())) {
            Helpers.Companion.printLog("isFacesReadyToProcess: Sudden movement detected");
            this.resetState();
            return false;
        }
        LivenessAction livenessAction = this;
        livenessAction.lastCenterPoint = ((FaceMetrics)object).getCenterPoint();
        livenessAction.recentFaceSizes.add((Object)((FaceMetrics)object).getNormalizedSize());
        if (livenessAction.recentFaceSizes.size() > this.REQUIRED_STABLE_FRAME_COUNT) {
            this.recentFaceSizes.removeFirst();
            return true;
        }
        return false;
    }

    public final boolean checkStability(@NotNull Collection<Double> object) {
        ArrayList<Double> arrayList;
        Collection<Double> collection = object;
        Intrinsics.checkNotNullParameter(collection, (String)"sizes");
        double d3 = CollectionsKt.averageOfDouble(collection);
        ArrayList<Double> arrayList2 = arrayList;
        arrayList = new ArrayList<Double>(CollectionsKt.collectionSizeOrDefault(object, (int)10));
        object = collection.iterator();
        while (object.hasNext()) {
            double d4 = ((Number)object.next()).doubleValue() - d3;
            arrayList2.add(d4 * d4);
        }
        return CollectionsKt.averageOfDouble(arrayList2) < this.STABILITY_THRESHOLD;
    }

    @NotNull
    public final LivenessFacePosition getFacePosition(@NotNull Face face, @NotNull Face face2) {
        block10: {
            LivenessFacePosition livenessFacePosition;
            block4: {
                float f3;
                float f4;
                block9: {
                    block8: {
                        float f5;
                        float f6;
                        block7: {
                            block6: {
                                float f7;
                                float f8;
                                block5: {
                                    block3: {
                                        Face face3 = face;
                                        Intrinsics.checkNotNullParameter((Object)face, (String)"face1");
                                        Intrinsics.checkNotNullParameter((Object)face2, (String)"face2");
                                        f8 = face3.getHeadEulerAngleY();
                                        f4 = face3.getHeadEulerAngleZ();
                                        f6 = face.getHeadEulerAngleX();
                                        boolean bl = f4 < -15.0f || f4 > 15.0f || f6 < -15.0f || f6 > 15.0f || f8 < -15.0f || f8 > 15.0f;
                                        Face face4 = face2;
                                        f7 = face4.getHeadEulerAngleY();
                                        f3 = face4.getHeadEulerAngleZ();
                                        f5 = face2.getHeadEulerAngleX();
                                        boolean bl2 = f3 < -15.0f || f3 > 15.0f || f5 < -15.0f || f5 > 15.0f || f7 < -15.0f || f7 > 15.0f;
                                        if (bl || bl2) break block3;
                                        livenessFacePosition = LivenessFacePosition.STRAIGHT;
                                        break block4;
                                    }
                                    if (!(Math.min(f8, f7) > 15.0f)) break block5;
                                    livenessFacePosition = LivenessFacePosition.LEFT;
                                    break block4;
                                }
                                if (!(Math.max(f8, f7) < -15.0f)) break block6;
                                livenessFacePosition = LivenessFacePosition.RIGHT;
                                break block4;
                            }
                            if (!(Math.min(f6, f5) > 15.0f)) break block7;
                            livenessFacePosition = LivenessFacePosition.UP;
                            break block4;
                        }
                        if (!(Math.max(f6, f5) < -15.0f)) break block8;
                        livenessFacePosition = LivenessFacePosition.DOWN;
                        break block4;
                    }
                    if (!(Math.min(f4, f3) > 25.0f)) break block9;
                    livenessFacePosition = LivenessFacePosition.TILT_RIGHT;
                    break block4;
                }
                if (!(Math.max(f4, f3) < -25.0f)) break block10;
                livenessFacePosition = LivenessFacePosition.TILT_LEFT;
            }
            return livenessFacePosition;
        }
        return LivenessFacePosition.NOT_DETERMINE;
    }

    @NotNull
    public final LivenessFacePosition getFacePosition(@NotNull Face face) {
        Face face2 = face;
        Intrinsics.checkNotNullParameter((Object)face2, (String)"face1");
        float f3 = face2.getHeadEulerAngleY();
        float f4 = face2.getHeadEulerAngleZ();
        float f5 = face.getHeadEulerAngleX();
        float f6 = f4 - -15.0f;
        float f7 = f6 == 0.0f ? 0 : (f6 < 0.0f ? -1 : 1);
        return !(f7 < 0 || f4 > 15.0f || f5 < -15.0f || f5 > 15.0f || f3 < -15.0f || f3 > 15.0f) ? LivenessFacePosition.STRAIGHT : (f3 > 25.0f ? LivenessFacePosition.LEFT : (f3 < -25.0f ? LivenessFacePosition.RIGHT : (f5 > 15.0f ? LivenessFacePosition.UP : (f5 < -10.0f ? LivenessFacePosition.DOWN : (f4 > 15.0f ? LivenessFacePosition.TILT_RIGHT : (f7 < 0 ? LivenessFacePosition.TILT_LEFT : LivenessFacePosition.NOT_DETERMINE))))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isEyesClosed(@NotNull Face face) {
        Face face2 = face;
        Intrinsics.checkNotNullParameter((Object)face2, (String)"face");
        if (face2.getRightEyeOpenProbability() == null) return true;
        Float f3 = face.getRightEyeOpenProbability();
        Intrinsics.checkNotNull((Object)f3);
        if (f3.floatValue() < 0.1f) return true;
        if (face.getLeftEyeOpenProbability() == null) return true;
        Float f4 = face.getLeftEyeOpenProbability();
        Intrinsics.checkNotNull((Object)f4);
        if (!(f4.floatValue() < 0.1f)) return false;
        return true;
    }

    @NotNull
    public abstract LivenessActionStatus individualProcess(@NotNull LivenessSession var1, @NotNull List<InputFace> var2);

    @NotNull
    public final LivenessActionStatus process(@NotNull LivenessSession livenessSession) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)livenessSession, (String)"session");
        if (object.isBreakAction) {
            return LivenessActionStatus.SUCCESS;
        }
        if (object.isNotEnoughFrame()) {
            object.currentActionStatus = LivenessActionStatus.FAILED;
            return object.currentActionStatus;
        }
        if (System.currentTimeMillis() - object.startTime > (long)(object.timeout * 1000)) {
            object.currentActionStatus = LivenessActionStatus.TIMEOUT;
            return object.currentActionStatus;
        }
        List<InputFace> list = object.getFacesByTime(livenessSession, object.nMillis);
        if (list.size() < 2) {
            if (object.nMillis == 0 && list.size() == 1) {
                object = object.individualProcess(livenessSession, list);
                ((LivenessAction)v0).currentActionStatus = object;
            } else {
                LivenessAction livenessAction = object;
                object = LivenessActionStatus.FAILED;
                livenessAction.currentActionStatus = object;
            }
        } else {
            Object[] objectArray = new Object[1];
            int n3 = object.nMillis;
            objectArray[0] = JvmClassMappingKt.getKotlinClass(object.getClass()).getSimpleName() + " is processing... nSeconds " + n3 + " face.size " + list.size();
            Helpers.Companion.printLog(objectArray);
            object = object.individualProcess(livenessSession, list);
            v3.currentActionStatus = object;
        }
        return object;
    }

    public static final class FaceMetrics {
        private final double normalizedSize;
        @NotNull
        private final PointF centerPoint;

        public FaceMetrics(double d3, @NotNull PointF pointF) {
            Intrinsics.checkNotNullParameter((Object)pointF, (String)"centerPoint");
            this.normalizedSize = d3;
            this.centerPoint = pointF;
        }

        public static /* synthetic */ FaceMetrics copy$default(FaceMetrics faceMetrics, double d3, PointF pointF, int n3, Object object) {
            if ((n3 & 1) != 0) {
                d3 = faceMetrics.normalizedSize;
            }
            if ((n3 & 2) != 0) {
                pointF = faceMetrics.centerPoint;
            }
            return faceMetrics.copy(d3, pointF);
        }

        public final double getNormalizedSize() {
            return this.normalizedSize;
        }

        @NotNull
        public final PointF getCenterPoint() {
            return this.centerPoint;
        }

        public final double component1() {
            return this.normalizedSize;
        }

        @NotNull
        public final PointF component2() {
            return this.centerPoint;
        }

        @NotNull
        public final FaceMetrics copy(double d3, @NotNull PointF pointF) {
            Intrinsics.checkNotNullParameter((Object)pointF, (String)"centerPoint");
            return new FaceMetrics(d3, pointF);
        }

        @NotNull
        public String toString() {
            return "FaceMetrics(normalizedSize=" + this.normalizedSize + ", centerPoint=" + this.centerPoint + ")";
        }

        public int hashCode() {
            FaceMetrics faceMetrics = this;
            int n3 = Double.hashCode(faceMetrics.normalizedSize) * 31;
            return faceMetrics.centerPoint.hashCode() + n3;
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof FaceMetrics)) {
                return false;
            }
            object = (FaceMetrics)object;
            if (Double.compare(this.normalizedSize, ((FaceMetrics)object).normalizedSize) != 0) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.centerPoint, (Object)((FaceMetrics)object).centerPoint);
        }
    }

    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public static /* synthetic */ void getFACE_AREA_TOO_SMALL_THRESHOLD$annotations() {
        }

        @JvmStatic
        public static /* synthetic */ void getFACE_AREA_SMALL_THRESHOLD$annotations() {
        }

        @JvmStatic
        public static /* synthetic */ void getFACE_AREA_SMALL_ENOUGH_THRESHOLD$annotations() {
        }

        @JvmStatic
        public static /* synthetic */ void getFACE_AREA_BIG_ENOUGH_THRESHOLD$annotations() {
        }

        @JvmStatic
        public static /* synthetic */ void getFACE_AREA_BIG_THRESHOLD$annotations() {
        }

        @JvmStatic
        public static /* synthetic */ void getFACE_AREA_TOO_BIG_THRESHOLD$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public final double getFACE_AREA_TOO_SMALL_THRESHOLD() {
            return FACE_AREA_TOO_SMALL_THRESHOLD;
        }

        public final void setFACE_AREA_TOO_SMALL_THRESHOLD(double d3) {
            FACE_AREA_TOO_SMALL_THRESHOLD = d3;
        }

        public final double getFACE_AREA_SMALL_THRESHOLD() {
            return FACE_AREA_SMALL_THRESHOLD;
        }

        public final void setFACE_AREA_SMALL_THRESHOLD(double d3) {
            FACE_AREA_SMALL_THRESHOLD = d3;
        }

        public final double getFACE_AREA_SMALL_ENOUGH_THRESHOLD() {
            return FACE_AREA_SMALL_ENOUGH_THRESHOLD;
        }

        public final void setFACE_AREA_SMALL_ENOUGH_THRESHOLD(double d3) {
            FACE_AREA_SMALL_ENOUGH_THRESHOLD = d3;
        }

        public final double getFACE_AREA_BIG_ENOUGH_THRESHOLD() {
            return FACE_AREA_BIG_ENOUGH_THRESHOLD;
        }

        public final void setFACE_AREA_BIG_ENOUGH_THRESHOLD(double d3) {
            FACE_AREA_BIG_ENOUGH_THRESHOLD = d3;
        }

        public final double getFACE_AREA_BIG_THRESHOLD() {
            return FACE_AREA_BIG_THRESHOLD;
        }

        public final void setFACE_AREA_BIG_THRESHOLD(double d3) {
            FACE_AREA_BIG_THRESHOLD = d3;
        }

        public final double getFACE_AREA_TOO_BIG_THRESHOLD() {
            return FACE_AREA_TOO_BIG_THRESHOLD;
        }

        public final void setFACE_AREA_TOO_BIG_THRESHOLD(double d3) {
            FACE_AREA_TOO_BIG_THRESHOLD = d3;
        }

        @JvmStatic
        public final boolean checkProximity(double d3, double d4, double d5) {
            return d3 > d4 && d3 < d5;
        }

        @NotNull
        public final FaceMetrics calculateFaceMetrics(@NotNull InputFace inputFace) {
            PointF pointF;
            InputFace inputFace2 = inputFace;
            Intrinsics.checkNotNullParameter((Object)inputFace2, (String)"face");
            Companion companion = inputFace2.getFace().getBoundingBox();
            Intrinsics.checkNotNullExpressionValue((Object)companion, (String)"face.face.boundingBox");
            int n3 = companion.width();
            n3 = companion.height() * n3;
            int n4 = inputFace2.getFrameWidth();
            int n5 = n3;
            n3 = inputFace.getFrameHeight() * n4;
            double d3 = (double)n5 / (double)n3;
            PointF pointF2 = pointF;
            pointF = new PointF((float)companion.centerX() / (float)inputFace.getFrameWidth(), (float)companion.centerY() / (float)inputFace.getFrameHeight());
            return new FaceMetrics(d3, pointF2);
        }

        public final boolean isFaceTooSmall(@NotNull InputFace inputFace) {
            InputFace inputFace2 = inputFace;
            Intrinsics.checkNotNullParameter((Object)inputFace2, (String)"face");
            return this.calculateFaceMetrics(inputFace2).getNormalizedSize() < LivenessAction.getFACE_AREA_TOO_SMALL_THRESHOLD();
        }

        public final boolean isFaceTooBig(@NotNull InputFace inputFace) {
            InputFace inputFace2 = inputFace;
            Intrinsics.checkNotNullParameter((Object)inputFace2, (String)"face");
            return this.calculateFaceMetrics(inputFace2).getNormalizedSize() > LivenessAction.getFACE_AREA_TOO_BIG_THRESHOLD();
        }

        public final boolean isFaceSizeInRange(@NotNull InputFace inputFace) {
            FaceMetrics faceMetrics;
            InputFace inputFace2 = inputFace;
            Intrinsics.checkNotNullParameter((Object)inputFace2, (String)"face");
            FaceMetrics faceMetrics2 = ((Companion)((Object)faceMetrics2)).calculateFaceMetrics(inputFace2);
            return faceMetrics.getNormalizedSize() > LivenessAction.getFACE_AREA_SMALL_ENOUGH_THRESHOLD() && faceMetrics2.getNormalizedSize() < LivenessAction.getFACE_AREA_BIG_ENOUGH_THRESHOLD();
        }

        public final boolean isFaceLookStraight(@NotNull Face face) {
            Face face2 = face;
            Intrinsics.checkNotNullParameter((Object)face2, (String)"face");
            float f3 = face2.getHeadEulerAngleY();
            float f4 = face2.getHeadEulerAngleZ();
            float f5 = face.getHeadEulerAngleX();
            boolean bl = f4 < -15.0f || f4 > 15.0f || f5 < -15.0f || f5 > 15.0f || f3 < -15.0f || f3 > 15.0f;
            return bl ^ true;
        }

        public final boolean isFaceMarginRight(@NotNull Face face, int n3, int n4) {
            int n5;
            Face face2 = face;
            Intrinsics.checkNotNullParameter((Object)face2, (String)"face");
            Companion companion = face2.getBoundingBox();
            Intrinsics.checkNotNullExpressionValue((Object)companion, (String)"face.boundingBox");
            int n6 = ((Rect)companion).top;
            float f3 = n4;
            n6 = !((float)n6 <= f3 * 0.05f) && n6 > 50 && !((float)(n6 = ((Rect)companion).bottom) >= f3 * 0.95f) && n6 < n4 - 25 ? 0 : 1;
            n4 = ((Rect)companion).left;
            f3 = n3;
            n5 = !((float)n4 <= f3 * 0.05f) && n4 > 25 && !((float)(n5 = ((Rect)companion).right) >= f3 * 0.95f) && n5 < n3 - 25 ? 0 : 1;
            n3 = n5 == 0 && n6 == 0 ? 1 : 0;
            if (n3 == 0) {
                Helpers.Companion.printLog("OptimizedLivenessSession isFaceMarginRight: isTooCloseToVertical: " + (n6 != 0) + "  " + (n5 != 0));
            }
            return n3 != 0;
        }
    }
}

