/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.managers;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vn.kalapa.R;
import vn.kalapa.ekyc.KalapaSDKConfig;
import vn.kalapa.ekyc.handlers.GetDynamicLanguageHandler;
import vn.kalapa.ekyc.managers.KLPCDNManager;
import vn.kalapa.ekyc.models.KalapaCDNObj;
import vn.kalapa.ekyc.models.KalapaLanguageModel;
import vn.kalapa.ekyc.models.LanguageModelContent;
import vn.kalapa.ekyc.models.MyError;
import vn.kalapa.ekyc.utils.Helpers;

@SourceDebugExtension(value={"SMAP\nKLPLanguageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KLPLanguageManager.kt\nvn/kalapa/ekyc/managers/KLPLanguageManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,141:1\n8676#2,2:142\n9358#2,4:144\n13579#2,2:150\n215#3,2:148\n*S KotlinDebug\n*F\n+ 1 KLPLanguageManager.kt\nvn/kalapa/ekyc/managers/KLPLanguageManager\n*L\n33#1:142,2\n33#1:144,4\n96#1:150,2\n38#1:148,2\n*E\n"})
public final class KLPLanguageManager {
    @NotNull
    public static final KLPLanguageManager INSTANCE = new KLPLanguageManager();
    @NotNull
    private static final HashMap<String, HashMap<String, String>> languageMap = new HashMap();
    private static KLPLanguage language;

    private KLPLanguageManager() {
    }

    private final void loadResourcesMap(Context object) {
        LinkedHashMap<Object, Object> linkedHashMap;
        Resources resources = object.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        String string2 = object.getPackageName();
        resources.getIdentifier("string", "values", string2);
        Field[] fieldArray = R.string.class.getFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"fields");
        int n3 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)fieldArray.length), (int)16);
        LinkedHashMap<Object, Object> linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap<Object, Object>(n3);
        for (Field field : fieldArray) {
            int n4 = field.getInt(null);
            Pair pair = TuplesKt.to((Object)field.getName(), (Object)resources.getString(n4));
            Object object2 = pair.getFirst();
            linkedHashMap2.put(object2, pair.getSecond());
        }
        for (Map.Entry entry : linkedHashMap2.entrySet()) {
            String string3 = (String)entry.getKey();
            String string4 = (String)entry.getValue();
            Helpers.Companion.printLog("Resources: " + string3 + ": " + string4);
        }
    }

    private final void setDictionary(KLPLanguage kLPLanguage, Map<String, String> ... mapArray) {
        HashMap<String, String> hashMap = languageMap.get(kLPLanguage.name());
        if (hashMap == null) {
            HashMap hashMap2;
            hashMap = hashMap2;
            hashMap2 = new HashMap();
        }
        for (Map<String, String> map : mapArray) {
            for (String string2 : map.keySet()) {
                String string3 = map.get(string2);
                if (string3 == null) {
                    string3 = string2;
                }
                hashMap.put(string2, string3);
            }
        }
        languageMap.put(kLPLanguage.name(), hashMap);
    }

    @NotNull
    public final String get(@NotNull String object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"key");
        Object object2 = language;
        if (object2 != null) {
            HashMap<String, HashMap<String, String>> hashMap = languageMap;
            if (object2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"language");
                object2 = null;
            }
            if ((object2 = hashMap.get(((Enum)object2).name())) != null && (object2 = (String)((HashMap)object2).get(object)) != null) {
                object = object2;
            }
        }
        return object;
    }

    @Nullable
    public final KalapaCDNObj pullVersion(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"baseURL");
        return null;
    }

    @Nullable
    public final KalapaSDKConfig.KLPLanguageConfig pullOrGetLanguage(@NotNull Activity object, @NotNull String object2, @NotNull String string2, @Nullable String map, @Nullable String string3) {
        Object object3;
        Intrinsics.checkNotNullParameter((Object)object, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"baseURL");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"language");
        Object object4 = KLPCDNManager.INSTANCE;
        map = ((KLPCDNManager)object4).loadLanguageFromCache((Context)object, (String)((Object)map));
        if (map != null && (object3 = ((KalapaLanguageModel)((Object)map)).getError()) != null && (object3 = ((MyError)object3).getCode()) != null && (Integer)object3 == 0 && ((KalapaLanguageModel)((Object)map)).getData() != null) {
            object4 = ((KalapaLanguageModel)((Object)map)).getData().getData();
            if (object4 != null && (object4 = ((LanguageModelContent)object4).getSDK()) != null && object4.isEmpty() ^ true) {
                INSTANCE.setDictionary(KLPLanguage.Companion.fromCountryCode(string2), ((KalapaLanguageModel)((Object)map)).getData().getData().getSDK(), ((KalapaLanguageModel)((Object)map)).getData().getData().getAPP_DEMO());
            }
            Map<String, String> map2 = map;
            object4 = ((KalapaLanguageModel)((Object)map2)).getData().getM77232917();
            object = ((KalapaLanguageModel)((Object)map2)).getData().getP93337();
            Helpers.Companion.printLog("Loaded language from cache successfully");
            return new KalapaSDKConfig.KLPLanguageConfig((Boolean)object4, (Integer)object);
        }
        object2 = (KalapaLanguageModel)new GetDynamicLanguageHandler(new WeakReference<Activity>((Activity)object)).execute(new String[]{object2, string2, string3}).get();
        Helpers.Companion.printLog("newLanguageData " + (KalapaLanguageModel)object2);
        if (object2 != null && (map = ((KalapaLanguageModel)object2).getError()) != null && (map = ((MyError)((Object)map)).getCode()) != null && (Integer)((Object)map) == 0 && ((KalapaLanguageModel)object2).getData() != null && (map = ((KalapaLanguageModel)object2).getData().getData()) != null && (map = ((LanguageModelContent)((Object)map)).getSDK()) != null && map.isEmpty() ^ true && ((KalapaLanguageModel)object2).getData().getData().getAPP_DEMO().isEmpty() ^ true) {
            INSTANCE.setDictionary(KLPLanguage.Companion.fromCountryCode(string2), ((KalapaLanguageModel)object2).getData().getData().getSDK(), ((KalapaLanguageModel)object2).getData().getData().getAPP_DEMO());
            ((KLPCDNManager)object4).saveJsonStringIntoFile((Context)object, (KalapaLanguageModel)object2);
            return new KalapaSDKConfig.KLPLanguageConfig(((KalapaLanguageModel)object2).getData().getM77232917(), ((KalapaLanguageModel)object2).getData().getP93337());
        }
        return null;
    }

    public final void pullModel(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"baseURL");
    }

    public final void setLocale(@NotNull Context context, @NotNull String string2) {
        Locale locale;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"languageCode");
        Locale locale2 = locale;
        Locale.setDefault(new Locale(string2));
        context = context2.getResources().getConfiguration();
        context.setLocale(locale2);
        context2.getApplicationContext().createConfigurationContext((Configuration)context);
    }

    @NotNull
    public final KLPLanguageManager setLanguage(@NotNull Context context, @NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"language");
        Helpers.Companion companion = Helpers.Companion;
        Object object = new Object[1];
        int n3 = 0;
        Object object2 = language;
        if (object2 != null) {
            if (object2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"language");
                object2 = null;
            }
        } else {
            object2 = "null";
        }
        KLPLanguage.Companion companion2 = KLPLanguage.Companion;
        object[n3] = "setLanguage from " + (Object)object2 + " to " + companion2.fromCountryCode(string2);
        companion.printLog(object);
        language = companion2.fromCountryCode(string2);
        companion.printLog("setLocale from " + Locale.getDefault() + " - " + string2);
        object = Intrinsics.areEqual((Object)string2, (Object)"vi") ? "vi" : (Intrinsics.areEqual((Object)string2, (Object)"ko") ? "ko" : "en");
        this.setLocale(context, (String)object);
        companion.printLog("setLocale to " + Locale.getDefault() + " - " + string2);
        return this;
    }

    public static enum KLPLanguage {
        ENGLISH,
        VIETNAMESE,
        KOREAN;

        @NotNull
        public static final Companion Companion = new Companion(null);

        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
                this();
            }

            @NotNull
            public final KLPLanguage fromCountryCode(@NotNull String string2) {
                KLPLanguage kLPLanguage;
                block3: {
                    block2: {
                        block0: {
                            block1: {
                                String string3 = string2;
                                Intrinsics.checkNotNullParameter((Object)string3, (String)"code");
                                int n3 = string3.hashCode();
                                if (n3 == 3241) break block0;
                                if (n3 == 3428) break block1;
                                if (n3 != 3763 || !string2.equals("vi")) break block2;
                                kLPLanguage = VIETNAMESE;
                                break block3;
                            }
                            if (!string2.equals("ko")) break block2;
                            kLPLanguage = KOREAN;
                            break block3;
                        }
                        string2.equals("en");
                    }
                    kLPLanguage = ENGLISH;
                }
                return kLPLanguage;
            }
        }
    }
}

