/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.graphics.YuvImage;
import androidx.camera.core.ImageProxy;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\nvn/kalapa/ekyc/utils/ExtensionsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,150:1\n13644#2,3:151\n*S KotlinDebug\n*F\n+ 1 Extensions.kt\nvn/kalapa/ekyc/utils/ExtensionsKt\n*L\n39#1:151,3\n*E\n"})
public final class ExtensionsKt {
    @Nullable
    public static final Bitmap toBitmap(@NotNull ImageProxy imageProxy) {
        ImageProxy imageProxy2 = imageProxy;
        Intrinsics.checkNotNullParameter((Object)imageProxy2, (String)"<this>");
        byte[] byArray = ExtensionsKt.yuv420888ToNv21(imageProxy2);
        ImageProxy imageProxy3 = imageProxy;
        int n3 = imageProxy3.getWidth();
        int n4 = imageProxy3.getHeight();
        return ExtensionsKt.toBitmap(new YuvImage(byArray, 17, n3, n4, null));
    }

    private static final Bitmap toBitmap(YuvImage yuvImage) {
        int n3;
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        YuvImage yuvImage2 = yuvImage;
        int n4 = yuvImage2.getWidth();
        if (!yuvImage.compressToJpeg(new Rect(0, 0, n4, n3 = yuvImage2.getHeight()), 100, (OutputStream)byteArrayOutputStream2)) {
            return null;
        }
        byte[] byArray = byteArrayOutputStream2.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"out.toByteArray()");
        return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
    }

    private static final byte[] yuv420888ToNv21(ImageProxy imageProxy) {
        ImageProxy imageProxy2 = imageProxy;
        int n3 = imageProxy2.getCropRect().width();
        n3 = imageProxy2.getCropRect().height() * n3;
        byte[] byArray = new byte[ImageFormat.getBitsPerPixel((int)35) * n3 / 8];
        ExtensionsKt.imageToByteBuffer(imageProxy, byArray, n3);
        return byArray;
    }

    private static final void imageToByteBuffer(ImageProxy imageProxy, byte[] byArray, int n3) {
        boolean bl = imageProxy.getFormat() == 35;
        if (_Assertions.ENABLED && !bl) {
            throw new AssertionError((Object)"Assertion failed");
        }
        ImageProxy imageProxy2 = imageProxy;
        imageProxy = imageProxy2.getCropRect();
        Intrinsics.checkNotNullExpressionValue((Object)imageProxy, (String)"image.cropRect");
        ImageProxy.PlaneProxy[] planeProxyArray = imageProxy2.getPlanes();
        Intrinsics.checkNotNullExpressionValue((Object)planeProxyArray, (String)"image.planes");
        int n4 = 0;
        for (ImageProxy.PlaneProxy planeProxy : planeProxyArray) {
            int n5;
            block9: {
                int n6;
                int n7;
                ImageProxy imageProxy3;
                int n8;
                int n9;
                block10: {
                    block7: {
                        block8: {
                            n5 = n4 + 1;
                            if (n4 == 0) break block7;
                            if (n4 == 1) break block8;
                            if (n4 != 2) break block9;
                            n9 = 2;
                            n8 = n3;
                            break block10;
                        }
                        n9 = 2;
                        n8 = n3 + 1;
                        break block10;
                    }
                    n9 = 1;
                    n8 = 0;
                }
                ImageProxy.PlaneProxy planeProxy2 = planeProxy;
                ByteBuffer byteBuffer = planeProxy2.getBuffer();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"plane.buffer");
                int n10 = planeProxy2.getRowStride();
                int n11 = planeProxy2.getPixelStride();
                if (n4 == 0) {
                    imageProxy3 = imageProxy;
                } else {
                    Rect rect;
                    imageProxy3 = rect;
                    ImageProxy imageProxy4 = imageProxy;
                    n7 = imageProxy4.top / 2;
                    int n12 = imageProxy4.right / 2;
                    n6 = imageProxy4.bottom / 2;
                    rect = new Rect(imageProxy.left / 2, n7, n12, n6);
                }
                ImageProxy imageProxy5 = imageProxy3;
                int n13 = imageProxy5.width();
                n7 = imageProxy5.height();
                byte[] byArray2 = new byte[planeProxy.getRowStride()];
                n6 = n11 == 1 && n9 == 1 ? n13 : (n13 - 1) * n11 + 1;
                for (int i3 = 0; i3 < n7; ++i3) {
                    int n14 = (i3 + imageProxy3.top) * n10;
                    byteBuffer.position(imageProxy3.left * n11 + n14);
                    if (n11 == 1 && n9 == 1) {
                        byteBuffer.get(byArray, n8, n6);
                        n8 += n6;
                        continue;
                    }
                    byteBuffer.get(byArray2, 0, n6);
                    for (n14 = 0; n14 < n13; ++n14) {
                        byArray[n8] = byArray2[n14 * n11];
                        n8 += n9;
                    }
                }
            }
            n4 = n5;
        }
    }
}

