/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nFileUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtil.kt\nvn/kalapa/ekyc/utils/FileUtil\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,93:1\n13004#2,3:94\n13004#2,3:97\n*S KotlinDebug\n*F\n+ 1 FileUtil.kt\nvn/kalapa/ekyc/utils/FileUtil\n*L\n59#1:94,3\n70#1:97,3\n*E\n"})
public final class FileUtil {
    @NotNull
    public static final FileUtil INSTANCE = new FileUtil();
    private static final String TAG = FileUtil.class.getName();
    @NotNull
    public static final String FILE_FRONT_CARD = "card_image.jpg";
    @NotNull
    public static final String FILE_TEMP = "temp.jpg";
    @NotNull
    public static final String FILE_BACK_CARD = "card_back_image.jpg";
    @NotNull
    public static final String FILE_FACE = "face_image.jpg";
    @NotNull
    public static final String faceFileNameCloseEyes = "face_image_close_eyes.jpg";
    @NotNull
    public static final String faceFileNameRight = "face_image_right.jpg";
    @NotNull
    public static final String faceFileNameLeft = "face_image_left.jpg";

    private FileUtil() {
    }

    public final void saveFile(@NotNull Context object, @NotNull Bitmap bitmap, @Nullable String string2) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        if (string2 != null && !(string2.length() == 0)) {
            FileOutputStream fileOutputStream;
            File file;
            File file2 = file;
            file = new File(object.getCacheDir(), string2);
            Object[] objectArray = new Object[3];
            object = objectArray;
            object[0] = string2;
            object[1] = bitmap.getWidth();
            objectArray[2] = bitmap.getHeight();
            String string3 = String.format("Image Save File: %s - w:%s - h:%s", Arrays.copyOf(objectArray, 3));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            Log.d((String)TAG, (String)string3);
            object = fileOutputStream;
            Bitmap bitmap2 = bitmap;
            object(file2.getPath());
            Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.JPEG;
            bitmap2.compress(compressFormat, 100, (OutputStream)object);
            try {
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
    }

    @NotNull
    public final File getCardFile(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new File(context.getCacheDir(), FILE_FRONT_CARD);
    }

    @NotNull
    public final File getTempFile(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new File(context.getCacheDir(), FILE_TEMP);
    }

    @NotNull
    public final String hash(@NotNull byte[] object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"bytes");
        byte[] byArray = MessageDigest.getInstance("SHA-256").digest((byte[])object);
        Object object2 = byArray;
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest");
        object = "";
        int n3 = byArray.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            Object object3 = object;
            Object object4 = object2[i3];
            String string2 = String.format("%02x", Arrays.copyOf(new Object[]{(byte)object4}, 1));
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
            object = (String)object3 + (String)object;
        }
        return object;
    }

    @NotNull
    public final String hash(@NotNull RequestBody object) {
        Buffer buffer;
        RequestBody requestBody = object;
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"input");
        Object object2 = buffer;
        requestBody.writeTo((BufferedSink)new Buffer());
        byte[] byArray = object2.readUtf8().getBytes(Charsets.UTF_8);
        object2 = byArray;
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = MessageDigest.getInstance("SHA-256").digest((byte[])object2);
        object2 = byArray2;
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"digest");
        object = "";
        int n3 = byArray2.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            Object object3 = object;
            Object object4 = object2[i3];
            object = String.format("%02x", Arrays.copyOf(new Object[]{(byte)object4}, 1));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"format(this, *args)");
            object = (String)object3 + (String)object;
        }
        return object;
    }

    @NotNull
    public final File getFaceFile(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new File(context.getCacheDir(), FILE_FACE);
    }

    @NotNull
    public final File getFaceFileCloseEyes(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new File(context.getCacheDir(), faceFileNameCloseEyes);
    }

    @NotNull
    public final File getFaceFileRight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new File(context.getCacheDir(), faceFileNameRight);
    }

    @NotNull
    public final File getFaceFileLeft(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new File(context.getCacheDir(), faceFileNameLeft);
    }

    @NotNull
    public final File getCardBackFile(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new File(context.getCacheDir(), FILE_BACK_CARD);
    }
}

