/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.views;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vn.kalapa.R;
import vn.kalapa.ekyc.KalapaSDK;
import vn.kalapa.ekyc.utils.BitmapUtil;
import vn.kalapa.ekyc.utils.Helpers;
import vn.kalapa.ekyc.views.MaskView;

public final class CardMaskView
extends MaskView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int ID_CARD_WIDTH_SIZE = 860;
    private static final int ID_CARD_HEIGHT_SIZE = 540;
    private float roundRadius;
    private float ovalTop;
    private float ovalFrameTop;
    private final float foldOpenConst;
    private final float foldClosedConst;
    private float normalWidth;
    private float normalHeight;
    private float smallWidth;
    private float smallHeight;
    private boolean isLivenessMode;

    @JvmOverloads
    public CardMaskView(@NotNull Context context, @Nullable AttributeSet attributeSet, int n3) {
        CardMaskView cardMaskView = this;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attributeSet, n3);
        cardMaskView.foldOpenConst = 1.5f;
        cardMaskView.foldClosedConst = 0.8f;
        cardMaskView.init(context, attributeSet, n3, 0);
    }

    public /* synthetic */ CardMaskView(Context context, AttributeSet attributeSet, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            attributeSet = null;
        }
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        this(context, attributeSet, n3);
    }

    @TargetApi(value=21)
    public CardMaskView(@NotNull Context context, @Nullable AttributeSet attributeSet, int n3, int n4) {
        CardMaskView cardMaskView = this;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attributeSet, n3, n4);
        cardMaskView.foldOpenConst = 1.5f;
        cardMaskView.foldClosedConst = 0.8f;
        cardMaskView.init(context, attributeSet, n3, n4);
    }

    @SuppressLint(value={"Recycle"})
    private final void init(Context context, AttributeSet attributeSet, int n3, int n4) {
        CardMaskView cardMaskView = this;
        cardMaskView.setWillNotDraw(false);
        cardMaskView.setLayerType(2, null);
        if (attributeSet != null) {
            PorterDuffColorFilter porterDuffColorFilter;
            CardMaskView cardMaskView2 = this;
            CardMaskView cardMaskView3 = this;
            DisplayMetrics displayMetrics = cardMaskView3.getResources().getDisplayMetrics();
            Intrinsics.checkNotNullExpressionValue((Object)displayMetrics, (String)"resources.displayMetrics");
            cardMaskView3.setMetrics(displayMetrics);
            AttributeSet attributeSet2 = attributeSet = context.obtainStyledAttributes(attributeSet, R.styleable.CardMaskView, n3, n4);
            Intrinsics.checkNotNullExpressionValue((Object)attributeSet2, (String)"context.obtainStyledAttr\u2026defStyleRes\n            )");
            this.isLivenessMode = attributeSet2.getBoolean(R.styleable.CardMaskView_liveness_mode, false);
            this.setMaskColor(attributeSet.getInt(R.styleable.CardMaskView_maskColor, R.color.maskColor));
            this.setDashColor(attributeSet.getInt(R.styleable.CardMaskView_dashColor, R.color.colorPrimary));
            this.setCenterX(attributeSet.getDimension(R.styleable.CardMaskView_centerX, (float)this.getMetrics().widthPixels / 2.0f));
            cardMaskView2.setCenterY(attributeSet.getDimension(R.styleable.CardMaskView_centerY, (float)this.getMetrics().heightPixels / 2.0f));
            cardMaskView2.getTransparentPaint().setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
            cardMaskView2.getDashPaint().setStyle(Paint.Style.STROKE);
            cardMaskView2.getDashPaint().setColor(attributeSet.getInt(R.styleable.CardMaskView_dashColor, R.color.colorPrimary));
            float f3 = 2;
            cardMaskView2.getDashPaint().setStrokeWidth(attributeSet.getDimension(R.styleable.FaceDetectionView_strokeWidth, f3 * this.getMetrics().density));
            cardMaskView2.getDashPaint().setPathEffect((PathEffect)new DashPathEffect(new float[]{20.0f, 20.0f}, 0.0f));
            float f4 = cardMaskView2.getMetrics().density * 18.0f;
            f4 = cardMaskView2.isLivenessMode ? (float)(this.getMetrics().widthPixels / 5) * 4.0f : (float)this.getMetrics().widthPixels * 1.0f - f3 * f4;
            if (f4 > (float)(this.getMetrics().heightPixels / 2) || KalapaSDK.Companion.isFoldOpen(context)) {
                f4 = (float)this.getMetrics().widthPixels / this.foldOpenConst;
            }
            Helpers.Companion.printLog("CardMaskView " + this.getMetrics().widthPixels + " - Height: " + this.getMetrics().heightPixels);
            boolean bl = this.isLivenessMode;
            float f5 = bl ? f4 : f4 / (float)ID_CARD_WIDTH_SIZE * (float)ID_CARD_HEIGHT_SIZE;
            float f6 = bl ? f4 / f3 : attributeSet.getDimension(R.styleable.CardMaskView_radius, 0.0f) * this.getMetrics().density;
            CardMaskView cardMaskView4 = this;
            CardMaskView cardMaskView5 = this;
            this.roundRadius = f6;
            this.normalWidth = attributeSet.getDimension(R.styleable.CardMaskView_frameWidth, f4);
            float f7 = attributeSet.getDimension(R.styleable.CardMaskView_frameHeight, f5);
            this.normalHeight = f6 = f7;
            f6 = this.normalWidth;
            this.smallWidth = f6 * 0.8f;
            cardMaskView5.smallHeight = f7 * 0.8f;
            cardMaskView5.setFrameWidth(f6);
            cardMaskView5.setFrameHeight(cardMaskView5.normalHeight);
            this.setTransOff(attributeSet.getDimension(R.styleable.CardMaskView_transOff, this.getMetrics().density * 0.0f));
            this.setTransOffY(attributeSet.getDimension(R.styleable.CardMaskView_transOffY, this.getMetrics().density * 0.0f));
            cardMaskView4.setCornerColor(attributeSet.getColor(R.styleable.CardMaskView_cornerColor, -1));
            PorterDuffColorFilter porterDuffColorFilter2 = porterDuffColorFilter;
            porterDuffColorFilter = new PorterDuffColorFilter(this.getCornerColor(), PorterDuff.Mode.DST_IN);
            if (cardMaskView4.getCornerColor() != -1) {
                PorterDuffColorFilter porterDuffColorFilter3;
                porterDuffColorFilter2 = porterDuffColorFilter3;
                porterDuffColorFilter3 = new PorterDuffColorFilter(this.getCornerColor(), PorterDuff.Mode.SRC_IN);
            }
            CardMaskView cardMaskView6 = this;
            cardMaskView6.getCornerPaint().setColorFilter((ColorFilter)porterDuffColorFilter2);
            cardMaskView6.setFrame();
            cardMaskView6.setConner(null);
        }
    }

    private final void draw4Corners(Canvas canvas, RectF rectF, Paint paint) {
        canvas.drawBitmap(BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.drawable.frame_exclude_png), null, rectF, paint);
    }

    @JvmOverloads
    public CardMaskView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public CardMaskView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    public final float getNormalWidth() {
        return this.normalWidth;
    }

    public final void setNormalWidth(float f3) {
        this.normalWidth = f3;
    }

    public final float getNormalHeight() {
        return this.normalHeight;
    }

    public final void setNormalHeight(float f3) {
        this.normalHeight = f3;
    }

    public final float getSmallWidth() {
        return this.smallWidth;
    }

    public final void setSmallWidth(float f3) {
        this.smallWidth = f3;
    }

    public final float getSmallHeight() {
        return this.smallHeight;
    }

    public final void setSmallHeight(float f3) {
        this.smallHeight = f3;
    }

    public final boolean isLivenessMode() {
        return this.isLivenessMode;
    }

    public final void setLivenessMode(boolean bl) {
        this.isLivenessMode = bl;
    }

    @Override
    public void setFrame() {
        CardMaskView cardMaskView = this;
        Helpers.Companion.printLog("setFrame transOffY " + this.getTransOffY());
        CardMaskView cardMaskView2 = this;
        float f3 = 2;
        float f4 = cardMaskView2.getCenterX() - this.getFrameWidth() / f3;
        float f5 = cardMaskView2.getCenterY();
        f5 = cardMaskView2.getTransOffY() + f5 - this.getFrameHeight() / f3;
        float f6 = cardMaskView2.getCenterX();
        f6 = cardMaskView2.getFrameWidth() / f3 + f6;
        float f7 = cardMaskView2.getCenterY();
        float f8 = f4;
        CardMaskView cardMaskView3 = this;
        f4 = cardMaskView3.getTransOffY() + f7;
        cardMaskView.setFrame(new RectF(f8, f5, f6, cardMaskView3.getFrameHeight() / f3 + f4));
        CardMaskView cardMaskView4 = this;
        f3 = cardMaskView4.getFrame().left;
        float f9 = cardMaskView4.getTransOff() + f3;
        CardMaskView cardMaskView5 = this;
        f3 = cardMaskView5.getFrame().top;
        f3 = cardMaskView5.getTransOff() + f3;
        f4 = cardMaskView5.getFrame().right - this.getTransOff();
        float f10 = cardMaskView5.getFrame().bottom - this.getTransOff();
        cardMaskView.setTransparentFrame(new RectF(f9, f3, f4, f10));
    }

    public final void switchIntoFarModeLiveness() {
        CardMaskView cardMaskView = this;
        cardMaskView.setFrameWidth(cardMaskView.smallWidth);
        cardMaskView.setFrameHeight(cardMaskView.smallWidth);
        cardMaskView.setFrame();
    }

    public final void resetToDefault() {
        CardMaskView cardMaskView = this;
        cardMaskView.setFrameWidth(cardMaskView.normalWidth);
        cardMaskView.setFrameHeight(cardMaskView.normalWidth);
        cardMaskView.setFrame();
    }

    public void draw(@NotNull Canvas canvas) {
        float f3;
        CardMaskView cardMaskView = this;
        Canvas canvas2 = canvas;
        Intrinsics.checkNotNullParameter((Object)canvas2, (String)"canvas");
        super.draw(canvas2);
        if (!cardMaskView.isLivenessMode) {
            CardMaskView cardMaskView2 = this;
            CardMaskView cardMaskView3 = this;
            RectF rectF = cardMaskView3.getTransparentFrame();
            float f4 = cardMaskView3.roundRadius;
            Paint paint = cardMaskView3.getTransparentPaint();
            float f5 = f4;
            canvas.drawRoundRect(rectF, f5, f5, paint);
            rectF = cardMaskView2.getFrame();
            Paint paint2 = cardMaskView2.getDashPaint();
            cardMaskView2.draw4Corners(canvas, rectF, paint2);
        } else {
            if (this.ovalTop == 0.0f) {
                this.ovalTop = this.getTransparentFrame().top - this.getTransparentFrame().bottom * 0.0618f;
            }
            if (this.ovalFrameTop == 0.0f) {
                this.ovalFrameTop = this.getFrame().top - this.getFrame().bottom * 0.0618f;
            }
            CardMaskView cardMaskView4 = this;
            CardMaskView cardMaskView5 = this;
            float f6 = cardMaskView5.getTransparentFrame().left;
            float f7 = cardMaskView5.ovalTop;
            float f8 = cardMaskView5.getTransparentFrame().right;
            f3 = cardMaskView5.getTransparentFrame().bottom;
            Paint paint = cardMaskView5.getTransparentPaint();
            canvas.drawOval(f6, f7, f8, f3, paint);
            f6 = cardMaskView4.getFrame().left;
            f7 = cardMaskView4.ovalFrameTop;
            f8 = cardMaskView4.getFrame().right;
            f3 = cardMaskView4.getFrame().bottom;
            paint = cardMaskView4.getDashPaint();
            canvas.drawOval(f6, f7, f8, f3, paint);
        }
        Bitmap bitmap = this.getConner();
        if (bitmap != null) {
            RectF rectF;
            Matrix matrix;
            RectF rectF2;
            Matrix matrix2;
            RectF rectF3;
            Matrix matrix3;
            RectF rectF4;
            Bitmap bitmap2 = bitmap;
            Bitmap bitmap3 = bitmap;
            Bitmap bitmap4 = bitmap;
            Bitmap bitmap5 = bitmap;
            CardMaskView cardMaskView6 = this;
            float f9 = cardMaskView6.getConnerSize() / 2.0f;
            bitmap = rectF4;
            CardMaskView cardMaskView7 = this;
            float f10 = cardMaskView7.getFrame().top - f9;
            float f11 = cardMaskView7.getFrame().left - f9;
            f11 = cardMaskView7.getConnerSize() + f11;
            f3 = cardMaskView7.getFrame().top - f9;
            f3 = cardMaskView7.getConnerSize() + f3;
            rectF4 = new RectF(this.getFrame().left - f9, f10, f11, f3);
            Paint paint = cardMaskView6.getCornerPaint();
            canvas.drawBitmap(bitmap5, null, (RectF)bitmap, paint);
            bitmap = matrix3;
            new Matrix().setRotate(90.0f);
            int n3 = bitmap4.getWidth();
            int n4 = bitmap4.getHeight();
            bitmap = Bitmap.createBitmap((Bitmap)bitmap4, (int)0, (int)0, (int)n3, (int)n4, (Matrix)bitmap, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(it, 0, 0, i\u2026 it.height, matrix, true)");
            RectF rectF5 = rectF3;
            CardMaskView cardMaskView8 = this;
            float f12 = cardMaskView8.getFrame().top - f9;
            f3 = cardMaskView8.getFrame().right - f9;
            f3 = cardMaskView8.getConnerSize() + f3;
            float f13 = cardMaskView8.getFrame().top - f9;
            f13 = cardMaskView8.getConnerSize() + f13;
            rectF3 = new RectF(this.getFrame().right - f9, f12, f3, f13);
            Paint paint3 = this.getCornerPaint();
            canvas.drawBitmap(bitmap, null, rectF5, paint3);
            bitmap = matrix2;
            new Matrix().setRotate(-90.0f);
            int n5 = bitmap3.getWidth();
            int n6 = bitmap3.getHeight();
            bitmap = Bitmap.createBitmap((Bitmap)bitmap3, (int)0, (int)0, (int)n5, (int)n6, (Matrix)bitmap, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(it, 0, 0, i\u2026 it.height, matrix, true)");
            RectF rectF6 = rectF2;
            CardMaskView cardMaskView9 = this;
            float f14 = cardMaskView9.getFrame().bottom - f9;
            f3 = cardMaskView9.getFrame().left - f9;
            f3 = cardMaskView9.getConnerSize() + f3;
            f13 = cardMaskView9.getFrame().bottom - f9;
            f13 = cardMaskView9.getConnerSize() + f13;
            rectF2 = new RectF(this.getFrame().left - f9, f14, f3, f13);
            Paint paint4 = this.getCornerPaint();
            canvas.drawBitmap(bitmap, null, rectF6, paint4);
            bitmap = matrix;
            new Matrix().setRotate(180.0f);
            int n7 = bitmap2.getWidth();
            int n8 = bitmap2.getHeight();
            bitmap = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)n7, (int)n8, (Matrix)bitmap, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(it, 0, 0, i\u2026 it.height, matrix, true)");
            RectF rectF7 = rectF;
            float f15 = this.getFrame().right - f9;
            CardMaskView cardMaskView10 = this;
            float f16 = cardMaskView10.getFrame().bottom - f9;
            float f17 = cardMaskView10.getFrame().right - f9;
            f17 = cardMaskView10.getConnerSize() + f17;
            f9 = cardMaskView10.getFrame().bottom - f9;
            f9 = cardMaskView10.getConnerSize() + f9;
            rectF = new RectF(f15, f16, f17, f9);
            Paint paint5 = this.getCornerPaint();
            canvas.drawBitmap(bitmap, null, rectF7, paint5);
        }
    }

    @Override
    @NotNull
    public Bitmap crop(@NotNull Bitmap bitmap, int n3) {
        CardMaskView cardMaskView = this;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"inputImage");
        bitmap = BitmapUtil.Companion.rotateBitmapToStraight$default(BitmapUtil.Companion, bitmap, n3, false, 4, null);
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        float f3 = (float)bitmap.getWidth() / (float)this.getWidth();
        float f4 = (float)bitmap.getHeight() / (float)this.getHeight();
        float f5 = Math.min(f3, f4);
        float f6 = cardMaskView.getTransparentFrame().left - this.getTransOffY();
        f6 = (cardMaskView.getTransOff() * (float)2 + f6) * f3;
        float f7 = cardMaskView.getTransparentFrame().top * f4;
        float f8 = cardMaskView.getTransparentFrame().width() * f5;
        f5 = cardMaskView.getTransparentFrame().height() * f5;
        Helpers.Companion companion = Helpers.Companion;
        Object[] objectArray = new Object[1];
        int n4 = n3;
        CardMaskView cardMaskView2 = this;
        DisplayMetrics displayMetrics2 = displayMetrics;
        n3 = displayMetrics2.densityDpi;
        float f9 = displayMetrics2.density;
        float f10 = cardMaskView2.getTransOffY();
        float f11 = cardMaskView2.getTransOff();
        objectArray[0] = "Camera Degree: cameraDegree " + n4 + " " + n3 + " " + f9 + " scaleW " + f3 + " scaleH " + f4 + " transOffY " + f10 + " transOff " + f11;
        companion.printLog(objectArray);
        Object[] objectArray2 = new Object[1];
        CardMaskView cardMaskView3 = this;
        Bitmap bitmap2 = bitmap;
        CardMaskView cardMaskView4 = this;
        float f12 = cardMaskView4.getFrameHeight();
        f9 = cardMaskView4.getFrame().centerX();
        f10 = cardMaskView4.getFrame().centerY();
        int n5 = bitmap2.getWidth();
        int n6 = bitmap2.getHeight();
        int n7 = cardMaskView3.getWidth();
        int n8 = cardMaskView3.getHeight();
        float f13 = cardMaskView3.getCenterX();
        float f14 = cardMaskView3.getCenterY();
        float f15 = f12;
        CardMaskView cardMaskView5 = this;
        f12 = cardMaskView5.getFrame().width();
        float f16 = cardMaskView5.getFrame().height();
        float f17 = cardMaskView5.getFrame().top;
        float f18 = cardMaskView5.getFrame().left;
        float f19 = cardMaskView5.getFrame().centerX();
        float f20 = cardMaskView5.getFrame().centerY();
        objectArray2[0] = "frameWidth " + this.getFrameWidth() + " frameHeight " + f15 + " frame centerX " + f9 + " frame center Y " + f10 + " \n image.width " + n5 + " image.height " + n6 + " \n width " + n7 + " height " + n8 + " centerX " + f13 + " centerY " + f14 + "\n frame " + f12 + " height() " + f16 + " top() " + f17 + "  left() " + f18 + " center X " + f19 + " center Y " + f20;
        companion.printLog(objectArray2);
        KalapaSDK.Companion companion2 = KalapaSDK.Companion;
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        if (companion2.isFoldOpen(context)) {
            companion.printLog("Crop on Foldable is open");
            float f21 = f7 + f5;
            if (Math.abs(this.getTransOffY()) + f21 <= (float)bitmap.getHeight()) {
                f5 = Math.abs(this.getTransOffY()) + f5;
            }
            if (f7 + f5 > (float)bitmap.getHeight()) {
                f5 = (float)bitmap.getHeight() - f7;
            }
            int n9 = (int)f7;
            int n10 = bitmap.getWidth();
            int n11 = (int)f5;
            Bitmap bitmap3 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)n9, (int)n10, (int)n11);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"createBitmap(\n          \u2026rop.toInt()\n            )");
            return bitmap3;
        }
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        if (companion2.isTablet(context2)) {
            float f22;
            float f23;
            float f24;
            companion.printLog("Crop on Tablet");
            float f25 = 40;
            f9 = f6 - f25 * f3;
            if (f24 > 0.0f) {
                f6 = f9;
            }
            f25 = f7 - f25 * f4;
            if (f23 > 0.0f) {
                f7 = f25;
            }
            float f26 = this.getTransparentFrame().width();
            f26 = Math.max(f3, f4) * f26;
            f25 = this.getTransparentFrame().height();
            f25 = Math.max(f3, f4) * f25;
            if (f7 + f22 > (float)bitmap.getHeight()) {
                f25 = (float)bitmap.getHeight() - f7;
            }
            if (f6 + f26 > (float)bitmap.getWidth()) {
                f26 = (float)bitmap.getWidth() - f6;
            }
            int n12 = (int)f6;
            int n13 = (int)f7;
            int n14 = (int)f26;
            int n15 = (int)f25;
            Bitmap bitmap4 = Bitmap.createBitmap((Bitmap)bitmap, (int)n12, (int)n13, (int)n14, (int)n15);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap4, (String)"createBitmap(\n          \u2026rop.toInt()\n            )");
            return bitmap4;
        }
        float f27 = f6 - 0.0f;
        float f28 = f27 == 0.0f ? 0 : (f27 < 0.0f ? -1 : 1);
        int n16 = f28 >= 0 && !(f6 + f8 > (float)bitmap.getWidth()) ? 0 : 1;
        float f29 = f7 - 0.0f;
        float f30 = f29 == 0.0f ? 0 : (f29 < 0.0f ? -1 : 1);
        boolean bl = f30 < 0 || f7 + f5 > (float)bitmap.getHeight();
        if (n16 == 0 && !bl) {
            f28 = (int)f6;
            int n17 = (int)f7;
            n16 = (int)f8;
            f30 = (int)f5;
            Bitmap bitmap5 = Bitmap.createBitmap((Bitmap)bitmap, (int)f28, (int)n17, (int)n16, (int)f30);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap5, (String)"createBitmap(\n          \u2026rop.toInt()\n            )");
            return bitmap5;
        }
        if (n16 != 0) {
            if (f30 < 0) {
                f7 = 0.0f;
            }
            int n18 = (int)((float)bitmap.getWidth() * 1.0f * (float)ID_CARD_HEIGHT_SIZE / (float)ID_CARD_WIDTH_SIZE);
            f28 = n18;
            if (f7 + (float)n18 > (float)bitmap.getHeight()) {
                f28 = bitmap.getHeight();
            }
            Bitmap bitmap6 = bitmap;
            int n19 = (int)f7;
            n16 = bitmap6.getWidth();
            Bitmap bitmap7 = Bitmap.createBitmap((Bitmap)bitmap6, (int)0, (int)n19, (int)n16, (int)f28);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap7, (String)"createBitmap(image, 0, y\u2026, image.width, newHeight)");
            return bitmap7;
        }
        if (f28 < 0) {
            f6 = 0.0f;
        }
        int n20 = (int)((float)bitmap.getHeight() * 1.0f * (float)ID_CARD_WIDTH_SIZE / (float)ID_CARD_HEIGHT_SIZE);
        f28 = n20;
        if (f7 + (float)n20 > (float)bitmap.getWidth()) {
            f28 = bitmap.getWidth();
        }
        Bitmap bitmap8 = bitmap;
        int n21 = (int)f6;
        n16 = bitmap8.getHeight();
        Bitmap bitmap9 = Bitmap.createBitmap((Bitmap)bitmap8, (int)n21, (int)0, (int)f28, (int)n16);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap9, (String)"createBitmap(image, xCro\u2026, newWidth, image.height)");
        return bitmap9;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public final int getID_CARD_WIDTH_SIZE() {
            return ID_CARD_WIDTH_SIZE;
        }

        public final int getID_CARD_HEIGHT_SIZE() {
            return ID_CARD_HEIGHT_SIZE;
        }
    }
}

