/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.views;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Movie;
import android.net.Uri;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import java.io.FileNotFoundException;
import java.io.InputStream;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KLPGifImageView
extends View {
    @Nullable
    private InputStream mInputStream;
    private Movie mMovie;
    private int mWidth;
    private int mHeight;
    private long mStart;
    @NotNull
    private Context mContext;
    private int leftAdjustment;
    private int topAdjustment;

    public KLPGifImageView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.mContext = context;
    }

    public KLPGifImageView(@NotNull Context context, @NotNull AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attributeSet, (String)"attrs");
        this(context, attributeSet, 0);
    }

    public KLPGifImageView(@NotNull Context context, @NotNull AttributeSet attributeSet, int n3) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attributeSet, (String)"attrs");
        super(context, attributeSet, n3);
        this.mContext = context;
        if (attributeSet.getAttributeName(1).equals("background")) {
            String string2 = attributeSet.getAttributeValue(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"attrs.getAttributeValue(1)");
            String string3 = string2.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            this.setGifImageResource(Integer.parseInt(string3));
        }
    }

    private final void init() {
        Movie movie;
        KLPGifImageView kLPGifImageView = this;
        kLPGifImageView.setFocusable(true);
        Movie movie2 = movie = Movie.decodeStream((InputStream)kLPGifImageView.mInputStream);
        Intrinsics.checkNotNullExpressionValue((Object)movie2, (String)"decodeStream(mInputStream)");
        this.mMovie = movie2;
        if (movie == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mMovie");
            movie = null;
        }
        this.mWidth = movie.width();
        movie = this.mMovie;
        if (movie == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mMovie");
            movie = null;
        }
        this.mHeight = movie.height();
        this.requestLayout();
    }

    public void onMeasure(int n3, int n4) {
        KLPGifImageView kLPGifImageView = this;
        int n5 = kLPGifImageView.mWidth;
        kLPGifImageView.setMeasuredDimension(n5, kLPGifImageView.mHeight);
    }

    public void onDraw(@NotNull Canvas canvas) {
        Movie movie;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        long l3 = SystemClock.uptimeMillis();
        if (this.mStart == 0L) {
            this.mStart = l3;
        }
        if ((movie = this.mMovie) != null) {
            int n3;
            if (movie == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mMovie");
                movie = null;
            }
            if ((n3 = movie.duration()) == 0) {
                n3 = 1000;
            }
            int n4 = (int)((l3 - this.mStart) % (long)n3);
            Movie movie2 = this.mMovie;
            if (movie2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mMovie");
                movie2 = null;
            }
            movie2.setTime(n4);
            Movie movie3 = this.mMovie;
            if (movie3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mMovie");
                movie3 = null;
            }
            movie3.draw(canvas, 0.0f, 0.0f);
            this.invalidate();
        }
    }

    public final void setGifImageResource(int n3) {
        KLPGifImageView kLPGifImageView = this;
        kLPGifImageView.mInputStream = kLPGifImageView.mContext.getResources().openRawResource(n3);
        kLPGifImageView.setVisibility(0);
        kLPGifImageView.init();
    }

    public final void setGifImageUri(@NotNull Uri uri) {
        KLPGifImageView kLPGifImageView = this;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        try {
            kLPGifImageView.mInputStream = kLPGifImageView.mContext.getContentResolver().openInputStream(uri);
            kLPGifImageView.init();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.e((String)"GIfImageView", (String)"File not found");
        }
    }
}

