/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.views;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.View;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vn.kalapa.ekyc.utils.Common;
import vn.kalapa.ekyc.views.OvalLivenessOverlayView;

public final class OvalLivenessOverlayView
extends View {
    @NotNull
    private final Paint ovalPaint;
    @NotNull
    private final Paint overlayPaint;
    @NotNull
    private final Paint clearPaint;
    @NotNull
    private final RectF ovalRect;
    @NotNull
    private final BlurMaskFilter blurMaskFilter;
    private final float ovalSize;
    @Nullable
    private ValueAnimator progressAnimator;
    private float currentProgress;
    private int currentPart;
    private int totalParts;
    @NotNull
    private Map<Integer, Float> completedProgress;
    private int progressColor;
    private final int backgroundColor;
    private boolean isLastStepInProgress;
    private boolean isAnimating;

    @JvmOverloads
    public OvalLivenessOverlayView(@NotNull Context context, @Nullable AttributeSet attributeSet, int n3) {
        OvalLivenessOverlayView ovalLivenessOverlayView;
        BlurMaskFilter blurMaskFilter;
        Paint paint;
        OvalLivenessOverlayView ovalLivenessOverlayView2 = ovalLivenessOverlayView3;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, attributeSet, n3);
        Paint paint2 = new Paint();
        paint2.setStyle(Paint.Style.STROKE);
        paint2.setStrokeWidth(ovalLivenessOverlayView3.dpToPx(2.0f));
        paint2.setAntiAlias(true);
        ovalLivenessOverlayView2.ovalPaint = paint2;
        Context context3 = context = paint;
        super();
        context3.setColor(Color.parseColor((String)"#BF000000"));
        context3.setAntiAlias(true);
        ovalLivenessOverlayView3.overlayPaint = context3;
        Paint paint3 = new Paint();
        paint3.setStyle(Paint.Style.FILL);
        paint3.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        paint3.setAntiAlias(true);
        ovalLivenessOverlayView3.clearPaint = paint3;
        ovalLivenessOverlayView3.ovalRect = new RectF();
        OvalLivenessOverlayView ovalLivenessOverlayView3 = blurMaskFilter;
        ovalLivenessOverlayView.blurMaskFilter = new BlurMaskFilter(20.0f, BlurMaskFilter.Blur.NORMAL);
        ovalLivenessOverlayView.ovalSize = ovalLivenessOverlayView.dpToPx(250.0f);
        ovalLivenessOverlayView.currentPart = 1;
        ovalLivenessOverlayView.totalParts = 2;
        ovalLivenessOverlayView.completedProgress = new LinkedHashMap<Integer, Float>();
        ovalLivenessOverlayView.progressColor = -16711936;
        ovalLivenessOverlayView.backgroundColor = -3355444;
        paint.setMaskFilter((MaskFilter)ovalLivenessOverlayView3);
        ovalLivenessOverlayView2.setLayerType(2, null);
    }

    public /* synthetic */ OvalLivenessOverlayView(Context context, AttributeSet attributeSet, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            attributeSet = null;
        }
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        this(context, attributeSet, n3);
    }

    private final void startAnim(long l3, Function0<Unit> function0) {
        ValueAnimator valueAnimator = this.progressAnimator;
        if (valueAnimator != null) {
            valueAnimator.cancel();
        }
        OvalLivenessOverlayView ovalLivenessOverlayView = this;
        ValueAnimator valueAnimator2 = valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        valueAnimator2.setDuration(l3);
        valueAnimator2.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        valueAnimator.addUpdateListener(arg_0 -> OvalLivenessOverlayView.startAnim$lambda$4$lambda$3(this, arg_0));
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this, function0){
            public final /* synthetic */ OvalLivenessOverlayView this$0;
            public final /* synthetic */ Function0<Unit> $onAnimationEnd;
            {
                this.this$0 = ovalLivenessOverlayView;
                this.$onAnimationEnd = function0;
            }

            public void onAnimationEnd(@NotNull Animator animator) {
                Function0<Unit> function0 = function02;
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animation");
                OvalLivenessOverlayView.access$getCompletedProgress$p(function0.this$0).put(OvalLivenessOverlayView.access$getCurrentPart$p(function02.this$0), Float.valueOf(1.0f));
                OvalLivenessOverlayView.access$setAnimating$p(function0.this$0, false);
                Function0<Unit> function02 = function0.$onAnimationEnd;
                if (function02 != null) {
                    function02.invoke();
                }
            }
        });
        valueAnimator.start();
        ovalLivenessOverlayView.isAnimating = true;
        ovalLivenessOverlayView.progressAnimator = valueAnimator;
    }

    public static /* synthetic */ void startAnim$default(OvalLivenessOverlayView ovalLivenessOverlayView, long l3, Function0 function0, int n3, Object object) {
        if ((n3 & 1) != 0) {
            l3 = 2000L;
        }
        if ((n3 & 2) != 0) {
            function0 = null;
        }
        ovalLivenessOverlayView.startAnim(l3, (Function0<Unit>)function0);
    }

    public static /* synthetic */ void nextPart$default(OvalLivenessOverlayView ovalLivenessOverlayView, long l3, int n3, Object object) {
        if ((n3 & 1) != 0) {
            l3 = 600L;
        }
        ovalLivenessOverlayView.nextPart(l3);
    }

    public static /* synthetic */ void progressFail$default(OvalLivenessOverlayView ovalLivenessOverlayView, long l3, int n3, Object object) {
        if ((n3 & 1) != 0) {
            l3 = 2000L;
        }
        ovalLivenessOverlayView.progressFail(l3);
    }

    private final int interpolateColor(int n3, int n4, float f3) {
        int n5 = n3;
        int n6 = Color.alpha((int)n5);
        n3 = Color.red((int)n5);
        int n7 = Color.green((int)n5);
        int n8 = Color.blue((int)n5);
        int n9 = Color.alpha((int)n4);
        int n10 = n6;
        int n11 = n4;
        n6 = Color.red((int)n11);
        n4 = Color.green((int)n11);
        int n12 = Color.blue((int)n11);
        float f4 = n10;
        int n13 = n8;
        int n14 = n7;
        int n15 = n3;
        float f5 = n15;
        int n16 = (int)((float)(n6 - n15) * f3 + f5);
        float f6 = n14;
        int n17 = (int)((float)(n4 - n14) * f3 + f6);
        float f7 = n13;
        int n18 = (int)((float)(n12 - n13) * f3 + f7);
        return Color.argb((int)((int)((float)(n9 - n10) * f3 + f4)), (int)n16, (int)n17, (int)n18);
    }

    private final float dpToPx(float f3) {
        return f3 * this.getContext().getResources().getDisplayMetrics().density;
    }

    @JvmOverloads
    public OvalLivenessOverlayView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public OvalLivenessOverlayView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void startAnim$lambda$4$lambda$3(OvalLivenessOverlayView ovalLivenessOverlayView, ValueAnimator valueAnimator) {
        ValueAnimator valueAnimator2 = valueAnimator;
        Intrinsics.checkNotNullParameter((Object)((Object)ovalLivenessOverlayView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)valueAnimator2, (String)"animator");
        Object object = valueAnimator2.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
        ovalLivenessOverlayView.currentProgress = ((Float)object).floatValue();
        ovalLivenessOverlayView.invalidate();
    }

    private static final void startSuccessAnimation$lambda$6$lambda$5(OvalLivenessOverlayView ovalLivenessOverlayView, ValueAnimator valueAnimator) {
        OvalLivenessOverlayView ovalLivenessOverlayView2 = ovalLivenessOverlayView;
        ValueAnimator valueAnimator2 = valueAnimator;
        Intrinsics.checkNotNullParameter((Object)((Object)ovalLivenessOverlayView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)valueAnimator2, (String)"animator");
        Object object = valueAnimator2.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
        float f3 = ((Float)object).floatValue();
        ovalLivenessOverlayView2.progressColor = ovalLivenessOverlayView2.interpolateColor(-256, -16711936, f3);
        ovalLivenessOverlayView2.invalidate();
    }

    public static final /* synthetic */ int access$getCurrentPart$p(OvalLivenessOverlayView ovalLivenessOverlayView) {
        return ovalLivenessOverlayView.currentPart;
    }

    public static final /* synthetic */ int access$getTotalParts$p(OvalLivenessOverlayView ovalLivenessOverlayView) {
        return ovalLivenessOverlayView.totalParts;
    }

    public static final /* synthetic */ void access$setCurrentPart$p(OvalLivenessOverlayView ovalLivenessOverlayView, int n3) {
        ovalLivenessOverlayView.currentPart = n3;
    }

    public static final /* synthetic */ void access$setCurrentProgress$p(OvalLivenessOverlayView ovalLivenessOverlayView, float f3) {
        ovalLivenessOverlayView.currentProgress = f3;
    }

    public static final /* synthetic */ void access$setLastStepInProgress$p(OvalLivenessOverlayView ovalLivenessOverlayView, boolean bl) {
        ovalLivenessOverlayView.isLastStepInProgress = bl;
    }

    public static final /* synthetic */ Map access$getCompletedProgress$p(OvalLivenessOverlayView ovalLivenessOverlayView) {
        return ovalLivenessOverlayView.completedProgress;
    }

    public static final /* synthetic */ void access$setAnimating$p(OvalLivenessOverlayView ovalLivenessOverlayView, boolean bl) {
        ovalLivenessOverlayView.isAnimating = bl;
    }

    public void onDraw(@NotNull Canvas canvas) {
        OvalLivenessOverlayView ovalLivenessOverlayView = this;
        OvalLivenessOverlayView ovalLivenessOverlayView2 = this;
        OvalLivenessOverlayView ovalLivenessOverlayView3 = this;
        OvalLivenessOverlayView ovalLivenessOverlayView4 = this;
        Canvas canvas2 = canvas;
        Intrinsics.checkNotNullParameter((Object)canvas2, (String)"canvas");
        super.onDraw(canvas2);
        float f3 = ovalLivenessOverlayView4.getWidth();
        float f4 = ovalLivenessOverlayView4.getHeight();
        Paint paint = ovalLivenessOverlayView4.overlayPaint;
        canvas.drawRect(0.0f, 0.0f, f3, f4, paint);
        f3 = (float)ovalLivenessOverlayView3.getWidth() / 2.0f;
        f4 = (float)ovalLivenessOverlayView3.getHeight() / 2.0f;
        float f5 = ovalLivenessOverlayView3.ovalSize;
        float f6 = f5 * 1.3f;
        float f7 = f4;
        float f8 = f3;
        float f9 = f4;
        float f10 = f3;
        f3 = 2;
        f4 = f5 / f3;
        f5 = f10 - f4;
        f3 = f6 / f3;
        f6 = f9 - f3;
        f4 = f8 + f4;
        f3 = f7 + f3;
        ovalLivenessOverlayView3.ovalRect.set(f5, f6, f4, f3);
        RectF rectF = ovalLivenessOverlayView3.ovalRect;
        canvas.drawOval(rectF, ovalLivenessOverlayView3.clearPaint);
        ovalLivenessOverlayView2.ovalPaint.setColor(this.backgroundColor);
        ovalLivenessOverlayView2.ovalPaint.setStyle(Paint.Style.STROKE);
        ovalLivenessOverlayView2.ovalPaint.setStrokeWidth(this.dpToPx(2.0f));
        rectF = ovalLivenessOverlayView2.ovalRect;
        canvas.drawOval(rectF, ovalLivenessOverlayView2.ovalPaint);
        ovalLivenessOverlayView.ovalPaint.setColor(this.progressColor);
        ovalLivenessOverlayView.ovalPaint.setStyle(Paint.Style.STROKE);
        ovalLivenessOverlayView.ovalPaint.setStrokeWidth(this.dpToPx(2.0f));
        float f11 = 360.0f / (float)ovalLivenessOverlayView.totalParts;
        int n3 = ovalLivenessOverlayView.currentPart;
        for (int i3 = 1; i3 < n3; ++i3) {
            OvalLivenessOverlayView ovalLivenessOverlayView5 = this;
            f6 = (float)(i3 - 1) * f11 + -90.0f;
            RectF rectF2 = ovalLivenessOverlayView5.ovalRect;
            Paint paint2 = ovalLivenessOverlayView5.ovalPaint;
            canvas.drawArc(rectF2, f6, f11, false, paint2);
        }
        OvalLivenessOverlayView ovalLivenessOverlayView6 = this;
        float f12 = (float)(ovalLivenessOverlayView6.currentPart - 1) * f11 + -90.0f;
        float f13 = ovalLivenessOverlayView6.currentProgress * f11;
        RectF rectF3 = ovalLivenessOverlayView6.ovalRect;
        Paint paint3 = ovalLivenessOverlayView6.ovalPaint;
        canvas.drawArc(rectF3, f12, f13, false, paint3);
    }

    public final void nextPart(long l3) {
        int n3 = this.currentPart;
        int n4 = this.totalParts;
        if (n3 <= n4) {
            Function0<Unit> function0;
            if (n3 == n4 && this.isLastStepInProgress) {
                return;
            }
            this.progressColor = -16711936;
            if (n3 == n4) {
                this.startSuccessAnimation();
                this.isLastStepInProgress = true;
            }
            Function0<Unit> function02 = function0;
            function0 = new Function0<Unit>(this){
                public final /* synthetic */ OvalLivenessOverlayView this$0;
                {
                    this.this$0 = ovalLivenessOverlayView;
                    super(0);
                }

                public final void invoke() {
                    if (OvalLivenessOverlayView.access$getCurrentPart$p(this.this$0) < OvalLivenessOverlayView.access$getTotalParts$p(this.this$0)) {
                        nextPart.1 v02 = this;
                        OvalLivenessOverlayView ovalLivenessOverlayView = v02.this$0;
                        OvalLivenessOverlayView.access$setCurrentPart$p(ovalLivenessOverlayView, OvalLivenessOverlayView.access$getCurrentPart$p(ovalLivenessOverlayView) + 1);
                        OvalLivenessOverlayView.access$setCurrentProgress$p(v02.this$0, 0.0f);
                    }
                    if (OvalLivenessOverlayView.access$getCurrentPart$p(this.this$0) == OvalLivenessOverlayView.access$getTotalParts$p(this.this$0)) {
                        OvalLivenessOverlayView.access$setLastStepInProgress$p(this.this$0, false);
                    }
                }
            };
            this.startAnim(l3, function02);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setLivenessVersion(@NotNull Common.LIVENESS_VERSION lIVENESS_VERSION) {
        Intrinsics.checkNotNullParameter((Object)((Object)lIVENESS_VERSION), (String)"version");
        int n3 = WhenMappings.$EnumSwitchMapping$0[lIVENESS_VERSION.ordinal()];
        if (n3 != 1) {
            if (n3 != 2) {
                if (n3 != 3) throw new NoWhenBranchMatchedException();
                n3 = 3;
            } else {
                n3 = 2;
            }
        } else {
            n3 = 1;
        }
        OvalLivenessOverlayView ovalLivenessOverlayView = this;
        ovalLivenessOverlayView.totalParts = n3;
        ovalLivenessOverlayView.currentPart = 1;
        ovalLivenessOverlayView.completedProgress.clear();
        ovalLivenessOverlayView.stopProgress();
    }

    public final void progressFail(long l3) {
        this.progressColor = -65536;
        this.currentPart = 0;
        this.totalParts = 1;
        this.completedProgress.clear();
        this.isLastStepInProgress = false;
        OvalLivenessOverlayView.startAnim$default(this, l3, null, 2, null);
    }

    public final void stopProgress() {
        ValueAnimator valueAnimator = this.progressAnimator;
        if (valueAnimator != null) {
            valueAnimator.cancel();
        }
        this.currentProgress = 0.0f;
        this.isAnimating = false;
        this.invalidate();
    }

    public final void resetProgress() {
        ValueAnimator valueAnimator = this.progressAnimator;
        if (valueAnimator != null) {
            valueAnimator.cancel();
        }
        OvalLivenessOverlayView ovalLivenessOverlayView = this;
        ovalLivenessOverlayView.currentProgress = 0.0f;
        ovalLivenessOverlayView.currentPart = 1;
        ovalLivenessOverlayView.progressColor = -16711936;
        ovalLivenessOverlayView.isLastStepInProgress = false;
        ovalLivenessOverlayView.completedProgress.clear();
        ovalLivenessOverlayView.isAnimating = false;
        ovalLivenessOverlayView.invalidate();
    }

    public final void startSuccessAnimation() {
        if (!this.isAnimating) {
            ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            valueAnimator.setDuration(500L);
            valueAnimator.addUpdateListener(arg_0 -> OvalLivenessOverlayView.startSuccessAnimation$lambda$6$lambda$5(this, arg_0));
            valueAnimator.start();
        }
    }

    public void onDetachedFromWindow() {
        OvalLivenessOverlayView ovalLivenessOverlayView = ovalLivenessOverlayView2;
        super.onDetachedFromWindow();
        OvalLivenessOverlayView ovalLivenessOverlayView2 = ovalLivenessOverlayView.progressAnimator;
        if (ovalLivenessOverlayView2 != null) {
            ovalLivenessOverlayView2.cancel();
        }
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Common.LIVENESS_VERSION.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[Common.LIVENESS_VERSION.PASSIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Common.LIVENESS_VERSION.SEMI_ACTIVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Common.LIVENESS_VERSION.ACTIVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

