/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ParsingException;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1String;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.io.Streams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public abstract class ASN1BitString
extends ASN1Primitive
implements ASN1String {
    private static final char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public final byte[] data;
    public final int padBits;

    public static int getPadBits(int n) {
        int n2 = 0;
        for (int k = 3; k >= 0; --k) {
            if (k != 0) {
                int n3 = n >> k * 8;
                if (n3 == 0) continue;
                n2 = n3 & 0xFF;
                break;
            }
            if (n == 0) continue;
            n2 = n & 0xFF;
            break;
        }
        if (n2 == 0) {
            return 0;
        }
        n = 1;
        while (((n2 <<= 1) & 0xFF) != 0) {
            ++n;
        }
        return 8 - n;
    }

    public static byte[] getBytes(int n) {
        if (n == 0) {
            return new byte[0];
        }
        int n2 = 4;
        for (int k = 3; k >= 1 && (n & 255 << k * 8) == 0; --k) {
            --n2;
        }
        byte[] byArray = new byte[n2];
        for (int k = 0; k < n2; ++k) {
            byArray[k] = (byte)(n >> k * 8 & 0xFF);
        }
        return byArray;
    }

    public ASN1BitString(byte by, int n) {
        if (n <= 7 && n >= 0) {
            ASN1BitString aSN1BitString = object;
            byte[] byArray = new byte[1];
            Object object = byArray;
            byArray[0] = by;
            aSN1BitString.data = (byte[])object;
            aSN1BitString.padBits = n;
            return;
        }
        throw new IllegalArgumentException("pad bits cannot be greater than 7 or less than 0");
    }

    public ASN1BitString(byte[] byArray, int n) {
        if (byArray != null) {
            if (byArray.length == 0 && n != 0) {
                throw new IllegalArgumentException("zero length data with non-zero pad bits");
            }
            if (n <= 7 && n >= 0) {
                this.data = Arrays.clone(byArray);
                this.padBits = n;
                return;
            }
            throw new IllegalArgumentException("pad bits cannot be greater than 7 or less than 0");
        }
        throw new NullPointerException("'data' cannot be null");
    }

    public static ASN1BitString fromInputStream(int n, InputStream inputStream) {
        if (n >= 1) {
            int n2 = n;
            n = inputStream.read();
            int n3 = n2 - 1;
            byte[] byArray = new byte[n3];
            if (n3 != 0) {
                if (Streams.readFully(inputStream, byArray) == n3) {
                    if (n > 0 && n < 8) {
                        byte by = byArray[n3 - 1];
                        if (by != (byte)(by & 255 << n)) {
                            return new DLBitString(byArray, n);
                        }
                    }
                } else {
                    throw new EOFException("EOF encountered in middle of BIT STRING");
                }
            }
            return new DERBitString(byArray, n);
        }
        throw new IllegalArgumentException("truncated BIT STRING detected");
    }

    @Override
    public String getString() {
        byte[] byArray;
        StringBuffer stringBuffer;
        ASN1BitString aSN1BitString = stringBuffer2;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer("#");
        try {
            byArray = aSN1BitString.getEncoded();
        }
        catch (IOException iOException) {
            throw new ASN1ParsingException(b.a(iOException, b.b.a("Internal error encoding BitString: ")), iOException);
        }
        for (int k = 0; k != byArray.length; ++k) {
            char[] cArray = table;
            stringBuffer2.append(cArray[byArray[k] >>> 4 & 0xF]);
            stringBuffer2.append(table[byArray[k] & 0xF]);
        }
        return stringBuffer2.toString();
    }

    public int intValue() {
        int n = 0;
        int n2 = Math.min(4, this.data.length - 1);
        for (int k = 0; k < n2; ++k) {
            n |= (this.data[k] & 0xFF) << k * 8;
        }
        if (n2 >= 0 && n2 < 4) {
            n |= ((byte)(this.data[n2] & 255 << this.padBits) & 0xFF) << n2 * 8;
        }
        return n;
    }

    public byte[] getOctets() {
        if (this.padBits == 0) {
            return Arrays.clone(this.data);
        }
        throw new IllegalStateException("attempt to get non-octet aligned data from BIT STRING");
    }

    public byte[] getBytes() {
        byte[] byArray = this.data;
        if (this.data.length == 0) {
            return byArray;
        }
        byte[] byArray2 = Arrays.clone(byArray);
        int n = this.data.length - 1;
        byArray2[n] = (byte)(byArray2[n] & 255 << this.padBits);
        return byArray2;
    }

    public int getPadBits() {
        return this.padBits;
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public int hashCode() {
        byte[] byArray = this.data;
        int n = this.data.length + -1;
        if (n < 0) {
            return 1;
        }
        byte by = (byte)(byArray[n] & 255 << this.padBits);
        return Arrays.hashCode(byArray, 0, n) * 257 ^ by ^ this.padBits;
    }

    @Override
    public boolean asn1Equals(ASN1Primitive object) {
        if (!(object instanceof ASN1BitString)) {
            return false;
        }
        object = (ASN1BitString)object;
        if (this.padBits != ((ASN1BitString)object).padBits) {
            return false;
        }
        byte[] byArray = this.data;
        int n = this.data.length;
        object = ((ASN1BitString)object).data;
        if (n != ((Object)object).length) {
            return false;
        }
        if ((n += -1) < 0) {
            return true;
        }
        for (int k = 0; k < n; ++k) {
            if (byArray[k] == object[k]) continue;
            return false;
        }
        int n2 = this.padBits;
        return (byte)(byArray[n] & 255 << n2) == (byte)(object[n] & 255 << n2);
    }

    public ASN1Primitive getLoadedObject() {
        return this.toASN1Primitive();
    }

    @Override
    public ASN1Primitive toDERObject() {
        ASN1BitString aSN1BitString = object;
        Object object = aSN1BitString.data;
        return new DERBitString((byte[])object, aSN1BitString.padBits);
    }

    @Override
    public ASN1Primitive toDLObject() {
        ASN1BitString aSN1BitString = object;
        Object object = aSN1BitString.data;
        return new DLBitString((byte[])object, aSN1BitString.padBits);
    }

    @Override
    public abstract void encode(ASN1OutputStream var1, boolean var2);
}

