/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ocsp;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1GeneralizedTime;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ocsp.ResponderID;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509Extensions;

public class ResponseData
extends ASN1Object {
    private static final ASN1Integer V1 = new ASN1Integer(0L);
    private boolean versionPresent;
    private ASN1Integer version;
    private ResponderID responderID;
    private ASN1GeneralizedTime producedAt;
    private ASN1Sequence responses;
    private Extensions responseExtensions;

    public ResponseData(ASN1Integer aSN1Integer, ResponderID responderID, ASN1GeneralizedTime aSN1GeneralizedTime, ASN1Sequence aSN1Sequence, Extensions extensions) {
        this.version = aSN1Integer;
        this.responderID = responderID;
        this.producedAt = aSN1GeneralizedTime;
        this.responses = aSN1Sequence;
        this.responseExtensions = extensions;
    }

    public ResponseData(ResponderID responderID, ASN1GeneralizedTime aSN1GeneralizedTime, ASN1Sequence aSN1Sequence, X509Extensions aSN1Object) {
        ResponseData responseData = aSN1Object2;
        ASN1Object aSN1Object2 = V1;
        aSN1GeneralizedTime = ASN1GeneralizedTime.getInstance(aSN1GeneralizedTime);
        aSN1Object = Extensions.getInstance(aSN1Object);
        responseData((ASN1Integer)aSN1Object2, responderID, aSN1GeneralizedTime, aSN1Sequence, (Extensions)aSN1Object);
    }

    public ResponseData(ResponderID responderID, ASN1GeneralizedTime aSN1GeneralizedTime, ASN1Sequence aSN1Sequence, Extensions extensions) {
        this(V1, responderID, aSN1GeneralizedTime, aSN1Sequence, extensions);
    }

    private ResponseData(ASN1Sequence aSN1Sequence) {
        int n = 0;
        if (aSN1Sequence.getObjectAt(0) instanceof ASN1TaggedObject && ((ASN1TaggedObject)aSN1Sequence.getObjectAt(0)).getTagNo() == 0) {
            this.versionPresent = true;
            this.version = ASN1Integer.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(0), true);
            n = 1;
        } else {
            this.version = V1;
        }
        this.responderID = ResponderID.getInstance(aSN1Sequence.getObjectAt(n++));
        this.producedAt = ASN1GeneralizedTime.getInstance(aSN1Sequence.getObjectAt(n++));
        this.responses = (ASN1Sequence)aSN1Sequence.getObjectAt(n++);
        if (aSN1Sequence.size() > n) {
            this.responseExtensions = Extensions.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(n), true);
        }
    }

    public static ResponseData getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return ResponseData.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static ResponseData getInstance(Object object) {
        if (object instanceof ResponseData) {
            return (ResponseData)object;
        }
        if (object != null) {
            return new ResponseData(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public ResponderID getResponderID() {
        return this.responderID;
    }

    public ASN1GeneralizedTime getProducedAt() {
        return this.producedAt;
    }

    public ASN1Sequence getResponses() {
        return this.responses;
    }

    public Extensions getResponseExtensions() {
        return this.responseExtensions;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        DERTaggedObject dERTaggedObject;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(5);
        if (aSN1Object.versionPresent || !aSN1Object.version.equals(V1)) {
            DERTaggedObject dERTaggedObject2;
            dERTaggedObject = dERTaggedObject2;
            ASN1Integer aSN1Integer = aSN1Object.version;
            dERTaggedObject2 = new DERTaggedObject(true, 0, aSN1Integer);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        aSN1EncodableVector2.add(aSN1Object.responderID);
        aSN1EncodableVector2.add(aSN1Object.producedAt);
        aSN1EncodableVector2.add(aSN1Object.responses);
        ASN1Object aSN1Object = aSN1Object.responseExtensions;
        if (aSN1Object != null) {
            DERTaggedObject dERTaggedObject3;
            dERTaggedObject = dERTaggedObject3;
            dERTaggedObject3 = new DERTaggedObject(true, 1, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

