/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.style;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ParsingException;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERUTF8String;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.AttributeTypeAndValue;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.RDN;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500NameStyle;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.style.IETFUtils;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class AbstractX500NameStyle
implements X500NameStyle {
    public static Hashtable copyHashTable(Hashtable hashtable) {
        Hashtable hashtable2;
        Hashtable hashtable3 = hashtable2;
        hashtable2 = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            hashtable3.put(k, hashtable.get(k));
        }
        return hashtable3;
    }

    private int calcHashCode(ASN1Encodable aSN1Encodable) {
        return IETFUtils.canonicalString(aSN1Encodable).hashCode();
    }

    private boolean foundMatch(boolean n, RDN rDN, RDN[] rDNArray) {
        if (n != 0) {
            for (n = rDNArray.length - 1; n >= 0; --n) {
                RDN rDN2 = rDNArray[n];
                if (rDN2 == null || !this.rdnAreEqual(rDN, rDN2)) continue;
                rDNArray[n] = null;
                return true;
            }
        } else {
            for (n = 0; n != rDNArray.length; ++n) {
                RDN rDN3 = rDNArray[n];
                if (rDN3 == null || !this.rdnAreEqual(rDN, rDN3)) continue;
                rDNArray[n] = null;
                return true;
            }
        }
        return false;
    }

    @Override
    public int calculateHashCode(X500Name x500Name) {
        int n = 0;
        RDN[] rDNArray = x500Name.getRDNs();
        for (int k = 0; k != rDNArray.length; ++k) {
            if (rDNArray[k].isMultiValued()) {
                AttributeTypeAndValue[] attributeTypeAndValueArray = rDNArray[k].getTypesAndValues();
                for (int i2 = 0; i2 != attributeTypeAndValueArray.length; ++i2) {
                    n = n ^ attributeTypeAndValueArray[i2].getType().hashCode() ^ this.calcHashCode(attributeTypeAndValueArray[i2].getValue());
                }
                continue;
            }
            n = n ^ rDNArray[k].getFirst().getType().hashCode() ^ this.calcHashCode(rDNArray[k].getFirst().getValue());
        }
        return n;
    }

    @Override
    public ASN1Encodable stringToValue(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        if (string.length() != 0 && string.charAt(0) == '#') {
            try {
                return IETFUtils.valueFromHexString(string, 1);
            }
            catch (IOException iOException) {
                throw new ASN1ParsingException(b.a("can't recode value for oid ").append(aSN1ObjectIdentifier.getId()).toString());
            }
        }
        if (string.length() != 0 && string.charAt(0) == '\\') {
            string = string.substring(1);
        }
        return this.encodeStringValue(aSN1ObjectIdentifier, string);
    }

    public ASN1Encodable encodeStringValue(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        return new DERUTF8String(string);
    }

    @Override
    public boolean areEqual(X500Name rDNArray, X500Name rDNArray2) {
        if ((rDNArray = rDNArray.getRDNs()).length != (rDNArray2 = rDNArray2.getRDNs()).length) {
            return false;
        }
        boolean bl = false;
        if (rDNArray[0].getFirst() != null && rDNArray2[0].getFirst() != null) {
            bl = rDNArray[0].getFirst().getType().equals(rDNArray2[0].getFirst().getType()) ^ true;
        }
        for (int k = 0; k != rDNArray.length; ++k) {
            if (this.foundMatch(bl, rDNArray[k], rDNArray2)) continue;
            return false;
        }
        return true;
    }

    public boolean rdnAreEqual(RDN rDN, RDN rDN2) {
        return IETFUtils.rDNAreEqual(rDN, rDN2);
    }
}

