/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509;

import c.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.DisplayText;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.NoticeReference;

public class UserNotice
extends ASN1Object {
    private final NoticeReference noticeRef;
    private final DisplayText explicitText;

    public UserNotice(NoticeReference noticeReference, DisplayText displayText) {
        this.noticeRef = noticeReference;
        this.explicitText = displayText;
    }

    public UserNotice(NoticeReference noticeReference, String string) {
        DisplayText displayText;
        UserNotice userNotice = aSN1Object;
        ASN1Object aSN1Object = displayText;
        displayText = new DisplayText(string);
        userNotice(noticeReference, (DisplayText)aSN1Object);
    }

    private UserNotice(ASN1Sequence aSN1Sequence) {
        block8: {
            block6: {
                block7: {
                    block5: {
                        if (aSN1Sequence.size() != 2) break block5;
                        this.noticeRef = NoticeReference.getInstance(aSN1Sequence.getObjectAt(0));
                        this.explicitText = DisplayText.getInstance(aSN1Sequence.getObjectAt(1));
                        break block6;
                    }
                    if (aSN1Sequence.size() != 1) break block7;
                    if (aSN1Sequence.getObjectAt(0).toASN1Primitive() instanceof ASN1Sequence) {
                        UserNotice userNotice = this;
                        userNotice.noticeRef = NoticeReference.getInstance(aSN1Sequence.getObjectAt(0));
                        userNotice.explicitText = null;
                    } else {
                        UserNotice userNotice = this;
                        userNotice.explicitText = DisplayText.getInstance(aSN1Sequence.getObjectAt(0));
                        userNotice.noticeRef = null;
                    }
                    break block6;
                }
                if (aSN1Sequence.size() != 0) break block8;
                UserNotice userNotice = this;
                userNotice.noticeRef = null;
                userNotice.explicitText = null;
            }
            return;
        }
        throw new IllegalArgumentException(b.a(aSN1Sequence, b.b.a("Bad sequence size: ")));
    }

    public static UserNotice getInstance(Object object) {
        if (object instanceof UserNotice) {
            return (UserNotice)object;
        }
        if (object != null) {
            return new UserNotice(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public NoticeReference getNoticeRef() {
        return this.noticeRef;
    }

    public DisplayText getExplicitText() {
        return this.explicitText;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        DisplayText displayText;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(2);
        NoticeReference noticeReference = this.noticeRef;
        if (noticeReference != null) {
            aSN1EncodableVector2.add(noticeReference);
        }
        if ((displayText = this.explicitText) != null) {
            aSN1EncodableVector2.add(displayText);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

