/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9;

import c.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9FieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9FieldID;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class X9Curve
extends ASN1Object
implements X9ObjectIdentifiers {
    private ECCurve curve;
    private byte[] seed;
    private ASN1ObjectIdentifier fieldIdentifier;

    public X9Curve(ECCurve eCCurve) {
        this(eCCurve, null);
    }

    public X9Curve(ECCurve eCCurve, byte[] byArray) {
        this.fieldIdentifier = null;
        this.curve = eCCurve;
        this.seed = Arrays.clone(byArray);
        this.setFieldIdentifier();
    }

    public X9Curve(X9FieldID object, BigInteger bigInteger, BigInteger bigInteger2, ASN1Sequence aSN1Sequence) {
        block6: {
            block9: {
                block5: {
                    ECCurve.F2m f2m;
                    BigInteger bigInteger3;
                    BigInteger bigInteger4;
                    int n;
                    int n2;
                    int n3;
                    Object object2;
                    int n4;
                    block8: {
                        block7: {
                            block4: {
                                BigInteger bigInteger5;
                                BigInteger bigInteger6;
                                this.fieldIdentifier = null;
                                this.fieldIdentifier = ((X9FieldID)object).getIdentifier();
                                if (!this.fieldIdentifier.equals(X9ObjectIdentifiers.prime_field)) break block4;
                                object = ((ASN1Integer)((X9FieldID)object).getParameters()).getValue();
                                BigInteger bigInteger7 = bigInteger6;
                                bigInteger6 = new BigInteger(1, a.a(aSN1Sequence, 0));
                                BigInteger bigInteger8 = bigInteger5;
                                bigInteger5 = new BigInteger(1, a.a(aSN1Sequence, 1));
                                this.curve = new ECCurve.Fp((BigInteger)object, bigInteger7, bigInteger8, bigInteger, bigInteger2);
                                break block5;
                            }
                            if (!this.fieldIdentifier.equals(X9ObjectIdentifiers.characteristic_two_field)) break block6;
                            object = ASN1Sequence.getInstance(((X9FieldID)object).getParameters());
                            n4 = ((ASN1Integer)((ASN1Sequence)object).getObjectAt(0)).intValueExact();
                            object2 = (ASN1ObjectIdentifier)((ASN1Sequence)object).getObjectAt(1);
                            n3 = 0;
                            n2 = 0;
                            if (!((ASN1Primitive)object2).equals(X9ObjectIdentifiers.tpBasis)) break block7;
                            n = ASN1Integer.getInstance(((ASN1Sequence)object).getObjectAt(2)).intValueExact();
                            break block8;
                        }
                        if (!((ASN1Primitive)object2).equals(X9ObjectIdentifiers.ppBasis)) break block9;
                        ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance(((ASN1Sequence)object).getObjectAt(2));
                        n = ASN1Integer.getInstance(aSN1Sequence2.getObjectAt(0)).intValueExact();
                        n3 = ASN1Integer.getInstance(aSN1Sequence2.getObjectAt(1)).intValueExact();
                        n2 = ASN1Integer.getInstance(aSN1Sequence2.getObjectAt(2)).intValueExact();
                    }
                    object2 = bigInteger4;
                    bigInteger4 = new BigInteger(1, a.a(aSN1Sequence, 0));
                    BigInteger bigInteger9 = bigInteger3;
                    bigInteger3 = new BigInteger(1, a.a(aSN1Sequence, 1));
                    ECCurve.F2m f2m2 = f2m;
                    f2m = new ECCurve.F2m(n4, n, n3, n2, (BigInteger)object2, bigInteger9, bigInteger, bigInteger2);
                    this.curve = f2m2;
                }
                if (aSN1Sequence.size() == 3) {
                    this.seed = ((DERBitString)aSN1Sequence.getObjectAt(2)).getBytes();
                }
                return;
            }
            throw new IllegalArgumentException("This type of EC basis is not implemented");
        }
        throw new IllegalArgumentException("This type of ECCurve is not implemented");
    }

    private void setFieldIdentifier() {
        block4: {
            block3: {
                block2: {
                    if (!ECAlgorithms.isFpCurve(this.curve)) break block2;
                    this.fieldIdentifier = X9ObjectIdentifiers.prime_field;
                    break block3;
                }
                if (!ECAlgorithms.isF2mCurve(this.curve)) break block4;
                this.fieldIdentifier = X9ObjectIdentifiers.characteristic_two_field;
            }
            return;
        }
        throw new IllegalArgumentException("This type of ECCurve is not implemented");
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    public byte[] getSeed() {
        return Arrays.clone(this.seed);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(3);
        if (((X9Curve)object).fieldIdentifier.equals(X9ObjectIdentifiers.prime_field)) {
            ASN1EncodableVector aSN1EncodableVector3 = aSN1EncodableVector2;
            aSN1EncodableVector3.add(new X9FieldElement(((X9Curve)object).curve.getA()).toASN1Primitive());
            aSN1EncodableVector3.add(new X9FieldElement(((X9Curve)object).curve.getB()).toASN1Primitive());
        } else if (((X9Curve)object).fieldIdentifier.equals(X9ObjectIdentifiers.characteristic_two_field)) {
            ASN1EncodableVector aSN1EncodableVector4 = aSN1EncodableVector2;
            aSN1EncodableVector4.add(new X9FieldElement(((X9Curve)object).curve.getA()).toASN1Primitive());
            aSN1EncodableVector4.add(new X9FieldElement(((X9Curve)object).curve.getB()).toASN1Primitive());
        }
        Object object = ((X9Curve)object).seed;
        if (((X9Curve)object).seed != null) {
            DERBitString dERBitString;
            DERBitString dERBitString2 = dERBitString;
            dERBitString = new DERBitString((byte[])object);
            aSN1EncodableVector2.add(dERBitString2);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

