/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DESParameters;

public class DESedeParameters
extends DESParameters {
    public static final int DES_EDE_KEY_LENGTH = 24;

    public DESedeParameters(byte[] byArray) {
        super(byArray);
        if (!DESedeParameters.isWeakKey(byArray, 0, byArray.length)) {
            return;
        }
        throw new IllegalArgumentException("attempt to create weak DESede key");
    }

    public static boolean isWeakKey(byte[] byArray, int n, int n2) {
        while (n < n2) {
            if (DESParameters.isWeakKey(byArray, n)) {
                return true;
            }
            n += 8;
        }
        return false;
    }

    public static boolean isWeakKey(byte[] byArray, int n) {
        return DESedeParameters.isWeakKey(byArray, n, byArray.length - n);
    }

    public static boolean isRealEDEKey(byte[] byArray, int n) {
        return byArray.length == 16 ? DESedeParameters.isReal2Key(byArray, n) : DESedeParameters.isReal3Key(byArray, n);
    }

    public static boolean isReal2Key(byte[] byArray, int n) {
        boolean bl = false;
        for (int k = n; k != n + 8; ++k) {
            if (byArray[k] == byArray[k + 8]) continue;
            bl = true;
        }
        return bl;
    }

    public static boolean isReal3Key(byte[] byArray, int n) {
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        for (int k = n; k != n + 8; ++k) {
            byte by = byArray[k];
            byte by2 = byArray[k + 8];
            boolean bl3 = by != by2;
            byte by3 = by;
            bl |= bl3;
            by = byArray[k + 16];
            bl3 = by3 != by;
            bl2 |= bl3;
            by = by2 != by ? (byte)1 : 0;
            n2 |= by;
        }
        return bl && bl2 && n2 != 0;
    }
}

