/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.g;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public abstract class Primes {
    public static final int SMALL_FACTOR_LIMIT = 211;
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final BigInteger THREE = BigInteger.valueOf(3L);

    public static STOutput generateSTRandomPrime(Digest digest, int n, byte[] byArray) {
        if (digest != null) {
            if (n >= 2) {
                if (byArray != null && byArray.length != 0) {
                    return Primes.implSTRandomPrime(digest, n, Arrays.clone(byArray));
                }
                throw new IllegalArgumentException("'inputSeed' cannot be null or empty");
            }
            throw new IllegalArgumentException("'length' must be >= 2");
        }
        throw new IllegalArgumentException("'hash' cannot be null");
    }

    public static MROutput enhancedMRProbablePrimeTest(BigInteger bigInteger, SecureRandom serializable, int n) {
        Primes.checkCandidate(bigInteger, "candidate");
        if (serializable != null) {
            if (n >= 1) {
                if (bigInteger.bitLength() == 2) {
                    return MROutput.probablyPrime();
                }
                if (!bigInteger.testBit(0)) {
                    return MROutput.provablyCompositeWithFactor(Primes.TWO);
                }
                BigInteger bigInteger2 = bigInteger.subtract(ONE);
                BigInteger bigInteger3 = bigInteger.subtract(TWO);
                int n2 = bigInteger2.getLowestSetBit();
                BigInteger bigInteger4 = bigInteger2.shiftRight(n2);
                for (int k = 0; k < n; ++k) {
                    BigInteger bigInteger5;
                    boolean bl;
                    BigInteger bigInteger6;
                    block12: {
                        BigInteger bigInteger7;
                        bigInteger6 = BigIntegers.createRandomInRange(TWO, bigInteger3, serializable);
                        BigInteger bigInteger8 = bigInteger6.gcd(bigInteger);
                        if (bigInteger8.compareTo(bigInteger7 = ONE) > 0) {
                            return MROutput.provablyCompositeWithFactor(bigInteger8);
                        }
                        if ((bigInteger6 = bigInteger6.modPow(bigInteger4, bigInteger)).equals(bigInteger7) || bigInteger6.equals(bigInteger2)) continue;
                        bl = false;
                        for (int i2 = 1; i2 < n2; ++i2) {
                            bigInteger5 = bigInteger6.modPow(TWO, bigInteger);
                            if (bigInteger5.equals(bigInteger2)) {
                                bl = true;
                            } else if (!bigInteger5.equals(ONE)) {
                                bigInteger6 = bigInteger5;
                                continue;
                            }
                            break block12;
                        }
                        bigInteger5 = bigInteger6;
                    }
                    if (bl) continue;
                    serializable = ONE;
                    if (!bigInteger5.equals(serializable) && (bigInteger6 = bigInteger5.modPow(TWO, bigInteger)).equals(serializable)) {
                        bigInteger6 = bigInteger5;
                    }
                    if ((bigInteger = bigInteger6.subtract((BigInteger)serializable).gcd(bigInteger)).compareTo((BigInteger)serializable) > 0) {
                        return MROutput.provablyCompositeWithFactor(bigInteger);
                    }
                    return MROutput.provablyCompositeNotPrimePower();
                }
                return MROutput.probablyPrime();
            }
            throw new IllegalArgumentException("'iterations' must be > 0");
        }
        throw new IllegalArgumentException("'random' cannot be null");
    }

    public static boolean hasAnySmallFactors(BigInteger bigInteger) {
        BigInteger bigInteger2 = bigInteger;
        Primes.checkCandidate(bigInteger2, "candidate");
        return Primes.implHasAnySmallFactors(bigInteger2);
    }

    public static boolean isMRProbablePrime(BigInteger bigInteger, SecureRandom secureRandom, int n) {
        Primes.checkCandidate(bigInteger, "candidate");
        if (secureRandom != null) {
            if (n >= 1) {
                if (bigInteger.bitLength() == 2) {
                    return true;
                }
                if (!bigInteger.testBit(0)) {
                    return false;
                }
                BigInteger bigInteger2 = bigInteger.subtract(ONE);
                BigInteger bigInteger3 = bigInteger.subtract(TWO);
                int n2 = bigInteger2.getLowestSetBit();
                BigInteger bigInteger4 = bigInteger2.shiftRight(n2);
                for (int k = 0; k < n; ++k) {
                    BigInteger bigInteger5 = BigIntegers.createRandomInRange(TWO, bigInteger3, secureRandom);
                    if (Primes.implMRProbablePrimeToBase(bigInteger, bigInteger2, bigInteger4, n2, bigInteger5)) continue;
                    return false;
                }
                return true;
            }
            throw new IllegalArgumentException("'iterations' must be > 0");
        }
        throw new IllegalArgumentException("'random' cannot be null");
    }

    public static boolean isMRProbablePrimeToBase(BigInteger bigInteger, BigInteger bigInteger2) {
        Primes.checkCandidate(bigInteger, "candidate");
        Primes.checkCandidate(bigInteger2, "base");
        BigInteger bigInteger3 = ONE;
        if (bigInteger2.compareTo(bigInteger.subtract(bigInteger3)) < 0) {
            if (bigInteger.bitLength() == 2) {
                return true;
            }
            BigInteger bigInteger4 = bigInteger;
            BigInteger bigInteger5 = bigInteger4.subtract(bigInteger3);
            int n = bigInteger5.getLowestSetBit();
            return Primes.implMRProbablePrimeToBase(bigInteger4, bigInteger5, bigInteger5.shiftRight(n), n, bigInteger2);
        }
        throw new IllegalArgumentException("'base' must be < ('candidate' - 1)");
    }

    private static void checkCandidate(BigInteger bigInteger, String string) {
        if (bigInteger != null && bigInteger.signum() >= 1 && bigInteger.bitLength() >= 2) {
            return;
        }
        throw new IllegalArgumentException(g.a("'", string, "' must be non-null and >= 2"));
    }

    private static boolean implHasAnySmallFactors(BigInteger bigInteger) {
        int n = bigInteger.mod(BigInteger.valueOf(223092870)).intValue();
        if (n % 2 != 0 && n % 3 != 0 && n % 5 != 0 && n % 7 != 0 && n % 11 != 0 && n % 13 != 0 && n % 17 != 0 && n % 19 != 0 && n % 23 != 0) {
            n = bigInteger.mod(BigInteger.valueOf(58642669)).intValue();
            if (n % 29 != 0 && n % 31 != 0 && n % 37 != 0 && n % 41 != 0 && n % 43 != 0) {
                n = bigInteger.mod(BigInteger.valueOf(600662303)).intValue();
                if (n % 47 != 0 && n % 53 != 0 && n % 59 != 0 && n % 61 != 0 && n % 67 != 0) {
                    n = bigInteger.mod(BigInteger.valueOf(33984931)).intValue();
                    if (n % 71 != 0 && n % 73 != 0 && n % 79 != 0 && n % 83 != 0) {
                        n = bigInteger.mod(BigInteger.valueOf(89809099)).intValue();
                        if (n % 89 != 0 && n % 97 != 0 && n % 101 != 0 && n % 103 != 0) {
                            n = bigInteger.mod(BigInteger.valueOf(167375713)).intValue();
                            if (n % 107 != 0 && n % 109 != 0 && n % 113 != 0 && n % 127 != 0) {
                                n = bigInteger.mod(BigInteger.valueOf(371700317)).intValue();
                                if (n % 131 != 0 && n % 137 != 0 && n % 139 != 0 && n % 149 != 0) {
                                    n = bigInteger.mod(BigInteger.valueOf(645328247)).intValue();
                                    if (n % 151 != 0 && n % 157 != 0 && n % 163 != 0 && n % 167 != 0) {
                                        n = bigInteger.mod(BigInteger.valueOf(1070560157)).intValue();
                                        if (n % 173 != 0 && n % 179 != 0 && n % 181 != 0 && n % 191 != 0) {
                                            int n2 = bigInteger.mod(BigInteger.valueOf(1596463769)).intValue();
                                            return n2 % 193 == 0 || n2 % 197 == 0 || n2 % 199 == 0 || n2 % 211 == 0;
                                            {
                                            }
                                        }
                                        return true;
                                    }
                                    return true;
                                }
                                return true;
                            }
                            return true;
                        }
                        return true;
                    }
                    return true;
                }
                return true;
            }
            return true;
        }
        return true;
    }

    private static boolean implMRProbablePrimeToBase(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n, BigInteger bigInteger4) {
        if (!(bigInteger3 = bigInteger4.modPow(bigInteger3, bigInteger)).equals(ONE) && !bigInteger3.equals(bigInteger2)) {
            boolean bl = false;
            for (int k = 1; k < n; ++k) {
                if ((bigInteger3 = bigInteger3.modPow(TWO, bigInteger)).equals(bigInteger2)) {
                    bl = true;
                    break;
                }
                if (!bigInteger3.equals(ONE)) continue;
                return false;
            }
            return bl;
        }
        return true;
    }

    private static STOutput implSTRandomPrime(Digest digest, int n, byte[] object) {
        int n2 = digest.getDigestSize();
        if (n < 33) {
            int n3 = n2;
            n2 = 0;
            byte[] byArray = new byte[n3];
            byte[] byArray2 = new byte[n3];
            do {
                Primes.hash(digest, (byte[])object, byArray, 0);
                Primes.inc((byte[])object, 1);
                Primes.hash(digest, (byte[])object, byArray2, 0);
                Primes.inc((byte[])object, 1);
                ++n2;
                long l = (long)((Primes.extract32(byArray) ^ Primes.extract32(byArray2)) & -1 >>> 32 - n | (1 << n - 1 | 1)) & 0xFFFFFFFFL;
                if (!Primes.isPrime32(l)) continue;
                return new STOutput(BigInteger.valueOf(l), (byte[])object, n2, null);
            } while (n2 <= n * 4);
            throw new IllegalStateException("Too many iterations in Shawe-Taylor Random_Prime Routine");
        }
        STOutput sTOutput = Primes.implSTRandomPrime(digest, (n + 3) / 2, (byte[])object);
        object = sTOutput.getPrime();
        byte[] byArray = sTOutput.getPrimeSeed();
        int n4 = sTOutput.getPrimeGenCounter();
        int n5 = n2 * 8;
        int n6 = n - 1;
        n5 = n6 / n5 + 1;
        BigInteger bigInteger = ONE;
        BigInteger bigInteger2 = ((BigInteger)object).shiftLeft(1);
        BigInteger bigInteger3 = Primes.hashGen(digest, byArray, n5).mod(bigInteger.shiftLeft(n6)).setBit(n6).subtract(bigInteger).divide(bigInteger2).add(bigInteger).shiftLeft(1);
        int n7 = 0;
        bigInteger = bigInteger3.multiply((BigInteger)object).add(bigInteger);
        int n8 = n4;
        while (true) {
            if (bigInteger.bitLength() > n) {
                bigInteger = ONE;
                bigInteger3 = bigInteger.shiftLeft(n6).subtract(bigInteger).divide(bigInteger2).add(bigInteger).shiftLeft(1);
                bigInteger = bigInteger3.multiply((BigInteger)object).add(bigInteger);
            }
            ++n8;
            if (!Primes.implHasAnySmallFactors(bigInteger)) {
                BigInteger bigInteger4;
                bigInteger3 = bigInteger3.add(BigInteger.valueOf(n7));
                n7 = 0;
                BigInteger bigInteger5 = Primes.hashGen(digest, byArray, n5).mod(bigInteger.subtract(THREE)).add(TWO).modPow(bigInteger3, bigInteger);
                if (bigInteger.gcd(bigInteger5.subtract(bigInteger4 = ONE)).equals(bigInteger4) && bigInteger5.modPow((BigInteger)object, bigInteger).equals(bigInteger4)) {
                    return new STOutput(bigInteger, byArray, n8, null);
                }
            } else {
                Primes.inc(byArray, n5);
            }
            if (n8 >= n * 4 + n4) break;
            n7 += 2;
            bigInteger = bigInteger.add(bigInteger2);
        }
        throw new IllegalStateException("Too many iterations in Shawe-Taylor Random_Prime Routine");
    }

    private static int extract32(byte[] byArray) {
        int n = 0;
        int n2 = Math.min(4, byArray.length);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n;
            n = n3 + 1;
            n3 = n4 | (byArray[byArray.length - n] & 0xFF) << n3 * 8;
            int n5 = n;
            n = n3;
            n3 = n5;
        }
        return n;
    }

    private static void hash(Digest digest, byte[] byArray, byte[] byArray2, int n) {
        Digest digest2 = digest;
        int n2 = byArray.length;
        digest2.update(byArray, 0, n2);
        digest2.doFinal(byArray2, n);
    }

    private static BigInteger hashGen(Digest digest, byte[] byArray, int n) {
        int n2 = digest.getDigestSize();
        int n3 = n * n2;
        byte[] byArray2 = new byte[n3];
        for (int k = 0; k < n; ++k) {
            Primes.hash(digest, byArray, byArray2, n3 -= n2);
            Primes.inc(byArray, 1);
        }
        return new BigInteger(1, byArray2);
    }

    private static void inc(byte[] byArray, int n) {
        int n2 = byArray.length;
        while (n > 0 && (n2 += -1) >= 0) {
            byArray[n2] = (byte)(n += byArray[n2] & 0xFF);
            n >>>= 8;
        }
    }

    private static boolean isPrime32(long l) {
        if (l >>> 32 == 0L) {
            long l2 = l - 5L;
            long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
            if (l3 <= 0) {
                return l == 2L || l == 3L || l3 == false;
            }
            if ((l & 1L) != 0L && l % 3L != 0L && l % 5L != 0L) {
                l3 = 8;
                long[] lArray = new long[8];
                long[] lArray2 = lArray;
                lArray[0] = 1L;
                lArray[1] = 7L;
                lArray[2] = 11L;
                lArray[3] = 13L;
                lArray[4] = 17L;
                lArray[5] = 19L;
                lArray[6] = 23L;
                lArray[7] = 29L;
                long l4 = 0L;
                int n = 1;
                while (true) {
                    if (n < l3) {
                        if (l % (l4 + lArray2[n]) == 0L) {
                            return l < 30L;
                        }
                        ++n;
                        continue;
                    }
                    if ((l4 += 30L) * l4 >= l) {
                        return true;
                    }
                    n = 0;
                }
            }
            return false;
        }
        throw new IllegalArgumentException("Size limit exceeded");
    }

    public static class STOutput {
        private BigInteger prime;
        private byte[] primeSeed;
        private int primeGenCounter;

        private STOutput(BigInteger bigInteger, byte[] byArray, int n) {
            this.prime = bigInteger;
            this.primeSeed = byArray;
            this.primeGenCounter = n;
        }

        public /* synthetic */ STOutput(BigInteger bigInteger, byte[] byArray, int n, 1 var4_4) {
            this(bigInteger, byArray, n);
        }

        public BigInteger getPrime() {
            return this.prime;
        }

        public byte[] getPrimeSeed() {
            return this.primeSeed;
        }

        public int getPrimeGenCounter() {
            return this.primeGenCounter;
        }
    }

    public static class MROutput {
        private boolean provablyComposite;
        private BigInteger factor;

        private static MROutput probablyPrime() {
            return new MROutput(false, null);
        }

        private static MROutput provablyCompositeWithFactor(BigInteger bigInteger) {
            return new MROutput(true, bigInteger);
        }

        private static MROutput provablyCompositeNotPrimePower() {
            return new MROutput(true, null);
        }

        private MROutput(boolean bl, BigInteger bigInteger) {
            this.provablyComposite = bl;
            this.factor = bigInteger;
        }

        public BigInteger getFactor() {
            return this.factor;
        }

        public boolean isProvablyComposite() {
            return this.provablyComposite;
        }

        public boolean isNotPrimePower() {
            return this.provablyComposite && this.factor == null;
        }
    }
}

