/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP128R1Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat128;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecP128R1FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = new BigInteger(1, Hex.decodeStrict("FFFFFFFDFFFFFFFFFFFFFFFFFFFFFFFF"));
    public int[] x;

    public SecP128R1FieldElement(BigInteger bigInteger) {
        if (bigInteger != null && bigInteger.signum() >= 0 && bigInteger.compareTo(Q) < 0) {
            this.x = SecP128R1Field.fromBigInteger(bigInteger);
            return;
        }
        throw new IllegalArgumentException("x value invalid for SecP128R1FieldElement");
    }

    public SecP128R1FieldElement() {
        this.x = Nat128.create();
    }

    public SecP128R1FieldElement(int[] nArray) {
        this.x = nArray;
    }

    @Override
    public boolean isZero() {
        return Nat128.isZero(this.x);
    }

    @Override
    public boolean isOne() {
        return Nat128.isOne(this.x);
    }

    @Override
    public boolean testBitZero() {
        return Nat128.getBit(this.x, 0) == 1;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat128.toBigInteger(this.x);
    }

    @Override
    public String getFieldName() {
        return "SecP128R1Field";
    }

    @Override
    public int getFieldSize() {
        return Q.bitLength();
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        SecP128R1FieldElement secP128R1FieldElement = object;
        Object object = Nat128.create();
        SecP128R1Field.add(secP128R1FieldElement.x, ((SecP128R1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP128R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement addOne() {
        SecP128R1FieldElement secP128R1FieldElement = object;
        Object object = Nat128.create();
        SecP128R1Field.addOne(secP128R1FieldElement.x, (int[])object);
        return new SecP128R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        SecP128R1FieldElement secP128R1FieldElement = object;
        Object object = Nat128.create();
        SecP128R1Field.subtract(secP128R1FieldElement.x, ((SecP128R1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP128R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        SecP128R1FieldElement secP128R1FieldElement = object;
        Object object = Nat128.create();
        SecP128R1Field.multiply(secP128R1FieldElement.x, ((SecP128R1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP128R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat128.create();
        SecP128R1Field.inv(((SecP128R1FieldElement)eCFieldElement).x, nArray);
        SecP128R1Field.multiply(nArray, this.x, nArray);
        return new SecP128R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement negate() {
        SecP128R1FieldElement secP128R1FieldElement = object;
        Object object = Nat128.create();
        SecP128R1Field.negate(secP128R1FieldElement.x, (int[])object);
        return new SecP128R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement square() {
        SecP128R1FieldElement secP128R1FieldElement = object;
        Object object = Nat128.create();
        SecP128R1Field.square(secP128R1FieldElement.x, (int[])object);
        return new SecP128R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement invert() {
        SecP128R1FieldElement secP128R1FieldElement = object;
        Object object = Nat128.create();
        SecP128R1Field.inv(secP128R1FieldElement.x, (int[])object);
        return new SecP128R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement sqrt() {
        int[] nArray = ((SecP128R1FieldElement)object).x;
        if (!Nat128.isZero(((SecP128R1FieldElement)object).x) && !Nat128.isOne(nArray)) {
            int[] nArray2 = nArray;
            int[] nArray3 = Nat128.create();
            Object object = nArray3;
            SecP128R1Field.square(nArray, (int[])object);
            SecP128R1Field.multiply(nArray3, nArray, (int[])object);
            int[] nArray4 = Nat128.create();
            int[] nArray5 = nArray;
            Object object2 = object;
            SecP128R1Field.squareN((int[])object2, 2, nArray4);
            SecP128R1Field.multiply(nArray4, (int[])object2, nArray4);
            nArray = Nat128.create();
            Object object3 = object;
            int[] nArray6 = nArray4;
            SecP128R1Field.squareN(nArray4, 4, nArray);
            SecP128R1Field.multiply(nArray, nArray4, nArray);
            SecP128R1Field.squareN(nArray, 2, nArray4);
            SecP128R1Field.multiply(nArray6, (int[])object, nArray4);
            SecP128R1Field.squareN(nArray6, 10, (int[])object);
            SecP128R1Field.multiply((int[])object3, nArray4, (int[])object);
            SecP128R1Field.squareN((int[])object3, 10, nArray);
            SecP128R1Field.multiply(nArray, nArray4, nArray);
            SecP128R1Field.square(nArray, nArray4);
            SecP128R1Field.multiply(nArray4, nArray5, nArray4);
            SecP128R1Field.squareN(nArray4, 95, nArray4);
            SecP128R1Field.square(nArray4, nArray);
            if (Nat128.eq(nArray2, nArray)) {
                SecP128R1FieldElement secP128R1FieldElement;
                object = secP128R1FieldElement;
                secP128R1FieldElement = new SecP128R1FieldElement(nArray4);
            } else {
                object = null;
            }
            return object;
        }
        return object;
    }

    public boolean equals(Object object) {
        if (object == secP128R1FieldElement2) {
            return true;
        }
        if (!(object instanceof SecP128R1FieldElement)) {
            return false;
        }
        SecP128R1FieldElement secP128R1FieldElement = secP128R1FieldElement2;
        SecP128R1FieldElement secP128R1FieldElement2 = (SecP128R1FieldElement)object;
        return Nat128.eq(secP128R1FieldElement.x, secP128R1FieldElement2.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode(this.x, 0, 4);
    }
}

