/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP192R1Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat192;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecP192R1FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = new BigInteger(1, Hex.decodeStrict("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFF"));
    public int[] x;

    public SecP192R1FieldElement(BigInteger bigInteger) {
        if (bigInteger != null && bigInteger.signum() >= 0 && bigInteger.compareTo(Q) < 0) {
            this.x = SecP192R1Field.fromBigInteger(bigInteger);
            return;
        }
        throw new IllegalArgumentException("x value invalid for SecP192R1FieldElement");
    }

    public SecP192R1FieldElement() {
        this.x = Nat192.create();
    }

    public SecP192R1FieldElement(int[] nArray) {
        this.x = nArray;
    }

    @Override
    public boolean isZero() {
        return Nat192.isZero(this.x);
    }

    @Override
    public boolean isOne() {
        return Nat192.isOne(this.x);
    }

    @Override
    public boolean testBitZero() {
        return Nat192.getBit(this.x, 0) == 1;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat192.toBigInteger(this.x);
    }

    @Override
    public String getFieldName() {
        return "SecP192R1Field";
    }

    @Override
    public int getFieldSize() {
        return Q.bitLength();
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        SecP192R1FieldElement secP192R1FieldElement = object;
        Object object = Nat192.create();
        SecP192R1Field.add(secP192R1FieldElement.x, ((SecP192R1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP192R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement addOne() {
        SecP192R1FieldElement secP192R1FieldElement = object;
        Object object = Nat192.create();
        SecP192R1Field.addOne(secP192R1FieldElement.x, (int[])object);
        return new SecP192R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        SecP192R1FieldElement secP192R1FieldElement = object;
        Object object = Nat192.create();
        SecP192R1Field.subtract(secP192R1FieldElement.x, ((SecP192R1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP192R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        SecP192R1FieldElement secP192R1FieldElement = object;
        Object object = Nat192.create();
        SecP192R1Field.multiply(secP192R1FieldElement.x, ((SecP192R1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP192R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat192.create();
        SecP192R1Field.inv(((SecP192R1FieldElement)eCFieldElement).x, nArray);
        SecP192R1Field.multiply(nArray, this.x, nArray);
        return new SecP192R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement negate() {
        SecP192R1FieldElement secP192R1FieldElement = object;
        Object object = Nat192.create();
        SecP192R1Field.negate(secP192R1FieldElement.x, (int[])object);
        return new SecP192R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement square() {
        SecP192R1FieldElement secP192R1FieldElement = object;
        Object object = Nat192.create();
        SecP192R1Field.square(secP192R1FieldElement.x, (int[])object);
        return new SecP192R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement invert() {
        SecP192R1FieldElement secP192R1FieldElement = object;
        Object object = Nat192.create();
        SecP192R1Field.inv(secP192R1FieldElement.x, (int[])object);
        return new SecP192R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement sqrt() {
        Object object = ((SecP192R1FieldElement)object2).x;
        if (!Nat192.isZero(((SecP192R1FieldElement)object2).x) && !Nat192.isOne(object)) {
            int[] nArray = Nat192.create();
            Object object2 = nArray;
            int[] nArray2 = Nat192.create();
            Object object3 = object2;
            int[] nArray3 = nArray2;
            Object object4 = object2;
            int[] nArray4 = nArray2;
            Object object5 = object2;
            SecP192R1Field.square(object, (int[])object2);
            SecP192R1Field.multiply((int[])object5, object, (int[])object2);
            SecP192R1Field.squareN((int[])object5, 2, nArray2);
            SecP192R1Field.multiply(nArray4, (int[])object5, nArray2);
            SecP192R1Field.squareN(nArray4, 4, (int[])object2);
            SecP192R1Field.multiply((int[])object4, nArray2, (int[])object2);
            SecP192R1Field.squareN((int[])object4, 8, nArray2);
            SecP192R1Field.multiply(nArray3, (int[])object4, nArray2);
            SecP192R1Field.squareN(nArray3, 16, (int[])object2);
            SecP192R1Field.multiply((int[])object3, nArray2, (int[])object2);
            SecP192R1Field.squareN((int[])object3, 32, nArray2);
            SecP192R1Field.multiply(nArray2, (int[])object3, nArray2);
            SecP192R1Field.squareN(nArray2, 64, (int[])object2);
            SecP192R1Field.multiply(nArray, nArray2, (int[])object2);
            SecP192R1Field.squareN(nArray, 62, (int[])object2);
            SecP192R1Field.square(nArray, nArray2);
            if (Nat192.eq(object, nArray2)) {
                SecP192R1FieldElement secP192R1FieldElement;
                object = secP192R1FieldElement;
                secP192R1FieldElement = new SecP192R1FieldElement((int[])object2);
            } else {
                object = null;
            }
            return object;
        }
        return object2;
    }

    public boolean equals(Object object) {
        if (object == secP192R1FieldElement2) {
            return true;
        }
        if (!(object instanceof SecP192R1FieldElement)) {
            return false;
        }
        SecP192R1FieldElement secP192R1FieldElement = secP192R1FieldElement2;
        SecP192R1FieldElement secP192R1FieldElement2 = (SecP192R1FieldElement)object;
        return Nat192.eq(secP192R1FieldElement.x, secP192R1FieldElement2.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode(this.x, 0, 6);
    }
}

