/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.x509;

import com.fis.ekyc.nfc.build_in.bouncycastle.x509.NoSuchParserException;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.X509StreamParserSpi;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.X509Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.util.StreamParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Collection;

public class X509StreamParser
implements StreamParser {
    private Provider _provider;
    private X509StreamParserSpi _spi;

    public static X509StreamParser getInstance(String string) {
        try {
            return X509StreamParser.createParser(X509Util.getImplementation("X509StreamParser", string));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchParserException(noSuchAlgorithmException.getMessage());
        }
    }

    public static X509StreamParser getInstance(String string, String string2) {
        return X509StreamParser.getInstance(string, X509Util.getProvider(string2));
    }

    public static X509StreamParser getInstance(String string, Provider provider) {
        try {
            return X509StreamParser.createParser(X509Util.getImplementation("X509StreamParser", string, provider));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchParserException(noSuchAlgorithmException.getMessage());
        }
    }

    private static X509StreamParser createParser(X509Util.Implementation implementation) {
        X509StreamParserSpi x509StreamParserSpi = (X509StreamParserSpi)implementation.getEngine();
        return new X509StreamParser(implementation.getProvider(), x509StreamParserSpi);
    }

    private X509StreamParser(Provider provider, X509StreamParserSpi x509StreamParserSpi) {
        this._provider = provider;
        this._spi = x509StreamParserSpi;
    }

    public Provider getProvider() {
        return this._provider;
    }

    public void init(InputStream inputStream) {
        this._spi.engineInit(inputStream);
    }

    public void init(byte[] byArray) {
        this._spi.engineInit(new ByteArrayInputStream(byArray));
    }

    @Override
    public Object read() {
        return this._spi.engineRead();
    }

    @Override
    public Collection readAll() {
        return this._spi.engineReadAll();
    }
}

