/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.cvc;

import com.fis.ekyc.nfc.build_in.cvc.AbstractSequence;
import com.fis.ekyc.nfc.build_in.cvc.CVCTagEnum;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public abstract class CVCObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int CVC_VERSION = 0;
    public static final String NEWLINE = System.getProperty("line.separator");
    private static final int INT_LENGTH = 4;
    private static final int LONG_LENGTH = 8;
    private final CVCTagEnum tag;
    private AbstractSequence parent;

    public CVCObject(CVCTagEnum cVCTagEnum) {
        this.tag = cVCTagEnum;
    }

    public static byte[] encodeLength(int n) {
        int n2 = 0;
        if (n > 127) {
            n2 = 1;
            if (n > 255) {
                n2 = 2;
            }
        }
        int n3 = n2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3 + 1);
        if (n3 == 0) {
            byteBuffer.put(0, (byte)n);
        } else {
            byteBuffer.put(0, (byte)(n2 + 128));
            if (n2 == 1) {
                byteBuffer.put(1, (byte)n);
            } else {
                byteBuffer.putShort(1, (short)n);
            }
        }
        return byteBuffer.array();
    }

    public static int decodeLength(DataInputStream dataInputStream) {
        int n = ((InputStream)dataInputStream).read();
        if (n > 127) {
            n = (n & 0xF) == 1 ? dataInputStream.readUnsignedByte() : (int)dataInputStream.readShort();
        }
        return n;
    }

    public static byte[] toByteArray(Integer n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        return CVCObject.trimByteArray(byteBuffer.array());
    }

    public static byte[] toByteArray(Long l) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.putLong(l);
        return CVCObject.trimByteArray(byteBuffer.array());
    }

    public static byte[] trimByteArray(byte[] byArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < byArray.length && (n2 = byArray[n] != 0 ? 1 : 0) == 0; ++n) {
        }
        if (n2 != 0) {
            byte[] byArray2 = byArray;
            byArray = new byte[byArray.length - n];
            n2 = byArray.length - n;
            System.arraycopy(byArray2, n, byArray, 0, n2);
        } else {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = 0;
        }
        return byArray;
    }

    public CVCTagEnum getTag() {
        return this.tag;
    }

    public AbstractSequence getParent() {
        return this.parent;
    }

    public void setParent(AbstractSequence abstractSequence) {
        this.parent = abstractSequence;
    }

    public abstract int encode(DataOutputStream var1);

    public String getAsText() {
        return this.getAsText("", true);
    }

    public String getAsText(boolean bl) {
        return this.getAsText("", bl);
    }

    public String getAsText(String string) {
        return this.getAsText(string, true);
    }

    public String getAsText(String string, boolean bl) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        new StringBuffer().append(string);
        if (bl) {
            stringBuffer2.append(Integer.toHexString(this.getTag().getValue())).append(' ');
        }
        StringBuffer stringBuffer3 = stringBuffer2;
        stringBuffer3.append(this.getTag().name()).append("  ");
        return stringBuffer3.toString();
    }
}

