/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.scuba.tlv;

import b.b;
import com.fis.ekyc.nfc.build_in.scuba.tlv.ASN1Constants;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVUtil;
import com.fis.ekyc.nfc.build_in.scuba.util.Hex;
import java.text.ParseException;
import java.text.SimpleDateFormat;

class ASN1Util
implements ASN1Constants {
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyMMddhhmmss'Z'");

    public static Object interpretPrimitiveValue(int n, byte[] byArray) {
        if (TLVUtil.getTagClass(n) == 0) {
            switch (n) {
                default: {
                    break;
                }
                case 23: {
                    try {
                        return SDF.parse(new String(byArray));
                    }
                    catch (ParseException parseException) {
                        break;
                    }
                }
                case 12: 
                case 19: 
                case 20: 
                case 22: 
                case 26: 
                case 27: 
                case 28: 
                case 30: {
                    return new String(byArray);
                }
            }
        }
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String tagToString(int n) {
        if (TLVUtil.getTagClass(n) != 0) return b.a("'0x").append(Hex.intToHexString(n)).append("'").toString();
        if (TLVUtil.isPrimitive(n)) {
            switch (n & 0x1F) {
                default: {
                    return b.a("'0x").append(Hex.intToHexString(n)).append("'").toString();
                }
                case 30: {
                    return "BMP_STRING";
                }
                case 28: {
                    return "UNIVERSAL_STRING";
                }
                case 27: {
                    return "GENERAL_STRING";
                }
                case 26: {
                    return "VISIBLE_STRING";
                }
                case 24: {
                    return "GENERAL_TIME";
                }
                case 23: {
                    return "UTC_TIME";
                }
                case 22: {
                    return "IA5_STRING";
                }
                case 20: {
                    return "T61_STRING";
                }
                case 19: {
                    return "PRINTABLE_STRING";
                }
                case 12: {
                    return "UTF_STRING";
                }
                case 9: {
                    return "REAL";
                }
                case 6: {
                    return "OBJECT_IDENTIFIER";
                }
                case 5: {
                    return "NULL";
                }
                case 4: {
                    return "OCTET_STRING";
                }
                case 3: {
                    return "BIT_STRING";
                }
                case 2: {
                    return "INTEGER";
                }
                case 1: {
                    return "BOOLEAN";
                }
            }
        }
        int n2 = n & 0x1F;
        if (n2 == 10) return "ENUMERATED";
        if (n2 == 16) return "SEQUENCE";
        if (n2 != 17) return b.a("'0x").append(Hex.intToHexString(n)).append("'").toString();
        return "SET";
    }
}

