/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERUTF8String;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.BodyPartID;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.CMCStatus;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.OtherStatusInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.Utils;

public class CMCStatusInfoV2
extends ASN1Object {
    private final CMCStatus cMCStatus;
    private final ASN1Sequence bodyList;
    private final DERUTF8String statusString;
    private final OtherStatusInfo otherStatusInfo;

    public CMCStatusInfoV2(CMCStatus cMCStatus, ASN1Sequence aSN1Sequence, DERUTF8String dERUTF8String, OtherStatusInfo otherStatusInfo) {
        this.cMCStatus = cMCStatus;
        this.bodyList = aSN1Sequence;
        this.statusString = dERUTF8String;
        this.otherStatusInfo = otherStatusInfo;
    }

    private CMCStatusInfoV2(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() >= 2 && aSN1Sequence.size() <= 4) {
            this.cMCStatus = CMCStatus.getInstance(aSN1Sequence.getObjectAt(0));
            this.bodyList = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(1));
            if (aSN1Sequence.size() > 2) {
                if (aSN1Sequence.size() == 4) {
                    this.statusString = DERUTF8String.getInstance(aSN1Sequence.getObjectAt(2));
                    this.otherStatusInfo = OtherStatusInfo.getInstance(aSN1Sequence.getObjectAt(3));
                } else if (aSN1Sequence.getObjectAt(2) instanceof DERUTF8String) {
                    CMCStatusInfoV2 cMCStatusInfoV2 = this;
                    cMCStatusInfoV2.statusString = DERUTF8String.getInstance(aSN1Sequence.getObjectAt(2));
                    cMCStatusInfoV2.otherStatusInfo = null;
                } else {
                    this.statusString = null;
                    this.otherStatusInfo = OtherStatusInfo.getInstance(aSN1Sequence.getObjectAt(2));
                }
            } else {
                CMCStatusInfoV2 cMCStatusInfoV2 = this;
                cMCStatusInfoV2.statusString = null;
                cMCStatusInfoV2.otherStatusInfo = null;
            }
            return;
        }
        throw new IllegalArgumentException("incorrect sequence size");
    }

    public static CMCStatusInfoV2 getInstance(Object object) {
        if (object instanceof CMCStatusInfoV2) {
            return (CMCStatusInfoV2)object;
        }
        if (object != null) {
            return new CMCStatusInfoV2(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public CMCStatus getcMCStatus() {
        return this.cMCStatus;
    }

    public BodyPartID[] getBodyList() {
        return Utils.toBodyPartIDArray(this.bodyList);
    }

    public DERUTF8String getStatusString() {
        return this.statusString;
    }

    public OtherStatusInfo getOtherStatusInfo() {
        return this.otherStatusInfo;
    }

    public boolean hasOtherInfo() {
        return this.otherStatusInfo != null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        OtherStatusInfo otherStatusInfo;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(4);
        aSN1EncodableVector2.add(this.cMCStatus);
        aSN1EncodableVector.add(this.bodyList);
        DERUTF8String dERUTF8String = this.statusString;
        if (dERUTF8String != null) {
            aSN1EncodableVector2.add(dERUTF8String);
        }
        if ((otherStatusInfo = this.otherStatusInfo) != null) {
            aSN1EncodableVector2.add(otherStatusInfo);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

