/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.isismtt.ocsp;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Choice;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.j;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Certificate;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.IOException;

public class RequestedCertificate
extends ASN1Object
implements ASN1Choice {
    public static final int certificate = -1;
    public static final int publicKeyCertificate = 0;
    public static final int attributeCertificate = 1;
    private Certificate cert;
    private byte[] publicKeyCert;
    private byte[] attributeCert;

    public static RequestedCertificate getInstance(Object object) {
        if (object != null && !(object instanceof RequestedCertificate)) {
            if (object instanceof ASN1Sequence) {
                return new RequestedCertificate(Certificate.getInstance(object));
            }
            if (object instanceof ASN1TaggedObject) {
                return new RequestedCertificate((ASN1TaggedObject)object);
            }
            throw new IllegalArgumentException(c.a(object, b.a("illegal object in getInstance: ")));
        }
        return (RequestedCertificate)object;
    }

    public static RequestedCertificate getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        if (bl) {
            return RequestedCertificate.getInstance(aSN1TaggedObject.getObject());
        }
        throw new IllegalArgumentException("choice item must be explicitly tagged");
    }

    private RequestedCertificate(ASN1TaggedObject aSN1TaggedObject) {
        block4: {
            block3: {
                block2: {
                    if (aSN1TaggedObject.getTagNo() != 0) break block2;
                    this.publicKeyCert = ASN1OctetString.getInstance(aSN1TaggedObject, true).getOctets();
                    break block3;
                }
                if (aSN1TaggedObject.getTagNo() != 1) break block4;
                this.attributeCert = ASN1OctetString.getInstance(aSN1TaggedObject, true).getOctets();
            }
            return;
        }
        throw new IllegalArgumentException(com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.b.a(aSN1TaggedObject, b.a("unknown tag number: ")));
    }

    public RequestedCertificate(Certificate certificate) {
        this.cert = certificate;
    }

    public RequestedCertificate(int n, byte[] byArray) {
        DEROctetString dEROctetString;
        DERTaggedObject dERTaggedObject;
        RequestedCertificate requestedCertificate = aSN1Object;
        ASN1Object aSN1Object = dERTaggedObject;
        DEROctetString dEROctetString2 = dEROctetString;
        dEROctetString = new DEROctetString(byArray);
        dERTaggedObject = new DERTaggedObject(n, dEROctetString2);
        requestedCertificate((ASN1TaggedObject)aSN1Object);
    }

    public int getType() {
        if (this.cert != null) {
            return -1;
        }
        if (this.publicKeyCert != null) {
            return 0;
        }
        return 1;
    }

    public byte[] getCertificateBytes() {
        Object object = this.cert;
        if (object != null) {
            try {
                return ((ASN1Object)object).getEncoded();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(j.a("can't decode certificate: ", iOException));
            }
        }
        object = this.publicKeyCert;
        if (this.publicKeyCert != null) {
            return Arrays.clone((byte[])object);
        }
        return Arrays.clone(this.attributeCert);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1Object aSN1Object;
        byte[] byArray = aSN1Object.publicKeyCert;
        if (aSN1Object.publicKeyCert != null) {
            DEROctetString dEROctetString;
            aSN1Object = dEROctetString;
            dEROctetString = new DEROctetString(byArray);
            return new DERTaggedObject(0, aSN1Object);
        }
        byArray = aSN1Object.attributeCert;
        if (aSN1Object.attributeCert != null) {
            DEROctetString dEROctetString;
            aSN1Object = dEROctetString;
            dEROctetString = new DEROctetString(byArray);
            return new DERTaggedObject(1, aSN1Object);
        }
        return aSN1Object.cert.toASN1Primitive();
    }
}

