/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.EncodableDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.GeneralDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class SHA224Digest
extends GeneralDigest
implements EncodableDigest {
    private static final int DIGEST_LENGTH = 28;
    public static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private int H5;
    private int H6;
    private int H7;
    private int H8;
    private int[] X;
    private int xOff;

    public SHA224Digest() {
        SHA224Digest sHA224Digest = this;
        sHA224Digest.X = new int[64];
        sHA224Digest.reset();
    }

    public SHA224Digest(SHA224Digest sHA224Digest) {
        super(sHA224Digest);
        this.X = new int[64];
        this.doCopy(sHA224Digest);
    }

    private void doCopy(SHA224Digest sHA224Digest) {
        SHA224Digest sHA224Digest2 = object;
        SHA224Digest sHA224Digest3 = sHA224Digest;
        super.copyIn(sHA224Digest);
        ((SHA224Digest)object).H1 = sHA224Digest.H1;
        ((SHA224Digest)object).H2 = sHA224Digest.H2;
        ((SHA224Digest)object).H3 = sHA224Digest.H3;
        ((SHA224Digest)object).H4 = sHA224Digest.H4;
        ((SHA224Digest)object).H5 = sHA224Digest.H5;
        ((SHA224Digest)object).H6 = sHA224Digest.H6;
        ((SHA224Digest)object).H7 = sHA224Digest.H7;
        ((SHA224Digest)object).H8 = sHA224Digest.H8;
        Object object = ((SHA224Digest)object).X;
        int n = sHA224Digest3.X.length;
        System.arraycopy(sHA224Digest3.X, 0, object, 0, n);
        sHA224Digest2.xOff = sHA224Digest3.xOff;
    }

    public SHA224Digest(byte[] byArray) {
        super(byArray);
        this.X = new int[64];
        this.H1 = Pack.bigEndianToInt(byArray, 16);
        this.H2 = Pack.bigEndianToInt(byArray, 20);
        this.H3 = Pack.bigEndianToInt(byArray, 24);
        this.H4 = Pack.bigEndianToInt(byArray, 28);
        this.H5 = Pack.bigEndianToInt(byArray, 32);
        this.H6 = Pack.bigEndianToInt(byArray, 36);
        this.H7 = Pack.bigEndianToInt(byArray, 40);
        this.H8 = Pack.bigEndianToInt(byArray, 44);
        this.xOff = Pack.bigEndianToInt(byArray, 48);
        for (int k = 0; k != this.xOff; ++k) {
            this.X[k] = Pack.bigEndianToInt(byArray, k * 4 + 52);
        }
    }

    private int Ch(int n, int n2, int n3) {
        return n & n2 ^ ~n & n3;
    }

    private int Maj(int n, int n2, int n3) {
        return n & n2 ^ n & n3 ^ n2 & n3;
    }

    private int Sum0(int n) {
        return (n >>> 2 | n << 30) ^ (n >>> 13 | n << 19) ^ (n >>> 22 | n << 10);
    }

    private int Sum1(int n) {
        return (n >>> 6 | n << 26) ^ (n >>> 11 | n << 21) ^ (n >>> 25 | n << 7);
    }

    private int Theta0(int n) {
        return (n >>> 7 | n << 25) ^ (n >>> 18 | n << 14) ^ n >>> 3;
    }

    private int Theta1(int n) {
        return (n >>> 17 | n << 15) ^ (n >>> 19 | n << 13) ^ n >>> 10;
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-224";
    }

    @Override
    public int getDigestSize() {
        return 28;
    }

    @Override
    public void processWord(byte[] byArray, int n) {
        int n2 = byArray[n] << 24;
        n = n + 1;
        int n3 = n2 | (byArray[n] & 0xFF) << 16 | (byArray[++n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
        n = this.xOff;
        this.X[n] = n3;
        this.xOff = n + 1;
        if (this.xOff == 16) {
            this.processBlock();
        }
    }

    @Override
    public void processLength(long l) {
        if (((SHA224Digest)object).xOff > 14) {
            ((SHA224Digest)object).processBlock();
        }
        Object object = ((SHA224Digest)object).X;
        object[14] = (int)(l >>> 32);
        ((SHA224Digest)object).X[15] = (int)(l & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        SHA224Digest sHA224Digest = this;
        sHA224Digest.finish();
        Pack.intToBigEndian(sHA224Digest.H1, byArray, n);
        Pack.intToBigEndian(sHA224Digest.H2, byArray, n + 4);
        Pack.intToBigEndian(sHA224Digest.H3, byArray, n + 8);
        Pack.intToBigEndian(sHA224Digest.H4, byArray, n + 12);
        Pack.intToBigEndian(sHA224Digest.H5, byArray, n + 16);
        Pack.intToBigEndian(sHA224Digest.H6, byArray, n + 20);
        Pack.intToBigEndian(sHA224Digest.H7, byArray, n + 24);
        sHA224Digest.reset();
        return 28;
    }

    @Override
    public void reset() {
        super.reset();
        this.H1 = -1056596264;
        this.H2 = 914150663;
        this.H3 = 812702999;
        this.H4 = -150054599;
        this.H5 = -4191439;
        this.H6 = 1750603025;
        this.H7 = 1694076839;
        this.H8 = -1090891868;
        this.xOff = 0;
        int n = 0;
        while (true) {
            int[] nArray = this.X;
            if (n == this.X.length) break;
            nArray[n] = 0;
            ++n;
        }
    }

    @Override
    public void processBlock() {
        int n;
        for (n = 16; n <= 63; ++n) {
            int[] nArray = this.X;
            int n2 = this.Theta1(nArray[n - 2]);
            nArray = this.X;
            this.X[n] = n2 + this.X[n - 7] + this.Theta0(nArray[n - 15]) + this.X[n - 16];
        }
        SHA224Digest sHA224Digest = this;
        n = sHA224Digest.H1;
        int n3 = sHA224Digest.H2;
        int n4 = sHA224Digest.H3;
        int n5 = sHA224Digest.H4;
        int n6 = sHA224Digest.H5;
        int n7 = sHA224Digest.H6;
        int n8 = sHA224Digest.H7;
        int n9 = sHA224Digest.H8;
        int n10 = 0;
        for (int k = 0; k < 8; ++k) {
            SHA224Digest sHA224Digest2 = this;
            int n11 = n;
            SHA224Digest sHA224Digest3 = this;
            int n12 = n3;
            SHA224Digest sHA224Digest4 = this;
            int n13 = n4;
            SHA224Digest sHA224Digest5 = this;
            int[] nArray = K;
            n9 = this.Sum1(n6) + this.Ch(n6, n7, n8) + K[n10] + this.X[n10] + n9;
            int n14 = n5 + n9;
            n4 = sHA224Digest5.Sum0(n) + this.Maj(n, n3, n4) + n9;
            n9 = n10 + 1;
            n8 = sHA224Digest5.Sum1(n14) + this.Ch(n14, n6, n7) + nArray[n9] + this.X[n9] + n8;
            n10 = n13 + n8;
            n3 = sHA224Digest4.Sum0(n4) + this.Maj(n4, n, n3) + n8;
            n8 = n9 + 1;
            n7 = sHA224Digest4.Sum1(n10) + this.Ch(n10, n14, n6) + nArray[n8] + this.X[n8] + n7;
            n9 = n12 + n7;
            n = sHA224Digest3.Sum0(n3) + this.Maj(n3, n4, n) + n7;
            n7 = n8 + 1;
            n6 = sHA224Digest3.Sum1(n9) + this.Ch(n9, n10, n14) + nArray[n7] + this.X[n7] + n6;
            n8 = n11 + n6;
            int n15 = sHA224Digest2.Sum0(n) + this.Maj(n, n3, n4) + n6;
            n6 = n15;
            SHA224Digest sHA224Digest6 = this;
            int n16 = n;
            SHA224Digest sHA224Digest7 = this;
            int n17 = n3;
            SHA224Digest sHA224Digest8 = this;
            int n18 = n4;
            n4 = n7 + 1;
            n7 = this.Sum1(n8) + this.Ch(n8, n9, n10) + nArray[n4] + this.X[n4] + n14;
            n14 = n18 + n7;
            n3 = sHA224Digest8.Sum0(n6) + this.Maj(n6, n, n3) + n7;
            n7 = sHA224Digest8.Sum1(n14) + this.Ch(n14, n8, n9) + nArray[++n4] + this.X[n4] + n10;
            n10 = n17 + n7;
            n = sHA224Digest7.Sum0(n3) + this.Maj(n3, n6, n) + n7;
            n7 = sHA224Digest7.Sum1(n10) + this.Ch(n10, n14, n8) + nArray[++n4] + this.X[n4] + n9;
            n9 = n16 + n7;
            n6 = sHA224Digest6.Sum0(n) + this.Maj(n, n3, n6) + n7;
            n5 = sHA224Digest6.Sum1(n9) + this.Ch(n9, n10, n14) + nArray[++n4] + this.X[n4] + n8;
            n7 = n15 + n5;
            n5 = sHA224Digest2.Sum0(n6) + this.Maj(n6, n, n3) + n5;
            ++n4;
            int n19 = n5;
            int n20 = n6;
            int n21 = n7;
            int n22 = n9;
            int n23 = n10;
            n10 = n4;
            n9 = n14;
            n8 = n23;
            n7 = n22;
            n6 = n21;
            n5 = n3;
            n4 = n;
            n3 = n20;
            n = n19;
        }
        SHA224Digest sHA224Digest9 = this;
        sHA224Digest9.H1 += n;
        sHA224Digest9.H2 += n3;
        sHA224Digest9.H3 += n4;
        sHA224Digest9.H4 += n5;
        sHA224Digest9.H5 += n6;
        sHA224Digest9.H6 += n7;
        sHA224Digest9.H7 += n8;
        sHA224Digest9.H8 += n9;
        sHA224Digest9.xOff = 0;
        for (n = 0; n < 16; ++n) {
            this.X[n] = 0;
        }
    }

    @Override
    public Memoable copy() {
        return new SHA224Digest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        this.doCopy((SHA224Digest)memoable);
    }

    @Override
    public byte[] getEncodedState() {
        SHA224Digest sHA224Digest = this;
        byte[] byArray = new byte[sHA224Digest.xOff * 4 + 52];
        super.populateState(byArray);
        Pack.intToBigEndian(sHA224Digest.H1, byArray, 16);
        Pack.intToBigEndian(sHA224Digest.H2, byArray, 20);
        Pack.intToBigEndian(sHA224Digest.H3, byArray, 24);
        Pack.intToBigEndian(sHA224Digest.H4, byArray, 28);
        Pack.intToBigEndian(sHA224Digest.H5, byArray, 32);
        Pack.intToBigEndian(sHA224Digest.H6, byArray, 36);
        Pack.intToBigEndian(sHA224Digest.H7, byArray, 40);
        Pack.intToBigEndian(sHA224Digest.H8, byArray, 44);
        Pack.intToBigEndian(sHA224Digest.xOff, byArray, 48);
        for (int k = 0; k != this.xOff; ++k) {
            Pack.intToBigEndian(this.X[k], byArray, k * 4 + 52);
        }
        return byArray;
    }
}

