/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.RSACoreEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSABlindingParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class RSABlindingEngine
implements AsymmetricBlockCipher {
    private RSACoreEngine core;
    private RSAKeyParameters key;
    private BigInteger blindingFactor;
    private boolean forEncryption;

    public RSABlindingEngine() {
        RSACoreEngine rSACoreEngine;
        RSACoreEngine rSACoreEngine2 = rSACoreEngine;
        rSACoreEngine = new RSACoreEngine();
        v1.core = rSACoreEngine2;
    }

    private BigInteger blindMessage(BigInteger bigInteger) {
        return bigInteger.multiply(this.blindingFactor.modPow(this.key.getExponent(), this.key.getModulus())).mod(this.key.getModulus());
    }

    private BigInteger unblindMessage(BigInteger bigInteger) {
        BigInteger bigInteger2 = bigInteger;
        bigInteger = this.key.getModulus();
        return bigInteger2.multiply(BigIntegers.modOddInverse(bigInteger, this.blindingFactor)).mod(bigInteger);
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        cipherParameters = cipherParameters instanceof ParametersWithRandom ? (RSABlindingParameters)((ParametersWithRandom)cipherParameters).getParameters() : (RSABlindingParameters)cipherParameters;
        this.core.init(bl, ((RSABlindingParameters)cipherParameters).getPublicKey());
        this.forEncryption = bl;
        this.key = ((RSABlindingParameters)cipherParameters).getPublicKey();
        this.blindingFactor = ((RSABlindingParameters)cipherParameters).getBlindingFactor();
    }

    @Override
    public int getInputBlockSize() {
        return this.core.getInputBlockSize();
    }

    @Override
    public int getOutputBlockSize() {
        return this.core.getOutputBlockSize();
    }

    @Override
    public byte[] processBlock(byte[] object, int n, int n2) {
        RSABlindingEngine rSABlindingEngine = this;
        object = rSABlindingEngine.core.convertInput((byte[])object, n, n2);
        object = rSABlindingEngine.forEncryption ? (Object)this.blindMessage((BigInteger)object) : (Object)this.unblindMessage((BigInteger)object);
        return this.core.convertOutput((BigInteger)object);
    }
}

