/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;

public class VMPCMac
implements Mac {
    private byte g;
    private byte n = 0;
    private byte[] P = null;
    private byte s = 0;
    private byte[] T;
    private byte[] workingIV;
    private byte[] workingKey;
    private byte x1;
    private byte x2;
    private byte x3;
    private byte x4;

    private void initKey(byte[] byArray, byte[] byArray2) {
        byte by;
        int n;
        VMPCMac vMPCMac = this;
        vMPCMac.s = 0;
        vMPCMac.P = new byte[256];
        int n2 = 0;
        while (n2 < 256) {
            int n3 = n2++;
            this.P[n3] = (byte)n3;
        }
        for (n2 = 0; n2 < 768; ++n2) {
            byte by2;
            byte[] byArray3 = this.P;
            n = n2 & 0xFF;
            by = byArray3[n];
            this.s = by2 = byArray3[this.s + by + byArray[n2 % byArray.length] & 0xFF];
            byArray3[n] = byArray3[by2 & 0xFF];
            this.P[by2 & 0xFF] = by;
        }
        for (int k = 0; k < 768; ++k) {
            byte[] byArray4 = this.P;
            int n4 = k & 0xFF;
            n = byArray4[n4];
            this.s = by = byArray4[this.s + n + byArray2[k % byArray2.length] & 0xFF];
            byArray4[n4] = byArray4[by & 0xFF];
            this.P[by & 0xFF] = n;
        }
        this.n = 0;
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        byte by;
        int n2;
        byte by2;
        int n3;
        int n4;
        for (n4 = 1; n4 < 25; ++n4) {
            int n5;
            VMPCMac vMPCMac = this;
            byte[] byArray2 = vMPCMac.P;
            n3 = vMPCMac.s;
            byte by3 = vMPCMac.n;
            by2 = by3;
            int n6 = byArray2[n3 + byArray2[by2 & 0xFF] & 0xFF];
            int n7 = n3 = n6;
            byte by4 = by2;
            byte by5 = by2;
            VMPCMac vMPCMac2 = this;
            VMPCMac vMPCMac3 = this;
            vMPCMac3.s = (byte)n3;
            by2 = vMPCMac3.x4;
            byte by6 = vMPCMac3.x3;
            n2 = by6;
            this.x4 = by2 = byArray2[by2 + n2 + n4 & 0xFF];
            byte by7 = this.x2;
            n2 = by7;
            this.x3 = by = byArray2[by6 + by7 + n4 & 0xFF];
            byte by8 = this.x1;
            this.x2 = n5 = byArray2[n2 + by8 + n4 & 0xFF];
            n3 = byArray2[by8 + n3 + n4 & 0xFF];
            vMPCMac2.x1 = (byte)n3;
            byte[] byArray3 = vMPCMac2.T;
            byte by9 = by8 = vMPCMac2.g;
            byte by10 = by8;
            byte by11 = by8;
            byte by12 = by8;
            n2 = by12 & 0x1F;
            byArray3[n2] = (byte)(byArray3[by12 & 0x1F] ^ n3);
            n3 = by11 + 1 & 0x1F;
            byArray3[n3] = (byte)(byArray3[by11 + 1 & 0x1F] ^ n5);
            n5 = by10 + 2 & 0x1F;
            byArray3[n5] = (byte)(byArray3[by10 + 2 & 0x1F] ^ by);
            n5 = by9 + 3 & 0x1F;
            byArray3[n5] = (byte)(byArray3[by9 + 3 & 0x1F] ^ by2);
            vMPCMac2.g = (byte)(by8 + 4 & 0x1F);
            n5 = byArray2[by5 & 0xFF];
            n3 = by4 & 0xFF;
            byArray2[n3] = byArray2[n7 & 0xFF];
            byArray2[n6 & 0xFF] = n5;
            vMPCMac.n = (byte)(by3 + 1 & 0xFF);
        }
        for (n4 = 0; n4 < 768; ++n4) {
            byte[] byArray4 = this.P;
            n3 = n4 & 0xFF;
            by2 = byArray4[n3];
            n2 = byArray4[this.s + by2 + this.T[n4 & 0x1F] & 0xFF];
            this.s = (byte)n2;
            byArray4[n3] = byArray4[n2 & 0xFF];
            this.P[n2 & 0xFF] = by2;
        }
        n4 = 20;
        byte[] byArray5 = new byte[20];
        for (n3 = 0; n3 < 20; ++n3) {
            byte[] byArray6 = this.P;
            n2 = n3 & 0xFF;
            this.s = by = byArray6[this.s + byArray6[n2] & 0xFF];
            byArray5[n3] = byArray6[byArray6[byArray6[by & 0xFF] & 0xFF] + 1 & 0xFF];
            by2 = byArray6[n2];
            byArray6[n2] = byArray6[by & 0xFF];
            this.P[by & 0xFF] = by2;
        }
        System.arraycopy(byArray5, 0, byArray, n, n4);
        this.reset();
        return n4;
    }

    @Override
    public String getAlgorithmName() {
        return "VMPC-MAC";
    }

    @Override
    public int getMacSize() {
        return 20;
    }

    @Override
    public void init(CipherParameters object) {
        if (object instanceof ParametersWithIV) {
            object = (ParametersWithIV)object;
            KeyParameter keyParameter = (KeyParameter)((ParametersWithIV)object).getParameters();
            if (((ParametersWithIV)object).getParameters() instanceof KeyParameter) {
                byte[] byArray = ((ParametersWithIV)object).getIV();
                object = byArray;
                this.workingIV = (byte[])object;
                if (byArray != null && ((Object)object).length >= 1 && ((Object)object).length <= 768) {
                    this.workingKey = keyParameter.getKey();
                    this.reset();
                    return;
                }
                throw new IllegalArgumentException("VMPC-MAC requires 1 to 768 bytes of IV");
            }
            throw new IllegalArgumentException("VMPC-MAC Init parameters must include a key");
        }
        throw new IllegalArgumentException("VMPC-MAC Init parameters must include an IV");
    }

    @Override
    public void reset() {
        VMPCMac vMPCMac = this;
        byte[] byArray = vMPCMac.workingKey;
        vMPCMac.initKey(byArray, vMPCMac.workingIV);
        vMPCMac.n = 0;
        vMPCMac.x4 = 0;
        vMPCMac.x3 = 0;
        vMPCMac.x2 = 0;
        vMPCMac.x1 = 0;
        vMPCMac.g = 0;
        vMPCMac.T = new byte[32];
        for (int k = 0; k < 32; ++k) {
            this.T[k] = 0;
        }
    }

    @Override
    public void update(byte by) {
        int n;
        byte by2;
        VMPCMac vMPCMac = this;
        byte[] byArray = vMPCMac.P;
        byte by3 = vMPCMac.s;
        byte by4 = vMPCMac.n;
        byte by5 = by4;
        byte by6 = byArray[by3 + byArray[by5 & 0xFF] & 0xFF];
        byte by7 = by3 = by6;
        byte by8 = by5;
        byte[] byArray2 = byArray;
        byte by9 = by5;
        VMPCMac vMPCMac2 = this;
        VMPCMac vMPCMac3 = this;
        this.s = by3;
        by = (byte)(by ^ byArray[byArray[byArray[by3 & 0xFF] & 0xFF] + 1 & 0xFF]);
        by5 = vMPCMac3.x4;
        byte by10 = vMPCMac3.x3;
        byte by11 = by10;
        this.x4 = by5 = byArray[by5 + by11 & 0xFF];
        by11 = this.x2;
        this.x3 = by2 = byArray[by10 + by11 & 0xFF];
        byte by12 = this.x1;
        this.x2 = n = byArray[by11 + by12 & 0xFF];
        vMPCMac2.x1 = by = byArray[by12 + by3 + by & 0xFF];
        byArray = vMPCMac2.T;
        byte by13 = by3 = vMPCMac2.g;
        byte by14 = by3;
        byte by15 = by3;
        byte by16 = by3;
        int n2 = by16 & 0x1F;
        byArray[n2] = (byte)(byArray[by16 & 0x1F] ^ by);
        by = (byte)(by15 + 1 & 0x1F);
        byArray[by] = (byte)(byArray[by15 + 1 & 0x1F] ^ n);
        n = by14 + 2 & 0x1F;
        byArray[n] = (byte)(byArray[by14 + 2 & 0x1F] ^ by2);
        n = by13 + 3 & 0x1F;
        byArray[n] = (byte)(byArray[by13 + 3 & 0x1F] ^ by5);
        vMPCMac2.g = (byte)(by3 + 4 & 0x1F);
        n = byArray2[by9 & 0xFF];
        by = (byte)(by8 & 0xFF);
        byArray[by] = byArray[by7 & 0xFF];
        byArray[by6 & 0xFF] = n;
        vMPCMac.n = (byte)(by4 + 1 & 0xFF);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        if (n + n2 <= byArray.length) {
            for (int k = 0; k < n2; ++k) {
                this.update(byArray[n + k]);
            }
            return;
        }
        throw new DataLengthException("input buffer too short");
    }
}

