/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings.BlockCipherPadding;
import java.security.SecureRandom;

public class PKCS7Padding
implements BlockCipherPadding {
    @Override
    public void init(SecureRandom secureRandom) {
    }

    @Override
    public String getPaddingName() {
        return "PKCS7";
    }

    @Override
    public int addPadding(byte[] byArray, int n) {
        byte by = (byte)(byArray.length - n);
        while (n < byArray.length) {
            byArray[n] = by;
            ++n;
        }
        return by;
    }

    @Override
    public int padCount(byte[] byArray) {
        int n = byArray[byArray.length - 1] & 0xFF;
        byte by = (byte)n;
        boolean bl = n > byArray.length;
        int n2 = n == 0 ? 1 : 0;
        bl |= n2;
        for (n2 = 0; n2 < byArray.length; ++n2) {
            boolean bl2 = byArray.length - n2 <= n;
            boolean bl3 = byArray[n2] != by;
            bl |= bl2 & bl3;
        }
        if (!bl) {
            return n;
        }
        throw new InvalidCipherTextException("pad block corrupted");
    }
}

