/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Mod;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat224;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP224K1Field {
    public static final int[] P = new int[]{-6803, -2, -1, -1, -1, -1, -1};
    private static final int[] PExt = new int[]{46280809, 13606, 1, 0, 0, 0, 0, -13606, -3, -1, -1, -1, -1, -1};
    private static final int[] PExtInv = new int[]{-46280809, -13607, -2, -1, -1, -1, -1, 13605, 2};
    private static final int P6 = -1;
    private static final int PExt13 = -1;
    private static final int PInv33 = 6803;

    public static void add(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat224.add(nArray, nArray2, nArray3) != 0 || nArray3[6] == -1 && Nat224.gte(nArray3, P)) {
            Nat.add33To(7, 6803, nArray3);
        }
    }

    public static void addExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if ((Nat.add(14, nArray, nArray2, nArray3) != 0 || nArray3[13] == -1 && Nat.gte(14, nArray3, nArray = PExt)) && Nat.addTo(PExtInv.length, nArray = PExtInv, nArray3) != 0) {
            int n = nArray.length;
            Nat.incAt(14, nArray3, n);
        }
    }

    public static void addOne(int[] nArray, int[] nArray2) {
        if (Nat.inc(7, nArray, nArray2) != 0 || nArray2[6] == -1 && Nat224.gte(nArray2, P)) {
            Nat.add33To(7, 6803, nArray2);
        }
    }

    public static int[] fromBigInteger(BigInteger object) {
        int[] nArray = Nat224.fromBigInteger((BigInteger)object);
        object = nArray;
        if (nArray[6] == -1 && Nat224.gte((int[])object, P)) {
            Nat.add33To(7, 6803, (int[])object);
        }
        return object;
    }

    public static void half(int[] nArray, int[] nArray2) {
        if ((nArray[0] & 1) == 0) {
            Nat.shiftDownBit(7, nArray, 0, nArray2);
        } else {
            int n = Nat224.add(nArray, P, nArray2);
            Nat.shiftDownBit(7, nArray2, n);
        }
    }

    public static void inv(int[] nArray, int[] nArray2) {
        Mod.checkedModOddInverse(P, nArray, nArray2);
    }

    public static int isZero(int[] nArray) {
        int n = 0;
        for (int k = 0; k < 7; ++k) {
            n |= nArray[k];
        }
        return (n >>> 1 | n & 1) - 1 >> 31;
    }

    public static void multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Nat224.createExt();
        Nat224.mul(nArray, nArray2, nArray4);
        SecP224K1Field.reduce(nArray4, nArray3);
    }

    public static void multiplyAddToExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if ((Nat224.mulAddTo(nArray, nArray2, nArray3) != 0 || nArray3[13] == -1 && Nat.gte(14, nArray3, nArray = PExt)) && Nat.addTo(PExtInv.length, nArray = PExtInv, nArray3) != 0) {
            int n = nArray.length;
            Nat.incAt(14, nArray3, n);
        }
    }

    public static void negate(int[] nArray, int[] nArray2) {
        if (SecP224K1Field.isZero(nArray) != 0) {
            Nat224.sub(P, P, nArray2);
        } else {
            Nat224.sub(P, nArray, nArray2);
        }
    }

    public static void random(SecureRandom secureRandom, int[] nArray) {
        int[] nArray2;
        byte[] byArray = new byte[28];
        do {
            secureRandom.nextBytes(byArray);
            Pack.littleEndianToInt(byArray, 0, nArray, 0, 7);
        } while (Nat.lessThan(7, nArray, nArray2 = P) == 0);
    }

    public static void randomMult(SecureRandom secureRandom, int[] nArray) {
        do {
            SecP224K1Field.random(secureRandom, nArray);
        } while (SecP224K1Field.isZero(nArray) != 0);
    }

    public static void reduce(int[] nArray, int[] nArray2) {
        long l = Nat224.mul33Add(6803, nArray, 7, nArray, 0, nArray2, 0);
        if (Nat224.mul33DWordAdd(6803, l, nArray2, 0) != 0 || nArray2[6] == -1 && Nat224.gte(nArray2, P)) {
            Nat.add33To(7, 6803, nArray2);
        }
    }

    public static void reduce32(int n, int[] nArray) {
        if (n != 0 && Nat224.mul33WordAdd(6803, n, nArray, 0) != 0 || nArray[6] == -1 && Nat224.gte(nArray, P)) {
            Nat.add33To(7, 6803, nArray);
        }
    }

    public static void square(int[] nArray, int[] nArray2) {
        int[] nArray3 = Nat224.createExt();
        Nat224.square(nArray, nArray3);
        SecP224K1Field.reduce(nArray3, nArray2);
    }

    public static void squareN(int[] nArray, int n, int[] nArray2) {
        int[] nArray3 = Nat224.createExt();
        Nat224.square(nArray, nArray3);
        SecP224K1Field.reduce(nArray3, nArray2);
        while ((n += -1) > 0) {
            Nat224.square(nArray2, nArray3);
            SecP224K1Field.reduce(nArray3, nArray2);
        }
    }

    public static void subtract(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat224.sub(nArray, nArray2, nArray3) != 0) {
            Nat.sub33From(7, 6803, nArray3);
        }
    }

    public static void subtractExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat.sub(14, nArray, nArray2, nArray3) != 0 && Nat.subFrom(PExtInv.length, nArray = PExtInv, nArray3) != 0) {
            int n = nArray.length;
            Nat.decAt(14, nArray3, n);
        }
    }

    public static void twice(int[] nArray, int[] nArray2) {
        if (Nat.shiftUpBit(7, nArray, 0, nArray2) != 0 || nArray2[6] == -1 && Nat224.gte(nArray2, P)) {
            Nat.add33To(7, 6803, nArray2);
        }
    }
}

