/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ExhaustedPrivateKeyException;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.HSSKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.HSSPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.HSSSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMOtsPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMS;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSContext;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSSignedPubKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSigParameters;
import java.util.Arrays;
import java.util.List;

class HSS {
    public static HSSPrivateKeyParameters generateHSSKeyPair(HSSKeyGenerationParameters hSSKeyGenerationParameters) {
        HSSKeyGenerationParameters hSSKeyGenerationParameters2 = hSSKeyGenerationParameters;
        int n = hSSKeyGenerationParameters2.getDepth();
        Object object = new LMSPrivateKeyParameters[n];
        LMSSignature[] lMSSignatureArray = new LMSSignature[hSSKeyGenerationParameters2.getDepth() - 1];
        byte[] byArray = new byte[32];
        hSSKeyGenerationParameters2.getRandom().nextBytes(byArray);
        byte[] byArray2 = new byte[16];
        hSSKeyGenerationParameters2.getRandom().nextBytes(byArray2);
        byte[] byArray3 = new byte[]{};
        long l = 1L;
        for (int k = 0; k < n; ++k) {
            int n2;
            int n3;
            if (k == 0) {
                HSSKeyGenerationParameters hSSKeyGenerationParameters3 = hSSKeyGenerationParameters;
                LMOtsParameters lMOtsParameters = hSSKeyGenerationParameters3.getLmsParameters()[k].getLMOTSParam();
                n3 = hSSKeyGenerationParameters3.getLmsParameters()[k].getLMSigParam().getH();
                n2 = 1 << n3;
                object[k] = new LMSPrivateKeyParameters(hSSKeyGenerationParameters.getLmsParameters()[k].getLMSigParam(), lMOtsParameters, 0, byArray2, n2, byArray);
            } else {
                HSSKeyGenerationParameters hSSKeyGenerationParameters4 = hSSKeyGenerationParameters;
                LMOtsParameters lMOtsParameters = hSSKeyGenerationParameters4.getLmsParameters()[k].getLMOTSParam();
                n3 = hSSKeyGenerationParameters4.getLmsParameters()[k].getLMSigParam().getH();
                n2 = 1 << n3;
                object[k] = new PlaceholderLMSPrivateKey(hSSKeyGenerationParameters.getLmsParameters()[k].getLMSigParam(), lMOtsParameters, -1, byArray3, n2, byArray3);
            }
            l *= (long)(1 << hSSKeyGenerationParameters.getLmsParameters()[k].getLMSigParam().getH());
        }
        if (l == 0L) {
            l = Long.MAX_VALUE;
        }
        int n4 = hSSKeyGenerationParameters.getDepth();
        List<LMSPrivateKeyParameters> list = Arrays.asList(object);
        object = Arrays.asList(lMSSignatureArray);
        return new HSSPrivateKeyParameters(n4, list, (List<LMSSignature>)object, 0L, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incrementIndex(HSSPrivateKeyParameters hSSPrivateKeyParameters) {
        HSSPrivateKeyParameters hSSPrivateKeyParameters2 = hSSPrivateKeyParameters;
        synchronized (hSSPrivateKeyParameters2) {
            HSS.rangeTestKeys(hSSPrivateKeyParameters2);
            hSSPrivateKeyParameters2.incIndex();
            List<LMSPrivateKeyParameters> list = hSSPrivateKeyParameters2.getKeys();
            int n = hSSPrivateKeyParameters.getL();
            list.get(n - 1).incIndex();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void rangeTestKeys(HSSPrivateKeyParameters hSSPrivateKeyParameters) {
        HSSPrivateKeyParameters hSSPrivateKeyParameters2 = hSSPrivateKeyParameters;
        synchronized (hSSPrivateKeyParameters2) {
            if (hSSPrivateKeyParameters2.getIndex() >= hSSPrivateKeyParameters.getIndexLimit()) {
                ExhaustedPrivateKeyException exhaustedPrivateKeyException;
                StringBuilder stringBuilder = new StringBuilder().append("hss private key");
                String string = hSSPrivateKeyParameters.isShard() ? " shard" : "";
                ExhaustedPrivateKeyException exhaustedPrivateKeyException2 = exhaustedPrivateKeyException;
                exhaustedPrivateKeyException2(stringBuilder.append(string).append(" is exhausted").toString());
                throw exhaustedPrivateKeyException2;
            }
            HSSPrivateKeyParameters hSSPrivateKeyParameters3 = hSSPrivateKeyParameters;
            int n = hSSPrivateKeyParameters3.getL();
            Object object = hSSPrivateKeyParameters3.getKeys();
            int n2 = n;
            {
                int n3;
                while (object.get(n3 = n2 - 1).getIndex() == 1 << object.get(n3).getSigParameters().getH()) {
                    if (n3 == 0) {
                        ExhaustedPrivateKeyException exhaustedPrivateKeyException;
                        object = new StringBuilder().append("hss private key");
                        String string = hSSPrivateKeyParameters.isShard() ? " shard" : "";
                        ExhaustedPrivateKeyException exhaustedPrivateKeyException3 = exhaustedPrivateKeyException;
                        exhaustedPrivateKeyException3(((StringBuilder)object).append(string).append(" is exhausted the maximum limit for this HSS private key").toString());
                        throw exhaustedPrivateKeyException3;
                    }
                    n2 = n3;
                }
                while (n2 < n) {
                    hSSPrivateKeyParameters.replaceConsumedKey(n2);
                    ++n2;
                }
            }
            {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HSSSignature generateSignature(HSSPrivateKeyParameters hSSPrivateKeyParameters, byte[] byArray) {
        int n = hSSPrivateKeyParameters.getL();
        HSSPrivateKeyParameters hSSPrivateKeyParameters2 = hSSPrivateKeyParameters;
        synchronized (hSSPrivateKeyParameters2) {
            HSS.rangeTestKeys(hSSPrivateKeyParameters2);
            List<LMSPrivateKeyParameters> list = hSSPrivateKeyParameters2.getKeys();
            List<LMSSignature> list2 = hSSPrivateKeyParameters2.getSig();
            Object object = hSSPrivateKeyParameters2.getKeys();
            int n2 = n - 1;
            object = object.get(n2);
            int n3 = 0;
            LMSSignedPubKey[] lMSSignedPubKeyArray = new LMSSignedPubKey[n2];
            while (n3 < n2) {
                LMSSignedPubKey lMSSignedPubKey;
                LMSSignedPubKey[] lMSSignedPubKeyArray2 = lMSSignedPubKeyArray;
                int n4 = n3;
                LMSSignedPubKey lMSSignedPubKey2 = lMSSignedPubKey;
                List<LMSPrivateKeyParameters> list3 = list;
                LMSSignature lMSSignature = list2.get(n3);
                int n5 = n3 + 1;
                lMSSignedPubKey = new LMSSignedPubKey(lMSSignature, list3.get(n5).getPublicKey());
                lMSSignedPubKeyArray2[n4] = lMSSignedPubKey2;
                n3 = n5;
            }
            HSSPrivateKeyParameters hSSPrivateKeyParameters3 = hSSPrivateKeyParameters;
            hSSPrivateKeyParameters3.incIndex();
            // ** MonitorExit[v5] (shouldn't be in output)
            LMSContext lMSContext = ((LMSPrivateKeyParameters)object).generateLMSContext().withSignedPublicKeys(lMSSignedPubKeyArray);
            lMSContext.update(byArray, 0, byArray.length);
            return HSS.generateSignature(n, lMSContext);
        }
    }

    public static HSSSignature generateSignature(int n, LMSContext lMSSignedPubKeyArray) {
        lMSSignedPubKeyArray = lMSSignedPubKeyArray.getSignedPubKeys();
        LMSSignature lMSSignature = LMS.generateSign((LMSContext)lMSSignedPubKeyArray);
        return new HSSSignature(--n, lMSSignedPubKeyArray, lMSSignature);
    }

    public static boolean verifySignature(HSSPublicKeyParameters encodable, HSSSignature hSSSignature, byte[] byArray) {
        int n = hSSSignature.getlMinus1();
        int n2 = n + 1;
        if (n2 != encodable.getL()) {
            return false;
        }
        LMSSignature[] lMSSignatureArray = new LMSSignature[n2];
        LMSPublicKeyParameters[] lMSPublicKeyParametersArray = new LMSPublicKeyParameters[n];
        for (int k = 0; k < n; ++k) {
            lMSSignatureArray[k] = hSSSignature.getSignedPubKey()[k].getSignature();
            lMSPublicKeyParametersArray[k] = hSSSignature.getSignedPubKey()[k].getPublicKey();
        }
        lMSSignatureArray[n] = hSSSignature.getSignature();
        encodable = encodable.getLMSPublicKey();
        for (int k = 0; k < n; ++k) {
            if (!LMS.verifySignature((LMSPublicKeyParameters)encodable, (LMSSignature)(encodable = lMSSignatureArray[k]), lMSPublicKeyParametersArray[k].toByteArray())) {
                return false;
            }
            try {
                encodable = lMSPublicKeyParametersArray[k];
                continue;
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception.getMessage(), exception);
            }
        }
        return LMS.verifySignature((LMSPublicKeyParameters)encodable, lMSSignatureArray[n], byArray);
    }

    public static class PlaceholderLMSPrivateKey
    extends LMSPrivateKeyParameters {
        public PlaceholderLMSPrivateKey(LMSigParameters lMSigParameters, LMOtsParameters lMOtsParameters, int n, byte[] byArray, int n2, byte[] byArray2) {
            super(lMSigParameters, lMOtsParameters, n, byArray, n2, byArray2);
        }

        @Override
        public LMOtsPrivateKey getNextOtsPrivateKey() {
            throw new RuntimeException("placeholder only");
        }

        @Override
        public LMSPublicKeyParameters getPublicKey() {
            throw new RuntimeException("placeholder only");
        }
    }
}

