/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru.NTRUSignerPrng;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru.NTRUSigningParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru.NTRUSigningPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru.NTRUSigningPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.Polynomial;
import java.nio.ByteBuffer;

public class NTRUSigner {
    private NTRUSigningParameters params;
    private Digest hashAlg;
    private NTRUSigningPrivateKeyParameters signingKeyPair;
    private NTRUSigningPublicKeyParameters verificationKey;

    public NTRUSigner(NTRUSigningParameters nTRUSigningParameters) {
        this.params = nTRUSigningParameters;
    }

    private byte[] signHash(byte[] byArray, NTRUSigningPrivateKeyParameters nTRUSigningPrivateKeyParameters) {
        int n = 0;
        NTRUSigningPublicKeyParameters nTRUSigningPublicKeyParameters = nTRUSigningPrivateKeyParameters.getPublicKey();
        while (++n <= ((NTRUSigner)object).params.signFailTolerance) {
            IntegerPolynomial integerPolynomial;
            IntegerPolynomial integerPolynomial2;
            NTRUSigner nTRUSigner = object;
            IntegerPolynomial integerPolynomial3 = nTRUSigner.createMsgRep(byArray, n);
            if (!((NTRUSigner)object).verify(integerPolynomial3, integerPolynomial2 = nTRUSigner.sign(integerPolynomial3, nTRUSigningPrivateKeyParameters), integerPolynomial = nTRUSigningPublicKeyParameters.h)) continue;
            byte[] byArray2 = integerPolynomial2.toBinary(((NTRUSigner)object).params.q);
            Object object = byArray2;
            ByteBuffer byteBuffer = ByteBuffer.allocate(byArray2.length + 4);
            byteBuffer.put((byte[])object);
            byteBuffer.putInt(n);
            return byteBuffer.array();
        }
        throw new IllegalStateException(b.a(b.b.a("Signing failed: too many retries (max="), ((NTRUSigner)object).params.signFailTolerance, ")"));
    }

    private IntegerPolynomial sign(IntegerPolynomial integerPolynomial, NTRUSigningPrivateKeyParameters object) {
        IntegerPolynomial integerPolynomial2;
        NTRUSigningParameters nTRUSigningParameters = this.params;
        int n = nTRUSigningParameters.N;
        int n2 = nTRUSigningParameters.q;
        NTRUSigningPublicKeyParameters nTRUSigningPublicKeyParameters = ((NTRUSigningPrivateKeyParameters)object).getPublicKey();
        IntegerPolynomial integerPolynomial3 = integerPolynomial2;
        integerPolynomial2 = new IntegerPolynomial(n);
        for (int k = (v816825).B; k >= 1; --k) {
            Polynomial polynomial = ((NTRUSigningPrivateKeyParameters)object).getBasis((int)k).f;
            Polynomial polynomial2 = ((NTRUSigningPrivateKeyParameters)object).getBasis((int)k).fPrime;
            IntegerPolynomial integerPolynomial4 = polynomial.mult(integerPolynomial);
            integerPolynomial4.div(n2);
            IntegerPolynomial integerPolynomial5 = polynomial2.mult(integerPolynomial4);
            IntegerPolynomial integerPolynomial6 = polynomial2.mult(integerPolynomial);
            integerPolynomial6.div(n2);
            integerPolynomial5.sub(polynomial.mult(integerPolynomial6));
            integerPolynomial3.add(integerPolynomial5);
            polynomial = (IntegerPolynomial)((NTRUSigningPrivateKeyParameters)object).getBasis((int)k).h.clone();
            if (k > 1) {
                ((IntegerPolynomial)polynomial).sub(((NTRUSigningPrivateKeyParameters)object).getBasis((int)(k - 1)).h);
            } else {
                ((IntegerPolynomial)polynomial).sub(nTRUSigningPublicKeyParameters.h);
            }
            integerPolynomial = integerPolynomial5.mult((IntegerPolynomial)polynomial, n2);
        }
        IntegerPolynomial integerPolynomial7 = integerPolynomial3;
        NTRUSigningPrivateKeyParameters nTRUSigningPrivateKeyParameters = object;
        Polynomial polynomial = nTRUSigningPrivateKeyParameters.getBasis((int)0).f;
        object = nTRUSigningPrivateKeyParameters.getBasis((int)0).fPrime;
        IntegerPolynomial integerPolynomial8 = polynomial.mult(integerPolynomial);
        integerPolynomial8.div(n2);
        IntegerPolynomial integerPolynomial9 = object.mult(integerPolynomial8);
        IntegerPolynomial integerPolynomial10 = object.mult(integerPolynomial);
        integerPolynomial10.div(n2);
        integerPolynomial9.sub(polynomial.mult(integerPolynomial10));
        integerPolynomial3.add(integerPolynomial9);
        integerPolynomial7.modPositive(n2);
        return integerPolynomial7;
    }

    private boolean verifyHash(byte[] object, byte[] object2, NTRUSigningPublicKeyParameters nTRUSigningPublicKeyParameters) {
        byte[] byArray = object;
        ByteBuffer byteBuffer = ByteBuffer.wrap(object2);
        object = byteBuffer;
        object2 = new byte[((byte[])object2).length - 4];
        ((ByteBuffer)object).get((byte[])object2);
        NTRUSigningParameters nTRUSigningParameters = this.params;
        int n = nTRUSigningParameters.N;
        IntegerPolynomial integerPolynomial = IntegerPolynomial.fromBinary(object2, n, nTRUSigningParameters.q);
        object = this.createMsgRep(byArray, byteBuffer.getInt());
        object2 = nTRUSigningPublicKeyParameters.h;
        return this.verify((IntegerPolynomial)object, integerPolynomial, (IntegerPolynomial)object2);
    }

    private boolean verify(IntegerPolynomial integerPolynomial, IntegerPolynomial integerPolynomial2, IntegerPolynomial integerPolynomial3) {
        IntegerPolynomial integerPolynomial4;
        NTRUSigningParameters nTRUSigningParameters = this.params;
        int n = nTRUSigningParameters.q;
        double d2 = nTRUSigningParameters.normBoundSq;
        double d3 = nTRUSigningParameters.betaSq;
        integerPolynomial3 = integerPolynomial3.mult(integerPolynomial2, n);
        integerPolynomial3.sub(integerPolynomial);
        double d4 = integerPolynomial2.centeredNormSq(n);
        return (double)((long)(d3 * (double)integerPolynomial4.centeredNormSq(n) + d4)) <= d2;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        if (bl) {
            this.signingKeyPair = (NTRUSigningPrivateKeyParameters)cipherParameters;
        } else {
            this.verificationKey = (NTRUSigningPublicKeyParameters)cipherParameters;
        }
        this.hashAlg = this.params.hashAlg;
        this.hashAlg.reset();
    }

    public void update(byte by) {
        Digest digest = ((NTRUSigner)((Object)digest)).hashAlg;
        if (digest != null) {
            digest.update(by);
            return;
        }
        throw new IllegalStateException("Call initSign or initVerify first!");
    }

    public void update(byte[] byArray, int n, int n2) {
        Digest digest = ((NTRUSigner)((Object)digest)).hashAlg;
        if (digest != null) {
            digest.update(byArray, n, n2);
            return;
        }
        throw new IllegalStateException("Call initSign or initVerify first!");
    }

    public byte[] generateSignature() {
        Digest digest = ((NTRUSigner)object).hashAlg;
        if (digest != null && ((NTRUSigner)object).signingKeyPair != null) {
            NTRUSigner nTRUSigner = object;
            Object object = new byte[digest.getDigestSize()];
            nTRUSigner.hashAlg.doFinal((byte[])object, 0);
            return nTRUSigner.signHash((byte[])object, nTRUSigner.signingKeyPair);
        }
        throw new IllegalStateException("Call initSign first!");
    }

    public boolean verifySignature(byte[] byArray) {
        Object object = ((NTRUSigner)object2).hashAlg;
        if (object != null && ((NTRUSigner)object2).verificationKey != null) {
            NTRUSigner nTRUSigner = object2;
            Object object2 = new byte[object.getDigestSize()];
            nTRUSigner.hashAlg.doFinal((byte[])object2, 0);
            object = nTRUSigner.verificationKey;
            return nTRUSigner.verifyHash((byte[])object2, byArray, (NTRUSigningPublicKeyParameters)object);
        }
        throw new IllegalStateException("Call initVerify first!");
    }

    public IntegerPolynomial createMsgRep(byte[] object, int n) {
        NTRUSignerPrng nTRUSignerPrng;
        IntegerPolynomial integerPolynomial;
        NTRUSigningParameters nTRUSigningParameters = this.params;
        int n2 = nTRUSigningParameters.N;
        int n3 = 31 - Integer.numberOfLeadingZeros(nTRUSigningParameters.q);
        int n4 = (n3 + 7) / 8;
        IntegerPolynomial integerPolynomial2 = integerPolynomial;
        integerPolynomial = new IntegerPolynomial(n2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(((byte[])object).length + 4);
        byteBuffer.put((byte[])object);
        byteBuffer.putInt(n);
        object = nTRUSignerPrng;
        nTRUSignerPrng = new NTRUSignerPrng(byteBuffer.array(), this.params.hashAlg);
        for (int k = 0; k < n2; ++k) {
            byte[] byArray = ((NTRUSignerPrng)object).nextBytes(n4);
            byte[] byArray2 = byArray;
            int n5 = n4 * 8 - n3;
            int n6 = byArray[byArray.length - 1] >> n5 << n5;
            n5 = byArray2.length - 1;
            byArray[n5] = (byte)n6;
            byteBuffer = ByteBuffer.allocate(4);
            byteBuffer.put(byArray2);
            byteBuffer.rewind();
            integerPolynomial2.coeffs[k] = Integer.reverseBytes(byteBuffer.getInt());
        }
        return integerPolynomial2;
    }
}

