/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.qtesla;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.qtesla.QTESLAKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.qtesla.QTESLAPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.qtesla.QTESLAPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.qtesla.QTESLASecurityCategory;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.qtesla.QTesla1p;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.qtesla.QTesla3p;
import java.security.SecureRandom;

public final class QTESLAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private int securityCategory;
    private SecureRandom secureRandom;

    private byte[] allocatePrivate(int n) {
        return new byte[QTESLASecurityCategory.getPrivateSize(n)];
    }

    private byte[] allocatePublic(int n) {
        return new byte[QTESLASecurityCategory.getPublicSize(n)];
    }

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        QTESLAKeyPairGenerator qTESLAKeyPairGenerator = qTESLAKeyGenerationParameters;
        QTESLAKeyGenerationParameters qTESLAKeyGenerationParameters = (QTESLAKeyGenerationParameters)keyGenerationParameters;
        qTESLAKeyPairGenerator.secureRandom = qTESLAKeyGenerationParameters.getRandom();
        qTESLAKeyPairGenerator.securityCategory = qTESLAKeyGenerationParameters.getSecurityCategory();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        QTESLAPrivateKeyParameters qTESLAPrivateKeyParameters;
        QTESLAKeyPairGenerator qTESLAKeyPairGenerator = this;
        byte[] byArray = qTESLAKeyPairGenerator.allocatePrivate(qTESLAKeyPairGenerator.securityCategory);
        byte[] byArray2 = qTESLAKeyPairGenerator.allocatePublic(qTESLAKeyPairGenerator.securityCategory);
        int n = qTESLAKeyPairGenerator.securityCategory;
        if (n != 5) {
            if (n != 6) throw new IllegalArgumentException(b.a("unknown security category: ").append(this.securityCategory).toString());
            QTesla3p.generateKeyPair(byArray2, byArray, this.secureRandom);
        } else {
            QTesla1p.generateKeyPair(byArray2, byArray, this.secureRandom);
        }
        QTESLAPrivateKeyParameters qTESLAPrivateKeyParameters2 = qTESLAPrivateKeyParameters;
        qTESLAPrivateKeyParameters = new QTESLAPrivateKeyParameters(this.securityCategory, byArray);
        return new AsymmetricCipherKeyPair(new QTESLAPublicKeyParameters(this.securityCategory, byArray2), qTESLAPrivateKeyParameters2);
    }
}

